/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.api.v2.params.BaseMergeTransplant;
import org.projectnessie.api.v2.params.ImmutableTransplant;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Transplant", properties={@SchemaProperty(name="message", description="Commit message for this transplant request."), @SchemaProperty(name="hashesToTransplant", uniqueItems=true, description="Lists the hashes of commits that should be transplanted into the target branch."), @SchemaProperty(name="fromRefName", description="The name of the reference that contains the 'source' commits for the requested merge or transplant operation.\n"), @SchemaProperty(name="keyMergeModes", description="Specific merge behaviour requests by content key.\n\nThe default is set by the `defaultKeyMergeMode` parameter.\n"), @SchemaProperty(name="defaultKeyMergeMode", description="The default merge mode. If not set, `NORMAL` is assumed.\n\nThis settings applies to key thaWhen set to 'true' instructs the server to validate the request\n        but to avoid committing any changes.t are not explicitly mentioned in the `keyMergeModes` property.\n"), @SchemaProperty(name="dryRun", description="When set to 'true' instructs the server to validate the request but to avoid committing any changes.\n"), @SchemaProperty(name="fetchAdditionalInfo", description="Whether to provide optional response data.\n"), @SchemaProperty(name="returnConflictAsResult", description="When set to 'true' instructs the server to produce normal (non-error) responses in case a conflict is detected and report conflict details in the response payload.")})
@JsonSerialize(as=ImmutableTransplant.class)
@JsonDeserialize(as=ImmutableTransplant.class)
@Value.Immutable
public interface Transplant
extends BaseMergeTransplant {
    @Override
    @Nullable
    @Size
    public String getMessage();

    public @NotNull @Size List<@Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String> getHashesToTransplant();

    @Value.Check
    default public void checkHashes() {
        List<String> hashes = this.getHashesToTransplant();
        if (hashes != null) {
            for (String hash : hashes) {
                Validation.validateHashOrRelativeSpec(hash);
            }
        }
    }
}

