/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.catalog.Catalog;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.CatalogBridge;
import org.apache.spark.sql.execution.datasources.v2.CatalogUtils;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.config.NessieClientConfigSource;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import scala.Tuple2;

final class RestCatalogBridge
implements CatalogBridge {
    private final SparkContext sparkContext;
    private final NessieApiV1 api;
    private final CatalogPlugin currentCatalog;
    private final String catalogName;
    private final String confPrefix;
    private final Catalog icebergCatalog;

    RestCatalogBridge(SparkContext sparkContext, CatalogPlugin currentCatalog, String catalogName, Catalog icebergCatalog) {
        this.sparkContext = sparkContext;
        this.currentCatalog = currentCatalog;
        this.catalogName = catalogName;
        this.confPrefix = "spark.sql.catalog." + catalogName + ".";
        this.icebergCatalog = icebergCatalog;
        Map<String, String> catalogProperties = CatalogUtils.propertiesFromCatalog(icebergCatalog);
        if (!Boolean.parseBoolean(catalogProperties.get("nessie.is-nessie-catalog"))) {
            throw new IllegalArgumentException("The command works only when the catalog is a NessieCatalog or a RESTCatalog using the Nessie Catalog Server, but the referenced REST endpoint is not a Nessie Catalog Server. Either set the catalog via USE <catalog_name> or provide the catalog during execution: <command> IN <catalog_name>.");
        }
        CatalogUtils.Credential credential = CatalogUtils.resolveCredential(catalogProperties);
        Function<String, String> defaultConfigValue = x -> catalogProperties.containsKey(x) ? (String)catalogProperties.get(x) : (String)catalogProperties.get(x.replace("nessie.", ""));
        NessieClientConfigSource configSource = x -> {
            switch (x) {
                case "nessie.uri": {
                    return (String)catalogProperties.get("nessie.core-base-uri") + "v2";
                }
                case "nessie.client-api-version": {
                    return "2";
                }
                case "nessie.authentication.oauth2.client-id": {
                    return credential.clientId;
                }
                case "nessie.authentication.oauth2.client-secret": {
                    return credential.secret;
                }
                case "nessie.authentication.oauth2.client-scopes": {
                    return CatalogUtils.resolveOAuthScope(catalogProperties);
                }
                case "nessie.authentication.oauth2.auth-endpoint": {
                    return (String)catalogProperties.get("oauth2-server-uri");
                }
                case "nessie.authentication.token": {
                    return (String)catalogProperties.get("token");
                }
                case "nessie.authentication.type": {
                    if (catalogProperties.containsKey("token")) {
                        return "BEARER";
                    }
                    return (String)defaultConfigValue.apply(x);
                }
            }
            return (String)defaultConfigValue.apply(x);
        };
        this.api = CatalogUtils.buildApi(configSource);
    }

    @Override
    public Reference getCurrentRef() throws NessieReferenceNotFoundException {
        Map<String, String> catalogProperties = CatalogUtils.propertiesFromCatalog(this.icebergCatalog);
        String prefix = catalogProperties.get("prefix");
        ParsedReference parsed = CatalogUtils.referenceFromRestPrefix(prefix);
        String refHash = parsed.hashWithRelativeSpec();
        try {
            Reference ref = this.api.getReference().refName(parsed.name()).get();
            if (refHash != null) {
                ref = ref.getType() == Reference.ReferenceType.BRANCH ? Branch.of(ref.getName(), refHash) : Tag.of(ref.getName(), refHash);
            }
            return ref;
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException("Could not find current reference " + parsed.name() + " configured in spark configuration for catalog '" + this.catalogName + "'.", e);
        }
    }

    @Override
    public void setCurrentRefForSpark(Reference ref, boolean configureRefAtHash) {
        Map<String, String> catalogProperties = CatalogUtils.propertiesFromCatalog(this.icebergCatalog);
        SparkConf sparkConf = this.sparkContext.conf();
        String warehouseSuffix = CatalogUtils.warehouseFromRestPrefix(catalogProperties.get("prefix")).orElse("");
        String refName = RestCatalogBridge.encode(ref.getName());
        String uri = catalogProperties.get("nessie.iceberg-base-uri") + refName;
        String prefix = (configureRefAtHash ? refName + "@" + ref.getHash() : refName) + warehouseSuffix;
        sparkConf.set(this.confPrefix + "uri", uri);
        sparkConf.set(this.confPrefix + "prefix", prefix);
        Map<String, String> catalogConf = Arrays.stream(sparkConf.getAllWithPrefix(this.confPrefix)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        if (this.icebergCatalog instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.icebergCatalog).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.currentCatalog.initialize(this.catalogName, new CaseInsensitiveStringMap(catalogConf));
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NessieApiV1 api() {
        return this.api;
    }

    @Override
    public CatalogPlugin currentCatalog() {
        return this.currentCatalog;
    }

    @Override
    public void close() {
        this.api.close();
    }
}

