/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import java.util.ArrayList;
import java.util.List;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableAlterNamespaceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableCreateNamespaceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableCreateReferenceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableDropReferenceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableExitCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableHelpCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableListContentsCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableListReferencesCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableShowContentCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableShowLogCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ImmutableShowReferenceCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;
import org.projectnessie.nessie.cli.grammar.Token;
import org.projectnessie.nessie.cli.grammar.ast.AlterStatement;
import org.projectnessie.nessie.cli.grammar.ast.CreateStatement;
import org.projectnessie.nessie.cli.grammar.ast.DropStatement;
import org.projectnessie.nessie.cli.grammar.ast.Keyword;
import org.projectnessie.nessie.cli.grammar.ast.ListStatement;
import org.projectnessie.nessie.cli.grammar.ast.ShowStatement;

public interface CommandContainer
extends Node {
    default public List<CommandSpec> commandSpecs() {
        ArrayList<CommandSpec> commandSpecs = new ArrayList<CommandSpec>();
        for (Node child : this.children()) {
            CommandSpec spec;
            Keyword kw;
            CommandSpec spec2;
            if (child instanceof CommandSpec) {
                commandSpecs.add((CommandSpec)((Object)child));
                continue;
            }
            if (child instanceof ShowStatement) {
                spec2 = child.firstChildOfType(CommandSpec.class);
                if (spec2 == null) {
                    kw = child.firstChildOfType(Keyword.class);
                    switch (kw.getType()) {
                        case LOG: {
                            spec2 = ImmutableShowLogCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                        case TABLE: 
                        case VIEW: 
                        case NAMESPACE: {
                            spec2 = ImmutableShowContentCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                        case REFERENCE: {
                            spec2 = ImmutableShowReferenceCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                    }
                }
                if (spec2 == null) continue;
                commandSpecs.add(spec2);
                continue;
            }
            if (child instanceof ListStatement) {
                spec2 = child.firstChildOfType(CommandSpec.class);
                if (spec2 == null) {
                    kw = child.firstChildOfType(Keyword.class);
                    switch (kw.getType()) {
                        case CONTENTS: {
                            spec2 = ImmutableListContentsCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                        case REFERENCES: {
                            spec2 = ImmutableListReferencesCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                    }
                }
                if (spec2 == null) continue;
                commandSpecs.add(spec2);
                continue;
            }
            if (child instanceof CreateStatement) {
                spec2 = child.firstChildOfType(CommandSpec.class);
                if (spec2 == null) {
                    kw = child.firstChildOfType(Keyword.class);
                    switch (kw.getType()) {
                        case BRANCH: 
                        case TAG: {
                            spec2 = ImmutableCreateReferenceCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                        case NAMESPACE: {
                            spec2 = ImmutableCreateNamespaceCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                    }
                }
                if (spec2 == null) continue;
                commandSpecs.add(spec2);
                continue;
            }
            if (child instanceof AlterStatement) {
                spec2 = child.firstChildOfType(CommandSpec.class);
                if (spec2 == null) {
                    kw = child.firstChildOfType(Keyword.class);
                    switch (kw.getType()) {
                        case ALTER: {
                            spec2 = ImmutableAlterNamespaceCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                    }
                }
                if (spec2 == null) continue;
                commandSpecs.add(spec2);
                continue;
            }
            if (child instanceof DropStatement) {
                spec2 = child.firstChildOfType(CommandSpec.class);
                if (spec2 == null) {
                    kw = child.firstChildOfType(Keyword.class);
                    switch (kw.getType()) {
                        case NAMESPACE: 
                        case BRANCH: 
                        case TAG: {
                            spec2 = ImmutableDropReferenceCommandSpec.builder().sourceNode(child).build();
                            break;
                        }
                    }
                }
                if (spec2 == null) continue;
                commandSpecs.add(spec2);
                continue;
            }
            if (!(child instanceof Token)) continue;
            Token t = (Token)child;
            switch (t.getType()) {
                case EXIT: {
                    spec = ImmutableExitCommandSpec.builder().sourceNode(child).build();
                    break;
                }
                case HELP: {
                    spec = ImmutableHelpCommandSpec.builder().sourceNode(child).build();
                    break;
                }
                case LIST: {
                    spec = ImmutableListReferencesCommandSpec.builder().sourceNode(child).build();
                    break;
                }
                default: {
                    spec = null;
                }
            }
            if (spec == null) continue;
            commandSpecs.add(spec);
        }
        return commandSpecs;
    }
}

