/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.AlterNamespaceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AlterNamespaceCommandSpec", generator="Immutables")
@Immutable
public final class ImmutableAlterNamespaceCommandSpec
implements AlterNamespaceCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    private final String namespace;
    @Nullable
    private final String ref;
    private final ImmutableMap<String, String> setProperties;
    private final ImmutableSet<String> removeProperties;

    private ImmutableAlterNamespaceCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, Map<String, ? extends String> setProperties, Iterable<String> removeProperties) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.ref = ref;
        this.setProperties = ImmutableMap.copyOf(setProperties);
        this.removeProperties = ImmutableSet.copyOf(removeProperties);
    }

    private ImmutableAlterNamespaceCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.namespace = builder.namespace;
        this.ref = builder.ref;
        this.setProperties = builder.setProperties.build();
        this.removeProperties = builder.removeProperties.build();
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : AlterNamespaceCommandSpec.super.sourceNode();
    }

    private ImmutableAlterNamespaceCommandSpec(ImmutableAlterNamespaceCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, ImmutableMap<String, String> setProperties, ImmutableSet<String> removeProperties) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.namespace = namespace;
        this.ref = ref;
        this.setProperties = setProperties;
        this.removeProperties = removeProperties;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    public ImmutableMap<String, String> setProperties() {
        return this.setProperties;
    }

    public ImmutableSet<String> removeProperties() {
        return this.removeProperties;
    }

    public final ImmutableAlterNamespaceCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableAlterNamespaceCommandSpec(this, value, this.sourceNode, this.namespace, this.ref, this.setProperties, this.removeProperties);
    }

    public final ImmutableAlterNamespaceCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableAlterNamespaceCommandSpec(this, this.inCatalog, value, this.namespace, this.ref, this.setProperties, this.removeProperties);
    }

    public final ImmutableAlterNamespaceCommandSpec withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (this.namespace.equals(newValue)) {
            return this;
        }
        return new ImmutableAlterNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.ref, this.setProperties, this.removeProperties);
    }

    public final ImmutableAlterNamespaceCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableAlterNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, this.namespace, value, this.setProperties, this.removeProperties);
    }

    public final ImmutableAlterNamespaceCommandSpec withSetProperties(Map<String, ? extends String> entries) {
        if (this.setProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAlterNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, this.namespace, this.ref, (ImmutableMap<String, String>)newValue, this.removeProperties);
    }

    public final ImmutableAlterNamespaceCommandSpec withRemoveProperties(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableAlterNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, this.namespace, this.ref, this.setProperties, (ImmutableSet<String>)newValue);
    }

    public final ImmutableAlterNamespaceCommandSpec withRemoveProperties(Iterable<String> elements) {
        if (this.removeProperties == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableAlterNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, this.namespace, this.ref, this.setProperties, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAlterNamespaceCommandSpec && this.equalTo(0, (ImmutableAlterNamespaceCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableAlterNamespaceCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.namespace.equals(another.namespace) && Objects.equals(this.ref, another.ref) && this.setProperties.equals(another.setProperties) && this.removeProperties.equals(another.removeProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.namespace.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + this.setProperties.hashCode();
        h += (h << 5) + this.removeProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AlterNamespaceCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("namespace", (Object)this.namespace).add("ref", (Object)this.ref).add("setProperties", this.setProperties).add("removeProperties", this.removeProperties).toString();
    }

    public static ImmutableAlterNamespaceCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, Map<String, String> setProperties, Set<String> removeProperties) {
        return ImmutableAlterNamespaceCommandSpec.of(inCatalog, sourceNode, namespace, ref, setProperties, removeProperties);
    }

    public static ImmutableAlterNamespaceCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, Map<String, ? extends String> setProperties, Iterable<String> removeProperties) {
        return new ImmutableAlterNamespaceCommandSpec(inCatalog, sourceNode, namespace, ref, setProperties, removeProperties);
    }

    public static ImmutableAlterNamespaceCommandSpec copyOf(AlterNamespaceCommandSpec instance) {
        if (instance instanceof ImmutableAlterNamespaceCommandSpec) {
            return (ImmutableAlterNamespaceCommandSpec)instance;
        }
        return ImmutableAlterNamespaceCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AlterNamespaceCommandSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 1L;
        private long optBits;
        @javax.annotation.Nullable
        private String inCatalog;
        @javax.annotation.Nullable
        private Node sourceNode;
        @javax.annotation.Nullable
        private String namespace;
        @javax.annotation.Nullable
        private String ref;
        private ImmutableMap.Builder<String, String> setProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<String> removeProperties = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AlterNamespaceCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String inCatalogValue;
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AlterNamespaceCommandSpec) {
                instance = (AlterNamespaceCommandSpec)object;
                this.namespace(instance.getNamespace());
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 4L;
                }
                this.putAllSetProperties(instance.setProperties());
                this.addAllRemoveProperties(instance.removeProperties());
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 4L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetProperty(String key, String value) {
            this.setProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetProperty(Map.Entry<String, ? extends String> entry) {
            this.setProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setProperties(Map<String, ? extends String> entries) {
            this.setProperties = ImmutableMap.builder();
            return this.putAllSetProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSetProperties(Map<String, ? extends String> entries) {
            this.setProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoveProperty(String element) {
            this.removeProperties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoveProperties(String ... elements) {
            this.removeProperties.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder removeProperties(Iterable<String> elements) {
            this.removeProperties = ImmutableSet.builder();
            return this.addAllRemoveProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRemoveProperties(Iterable<String> elements) {
            this.removeProperties.addAll(elements);
            return this;
        }

        public ImmutableAlterNamespaceCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAlterNamespaceCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            return "Cannot build AlterNamespaceCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

