/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ShowLogCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ShowLogCommandSpec", generator="Immutables")
@Immutable
public final class ImmutableShowLogCommandSpec
implements ShowLogCommandSpec {
    @jakarta.annotation.Nullable
    private final String inCatalog;
    @jakarta.annotation.Nullable
    private final Node sourceNode;
    @jakarta.annotation.Nullable
    private final String ref;
    @jakarta.annotation.Nullable
    private final String refTimestampOrHash;
    @jakarta.annotation.Nullable
    private final Integer limit;

    private ImmutableShowLogCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.limit = builder.limit;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : ShowLogCommandSpec.super.sourceNode();
    }

    private ImmutableShowLogCommandSpec(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, @jakarta.annotation.Nullable String ref, @jakarta.annotation.Nullable String refTimestampOrHash, @jakarta.annotation.Nullable Integer limit) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.limit = limit;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @jakarta.annotation.Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    @Override
    @jakarta.annotation.Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public final ImmutableShowLogCommandSpec withInCatalog(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(value, this.sourceNode, this.ref, this.refTimestampOrHash, this.limit);
    }

    public final ImmutableShowLogCommandSpec withSourceNode(@jakarta.annotation.Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, value, this.ref, this.refTimestampOrHash, this.limit);
    }

    public final ImmutableShowLogCommandSpec withRef(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, this.sourceNode, value, this.refTimestampOrHash, this.limit);
    }

    public final ImmutableShowLogCommandSpec withRefTimestampOrHash(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, this.sourceNode, this.ref, value, this.limit);
    }

    public final ImmutableShowLogCommandSpec withLimit(@jakarta.annotation.Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, this.sourceNode, this.ref, this.refTimestampOrHash, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShowLogCommandSpec && this.equalTo(0, (ImmutableShowLogCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableShowLogCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ShowLogCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).add("limit", (Object)this.limit).toString();
    }

    public static ImmutableShowLogCommandSpec of(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, @jakarta.annotation.Nullable String ref, @jakarta.annotation.Nullable String refTimestampOrHash, @jakarta.annotation.Nullable Integer limit) {
        return new ImmutableShowLogCommandSpec(inCatalog, sourceNode, ref, refTimestampOrHash, limit);
    }

    public static ImmutableShowLogCommandSpec copyOf(ShowLogCommandSpec instance) {
        if (instance instanceof ImmutableShowLogCommandSpec) {
            return (ImmutableShowLogCommandSpec)instance;
        }
        return ImmutableShowLogCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShowLogCommandSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long optBits;
        @Nullable
        private String inCatalog;
        @Nullable
        private Node sourceNode;
        @Nullable
        private String ref;
        @Nullable
        private String refTimestampOrHash;
        @Nullable
        private Integer limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShowLogCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ShowLogCommandSpec) {
                instance = (ShowLogCommandSpec)object;
                Integer limitValue = instance.getLimit();
                if (limitValue != null) {
                    this.limit(limitValue);
                }
                if ((bits & 1L) == 0L) {
                    String refValue2 = instance.getRef();
                    if (refValue2 != null) {
                        this.ref(refValue2);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Node sourceNodeValue2 = instance.sourceNode();
                    if (sourceNodeValue2 != null) {
                        this.sourceNode(sourceNodeValue2);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@jakarta.annotation.Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@jakarta.annotation.Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@jakarta.annotation.Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@jakarta.annotation.Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(@jakarta.annotation.Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public ImmutableShowLogCommandSpec build() {
            return new ImmutableShowLogCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

