/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.grammar;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;
import org.projectnessie.nessie.cli.grammar.InvalidToken;
import org.projectnessie.nessie.cli.grammar.Token;
import org.projectnessie.nessie.cli.grammar.TokenSource;

public class NessieCliLexer
extends TokenSource {
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static NfaFunction[] nfaFunctions;

    public NessieCliLexer(CharSequence input) {
        this("input", input);
    }

    public NessieCliLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public NessieCliLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        this.activeTokenTypes.remove(Token.TokenType.POSITIVE_INT);
        this.activeTokenTypes.remove(Token.TokenType.STRING_LITERAL);
        this.activeTokenTypes.remove(Token.TokenType.IDENTIFIER);
        this.activeTokenTypes.remove(Token.TokenType.URI);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(320);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(320);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(320);
        BitSet nextStates = new BitSet(320);
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = NessieCliLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = NessieCliLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.USE, Token.TokenType.DROP, Token.TokenType.LIST, Token.TokenType.SHOW, Token.TokenType.HELP, Token.TokenType.EXIT, Token.TokenType.ALTER, Token.TokenType.MERGE, Token.TokenType.ASSIGN, Token.TokenType.CREATE, Token.TokenType.REVERT, Token.TokenType.CONNECT, Token.TokenType.SEMICOLON, Token.TokenType.EQUAL, Token.TokenType.AT, Token.TokenType.IF, Token.TokenType.IN, Token.TokenType.OF, Token.TokenType.ON, Token.TokenType.TO, Token.TokenType.AND, Token.TokenType.DRY, Token.TokenType.LOG, Token.TokenType.NOT, Token.TokenType.SET, Token.TokenType.FROM, Token.TokenType.INTO, Token.TokenType.VIEW, Token.TokenType.WITH, Token.TokenType.ALLOW, Token.TokenType.FORCE, Token.TokenType.LIMIT, Token.TokenType.STATE, Token.TokenType.TABLE, Token.TokenType.USING, Token.TokenType.COMMIT, Token.TokenType.EXISTS, Token.TokenType.FILTER, Token.TokenType.NORMAL, Token.TokenType.REMOVE, Token.TokenType.CONTENT, Token.TokenType.DELETES, Token.TokenType.LICENSE, Token.TokenType.BEHAVIOR, Token.TokenType.CONTENTS, Token.TokenType.STARTING, Token.TokenType.BEHAVIORS, Token.TokenType.NAMESPACE, Token.TokenType.TIMESTAMP, Token.TokenType.REFERENCE, Token.TokenType.REFERENCES, Token.TokenType.CONTAINING, Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.BRANCH, Token.TokenType.TAG, Token.TokenType.STRING_LITERAL, Token.TokenType.IDENTIFIER, Token.TokenType.URI, Token.TokenType.POSITIVE_INT});
        unparsedTokens = EnumSet.of(Token.TokenType.SINGLE_LINE_DASH_COMMENT, Token.TokenType.SINGLE_LINE_COMMENT, Token.TokenType.MULTI_LINE_COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType.WHITESPACE);
        moreTokens = EnumSet.noneOf(Token.TokenType.class);
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class DEFAULT {
        private static final int[] NFA_MOVES_297 = DEFAULT.NFA_MOVES_297_init();

        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL)) {
                    nextStates.set(11);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL)) {
                    nextStates.set(30);
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_DASH_COMMENT)) {
                    nextStates.set(57);
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                    nextStates.set(84);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    nextStates.set(34);
                }
            } else if (ch == 65 || ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ALLOW)) {
                    nextStates.set(118);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.AND)) {
                    nextStates.set(156);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ALTER)) {
                    nextStates.set(185);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.AT)) {
                    nextStates.set(50);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ASSIGN)) {
                    nextStates.set(236);
                }
            } else if (ch == 66 || ch == 98) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BRANCH)) {
                    nextStates.set(106);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.BEHAVIORS)) {
                    nextStates.set(164);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.BEHAVIOR)) {
                    nextStates.set(226);
                }
            } else if (ch == 67 || ch == 99) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CONNECT)) {
                    nextStates.set(86);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONTENTS)) {
                    nextStates.set(100);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CREATE)) {
                    nextStates.set(125);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONTENT)) {
                    nextStates.set(151);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMIT)) {
                    nextStates.set(198);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONTAINING)) {
                    nextStates.set(205);
                }
            } else if (ch == 68 || ch == 100) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DELETES)) {
                    nextStates.set(71);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DRY)) {
                    nextStates.set(175);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DROP)) {
                    nextStates.set(232);
                }
            } else if (ch == 69 || ch == 101) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EXISTS)) {
                    nextStates.set(129);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXIT)) {
                    nextStates.set(189);
                }
            } else if (ch == 70 || ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FILTER)) {
                    nextStates.set(91);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(97);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FROM)) {
                    nextStates.set(196);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FORCE)) {
                    nextStates.set(243);
                }
            } else if (ch == 72 || ch == 104) {
                if (validTypes == null || validTypes.contains(Token.TokenType.URI)) {
                    nextStates.set(213);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.HELP)) {
                    nextStates.set(246);
                }
            } else if (ch == 73 || ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INTO)) {
                    nextStates.set(67);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IN)) {
                    nextStates.set(16);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IF)) {
                    nextStates.set(36);
                }
            } else if (ch == 76 || ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LIMIT)) {
                    nextStates.set(145);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LIST)) {
                    nextStates.set(183);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LICENSE)) {
                    nextStates.set(191);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LOG)) {
                    nextStates.set(234);
                }
            } else if (ch == 77 || ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MERGE)) {
                    nextStates.set(240);
                }
            } else if (ch == 78 || ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NORMAL)) {
                    nextStates.set(136);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOT)) {
                    nextStates.set(140);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NAMESPACE)) {
                    nextStates.set(176);
                }
            } else if (ch == 79 || ch == 111) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OF)) {
                    nextStates.set(47);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ON)) {
                    nextStates.set(59);
                }
            } else if (ch == 82 || ch == 114) {
                if (validTypes == null || validTypes.contains(Token.TokenType.REFERENCE)) {
                    nextStates.set(76);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.REFERENCES)) {
                    nextStates.set(110);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.REMOVE)) {
                    nextStates.set(141);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.REVERT)) {
                    nextStates.set(171);
                }
            } else if (ch == 83 || ch == 115) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SHOW)) {
                    nextStates.set(69);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STATE)) {
                    nextStates.set(202);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STARTING)) {
                    nextStates.set(220);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SET)) {
                    nextStates.set(235);
                }
            } else if (ch == 84 || ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TAG)) {
                    nextStates.set(83);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(95);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO)) {
                    nextStates.set(19);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TABLE)) {
                    nextStates.set(148);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TIMESTAMP)) {
                    nextStates.set(157);
                }
            } else if (ch == 85 || ch == 117) {
                if (validTypes == null || validTypes.contains(Token.TokenType.USING)) {
                    nextStates.set(133);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.USE)) {
                    nextStates.set(188);
                }
            } else if (ch == 86 || ch == 118) {
                if (validTypes == null || validTypes.contains(Token.TokenType.VIEW)) {
                    nextStates.set(121);
                }
            } else if (ch == 87 || ch == 119) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WITH)) {
                    nextStates.set(123);
                }
            } else if (ch == 96) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL)) {
                    nextStates.set(8);
                }
            } else if (ch >= 49 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.POSITIVE_INT))) {
                nextStates.set(22);
                type = Token.TokenType.POSITIVE_INT;
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    nextStates.set(27);
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(28);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(28);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(28);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 32) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(28);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EQUAL)) {
                    type = Token.TokenType.EQUAL;
                }
            } else if (ch == 59 && (validTypes == null || validTypes.contains(Token.TokenType.SEMICOLON))) {
                type = Token.TokenType.SEMICOLON;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                return Token.TokenType.INTO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 87 || ch == 119) {
                return Token.TokenType.SHOW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                return Token.TokenType.DELETES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.REFERENCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                return Token.TokenType.TAG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch == 47) {
                return Token.TokenType.MULTI_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.CONNECT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 95 || ch >= 97) {
                nextStates.set(8);
            } else if (ch == 96) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                return Token.TokenType.FILTER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(11);
            } else if (ch == 34) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                return Token.TokenType.CONTENTS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 72 || ch == 104) {
                return Token.TokenType.BRANCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                return Token.TokenType.REFERENCES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                return Token.TokenType.IN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 87 || ch == 119) {
                return Token.TokenType.ALLOW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 87 || ch == 119) {
                return Token.TokenType.VIEW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                return Token.TokenType.TO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 72 || ch == 104) {
                return Token.TokenType.WITH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.CREATE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(22);
                return Token.TokenType.POSITIVE_INT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                return Token.TokenType.EXISTS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                return Token.TokenType.USING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                return Token.TokenType.NORMAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.NOT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 45 && ch <= 58 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(27);
            }
            if (ch == 45 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                type = Token.TokenType.IDENTIFIER;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9) {
                nextStates.set(28);
                type = Token.TokenType.WHITESPACE;
            } else if (ch == 10) {
                nextStates.set(28);
                type = Token.TokenType.WHITESPACE;
            } else if (ch == 13) {
                nextStates.set(28);
                type = Token.TokenType.WHITESPACE;
            } else if (ch == 32) {
                nextStates.set(28);
                type = Token.TokenType.WHITESPACE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.REMOVE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 95 || ch >= 97) {
                nextStates.set(30);
            }
            if (ch == 39) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.LIMIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.TABLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.CONTENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(35);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(35);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 70 || ch == 102) {
                return Token.TokenType.IF;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 68 || ch == 100) {
                return Token.TokenType.AND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                return Token.TokenType.TIMESTAMP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                return Token.TokenType.BEHAVIORS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.REVERT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 89 || ch == 121) {
                return Token.TokenType.DRY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.NAMESPACE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.LIST;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                return Token.TokenType.ALTER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.USE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.EXIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 70 || ch == 102) {
                return Token.TokenType.OF;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.LICENSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                return Token.TokenType.FROM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.AT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.COMMIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.STATE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                return Token.TokenType.CONTAINING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (TokenSource.checkIntervals(NFA_MOVES_297, ch)) {
                nextStates.set(54);
                return Token.TokenType.URI;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                return Token.TokenType.STARTING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                return Token.TokenType.BEHAVIOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(58);
                return Token.TokenType.SINGLE_LINE_DASH_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(58);
                return Token.TokenType.SINGLE_LINE_DASH_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                return Token.TokenType.ON;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                return Token.TokenType.DROP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                return Token.TokenType.LOG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                return Token.TokenType.SET;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                return Token.TokenType.ASSIGN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.MERGE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                return Token.TokenType.FORCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                return Token.TokenType.HELP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(70);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(73);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(78);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(79);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(80);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(82);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(4);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(5);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch == 42) {
                nextStates.set(85);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(85);
            }
            if (ch == 42) {
                nextStates.set(6);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(87);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(88);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(89);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(90);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(7);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(92);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(93);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(94);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(96);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(10);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(98);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(99);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(12);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(101);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(102);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(103);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(104);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(105);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(13);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(107);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(108);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(109);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(14);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(111);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(112);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(113);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(114);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(115);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(116);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(117);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(15);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(119);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(120);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(122);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(124);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(126);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(127);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(128);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(21);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(130);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(131);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(132);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(23);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(134);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(135);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(137);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(138);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(139);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(26);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(142);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(143);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(144);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 86 || ch == 118) {
                nextStates.set(29);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(146);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(147);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(31);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(149);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 66 || ch == 98) {
                nextStates.set(150);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(152);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(153);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(154);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(155);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(37);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(158);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(159);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(160);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(161);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(162);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(163);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(38);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(165);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(166);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(167);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 86 || ch == 118) {
                nextStates.set(168);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(169);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(170);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(39);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(172);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 86 || ch == 118) {
                nextStates.set(173);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(174);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(40);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(41);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(177);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(178);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(179);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(180);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(181);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(182);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(42);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(184);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(43);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(186);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(187);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(45);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(190);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(46);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(192);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(193);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(194);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(195);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(48);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(197);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(49);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(199);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(200);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(201);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(203);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(204);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(52);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(206);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(207);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(208);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(209);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(210);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(211);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(212);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(214);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(215);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(216);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                nextStates.set(218);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(217);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                nextStates.set(218);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(219);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(54);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(221);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(222);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(223);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(224);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(225);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(227);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(228);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(229);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 86 || ch == 118) {
                nextStates.set(230);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(231);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(233);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(62);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(237);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(238);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(239);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(241);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(242);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(64);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(244);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(245);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(65);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(247);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(66);
            }
            return null;
        }

        private static int[] NFA_MOVES_297_init() {
            return new int[]{38, 38, 43, 43, 45, 58, 61, 61, 63, 63, 65, 90, 95, 95, 97, 122};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77, DEFAULT::getNfaIndex78, DEFAULT::getNfaIndex79, DEFAULT::getNfaIndex80, DEFAULT::getNfaIndex81, DEFAULT::getNfaIndex82, DEFAULT::getNfaIndex83, DEFAULT::getNfaIndex84, DEFAULT::getNfaIndex85, DEFAULT::getNfaIndex86, DEFAULT::getNfaIndex87, DEFAULT::getNfaIndex88, DEFAULT::getNfaIndex89, DEFAULT::getNfaIndex90, DEFAULT::getNfaIndex91, DEFAULT::getNfaIndex92, DEFAULT::getNfaIndex93, DEFAULT::getNfaIndex94, DEFAULT::getNfaIndex95, DEFAULT::getNfaIndex96, DEFAULT::getNfaIndex97, DEFAULT::getNfaIndex98, DEFAULT::getNfaIndex99, DEFAULT::getNfaIndex100, DEFAULT::getNfaIndex101, DEFAULT::getNfaIndex102, DEFAULT::getNfaIndex103, DEFAULT::getNfaIndex104, DEFAULT::getNfaIndex105, DEFAULT::getNfaIndex106, DEFAULT::getNfaIndex107, DEFAULT::getNfaIndex108, DEFAULT::getNfaIndex109, DEFAULT::getNfaIndex110, DEFAULT::getNfaIndex111, DEFAULT::getNfaIndex112, DEFAULT::getNfaIndex113, DEFAULT::getNfaIndex114, DEFAULT::getNfaIndex115, DEFAULT::getNfaIndex116, DEFAULT::getNfaIndex117, DEFAULT::getNfaIndex118, DEFAULT::getNfaIndex119, DEFAULT::getNfaIndex120, DEFAULT::getNfaIndex121, DEFAULT::getNfaIndex122, DEFAULT::getNfaIndex123, DEFAULT::getNfaIndex124, DEFAULT::getNfaIndex125, DEFAULT::getNfaIndex126, DEFAULT::getNfaIndex127, DEFAULT::getNfaIndex128, DEFAULT::getNfaIndex129, DEFAULT::getNfaIndex130, DEFAULT::getNfaIndex131, DEFAULT::getNfaIndex132, DEFAULT::getNfaIndex133, DEFAULT::getNfaIndex134, DEFAULT::getNfaIndex135, DEFAULT::getNfaIndex136, DEFAULT::getNfaIndex137, DEFAULT::getNfaIndex138, DEFAULT::getNfaIndex139, DEFAULT::getNfaIndex140, DEFAULT::getNfaIndex141, DEFAULT::getNfaIndex142, DEFAULT::getNfaIndex143, DEFAULT::getNfaIndex144, DEFAULT::getNfaIndex145, DEFAULT::getNfaIndex146, DEFAULT::getNfaIndex147, DEFAULT::getNfaIndex148, DEFAULT::getNfaIndex149, DEFAULT::getNfaIndex150, DEFAULT::getNfaIndex151, DEFAULT::getNfaIndex152, DEFAULT::getNfaIndex153, DEFAULT::getNfaIndex154, DEFAULT::getNfaIndex155, DEFAULT::getNfaIndex156, DEFAULT::getNfaIndex157, DEFAULT::getNfaIndex158, DEFAULT::getNfaIndex159, DEFAULT::getNfaIndex160, DEFAULT::getNfaIndex161, DEFAULT::getNfaIndex162, DEFAULT::getNfaIndex163, DEFAULT::getNfaIndex164, DEFAULT::getNfaIndex165, DEFAULT::getNfaIndex166, DEFAULT::getNfaIndex167, DEFAULT::getNfaIndex168, DEFAULT::getNfaIndex169, DEFAULT::getNfaIndex170, DEFAULT::getNfaIndex171, DEFAULT::getNfaIndex172, DEFAULT::getNfaIndex173, DEFAULT::getNfaIndex174, DEFAULT::getNfaIndex175, DEFAULT::getNfaIndex176, DEFAULT::getNfaIndex177, DEFAULT::getNfaIndex178, DEFAULT::getNfaIndex179, DEFAULT::getNfaIndex180, DEFAULT::getNfaIndex181, DEFAULT::getNfaIndex182, DEFAULT::getNfaIndex183, DEFAULT::getNfaIndex184, DEFAULT::getNfaIndex185, DEFAULT::getNfaIndex186, DEFAULT::getNfaIndex187, DEFAULT::getNfaIndex188, DEFAULT::getNfaIndex189, DEFAULT::getNfaIndex190, DEFAULT::getNfaIndex191, DEFAULT::getNfaIndex192, DEFAULT::getNfaIndex193, DEFAULT::getNfaIndex194, DEFAULT::getNfaIndex195, DEFAULT::getNfaIndex196, DEFAULT::getNfaIndex197, DEFAULT::getNfaIndex198, DEFAULT::getNfaIndex199, DEFAULT::getNfaIndex200, DEFAULT::getNfaIndex201, DEFAULT::getNfaIndex202, DEFAULT::getNfaIndex203, DEFAULT::getNfaIndex204, DEFAULT::getNfaIndex205, DEFAULT::getNfaIndex206, DEFAULT::getNfaIndex207, DEFAULT::getNfaIndex208, DEFAULT::getNfaIndex209, DEFAULT::getNfaIndex210, DEFAULT::getNfaIndex211, DEFAULT::getNfaIndex212, DEFAULT::getNfaIndex213, DEFAULT::getNfaIndex214, DEFAULT::getNfaIndex215, DEFAULT::getNfaIndex216, DEFAULT::getNfaIndex217, DEFAULT::getNfaIndex218, DEFAULT::getNfaIndex219, DEFAULT::getNfaIndex220, DEFAULT::getNfaIndex221, DEFAULT::getNfaIndex222, DEFAULT::getNfaIndex223, DEFAULT::getNfaIndex224, DEFAULT::getNfaIndex225, DEFAULT::getNfaIndex226, DEFAULT::getNfaIndex227, DEFAULT::getNfaIndex228, DEFAULT::getNfaIndex229, DEFAULT::getNfaIndex230, DEFAULT::getNfaIndex231, DEFAULT::getNfaIndex232, DEFAULT::getNfaIndex233, DEFAULT::getNfaIndex234, DEFAULT::getNfaIndex235, DEFAULT::getNfaIndex236, DEFAULT::getNfaIndex237, DEFAULT::getNfaIndex238, DEFAULT::getNfaIndex239, DEFAULT::getNfaIndex240, DEFAULT::getNfaIndex241, DEFAULT::getNfaIndex242, DEFAULT::getNfaIndex243, DEFAULT::getNfaIndex244, DEFAULT::getNfaIndex245, DEFAULT::getNfaIndex246, DEFAULT::getNfaIndex247};
            nfaFunctions = functions;
        }
    }
}

