/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieBadResponseException;
import org.projectnessie.client.rest.io.CapturingInputStream;
import org.projectnessie.error.ImmutableNessieError;

public class HttpResponse {
    private final ResponseContext responseContext;
    private final ObjectMapper mapper;

    public HttpResponse(ResponseContext context, ObjectMapper mapper) {
        this.responseContext = context;
        this.mapper = mapper;
    }

    public <V> V readEntity(Class<V> clazz) {
        ObjectReader reader = this.mapper.readerFor(clazz);
        try {
            return this.decodeEntity(reader, this.responseContext.getInputStream());
        }
        catch (IOException e) {
            throw new HttpClientException("Failed to read entity", e);
        }
    }

    private <V> V decodeEntity(ObjectReader reader, InputStream is) throws IOException {
        if (is != null) {
            try (CapturingInputStream capturing = new CapturingInputStream(is);){
                if (this.responseContext.isJsonCompatibleResponse()) {
                    MappingIterator values = reader.readValues((InputStream)capturing);
                    if (values.hasNextValue()) {
                        Object object = values.nextValue();
                        return (V)object;
                    }
                } else {
                    String captured = capturing.capture();
                    if (!captured.isEmpty()) {
                        throw this.unparseableResponse(captured, null);
                    }
                }
            }
        }
        return null;
    }

    private NessieBadResponseException unparseableResponse(String captured, Exception cause) {
        captured = captured.trim();
        Status status = this.responseContext.getStatus();
        String message = String.format("Expected the server to return a JSON compatible response, but the server replied with Content-Type '%s' from '%s' %s. Check the Nessie REST API base URI. Nessie REST API base URI usually ends in '/api/v1' or '/api/v2', but your service provider may have a different URL pattern.", this.responseContext.getContentType(), this.responseContext.getRequestedUri(), captured.isEmpty() ? "and no response body" : "and a response body beginning with: \"" + captured + "\"");
        ImmutableNessieError error = ImmutableNessieError.builder().message(message).status(status.getCode()).reason(status.getReason()).build();
        NessieBadResponseException exception = new NessieBadResponseException(error);
        if (cause != null) {
            exception.initCause(cause);
        }
        return exception;
    }

    public URI getRequestUri() {
        return this.responseContext.getRequestedUri();
    }

    public Status getStatus() {
        return this.responseContext.getStatus();
    }
}

