/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk11;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpClientReadTimeoutException;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.impl.BaseHttpRequest;
import org.projectnessie.client.http.impl.HttpHeaders;
import org.projectnessie.client.http.impl.RequestContextImpl;
import org.projectnessie.client.http.impl.jdk11.JavaHttpClient;
import org.projectnessie.client.http.impl.jdk11.JavaResponseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaRequest
extends BaseHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaRequest.class);
    private final HttpClient client;
    private static final Executor writerPool = new ForkJoinPool(Math.max(8, ForkJoinPool.getCommonPoolParallelism()));

    JavaRequest(JavaHttpClient client) {
        super(client.config);
        this.client = client.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        HttpResponse httpResponse;
        block17: {
            URI uri = this.uriBuilder.build();
            HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(this.config.getReadTimeoutMillis()));
            RequestContextImpl context = new RequestContextImpl(this.headers, uri, method, body);
            boolean doesOutput = this.prepareRequest(context);
            for (HttpHeaders.HttpHeader header : this.headers.allHeaders()) {
                for (String value : header.getValues()) {
                    request = request.header(header.getName(), value);
                }
            }
            HttpRequest.BodyPublisher bodyPublisher = doesOutput ? this.bodyPublisher(context) : HttpRequest.BodyPublishers.noBody();
            request = request.method(method.name(), bodyPublisher);
            java.net.http.HttpResponse<InputStream> response = null;
            try {
                try {
                    LOGGER.debug("Sending {} request to {} ...", (Object)method, (Object)uri);
                    response = this.client.send(request.build(), HttpResponse.BodyHandlers.ofInputStream());
                }
                catch (HttpConnectTimeoutException e) {
                    throw new HttpClientException(String.format("Timeout connecting to '%s' after %ds", uri, this.config.getConnectionTimeoutMillis() / 1000), e);
                }
                catch (HttpTimeoutException e) {
                    throw new HttpClientReadTimeoutException(String.format("Cannot finish %s request against '%s'. Timeout while waiting for response with a timeout of %ds", new Object[]{method, uri, this.config.getReadTimeoutMillis() / 1000}), e);
                }
                catch (MalformedURLException e) {
                    throw new HttpClientException(String.format("Cannot perform %s request. Malformed Url for %s", new Object[]{method, uri}), e);
                }
                catch (IOException e) {
                    throw new HttpClientException(String.format("Failed to execute %s request against '%s'.", new Object[]{method, uri}), e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                JavaResponseContext responseContext = new JavaResponseContext(response);
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(responseContext, null));
                }
                this.config.getResponseFilters().forEach(responseFilter -> responseFilter.filter(responseContext));
                if (response.statusCode() >= 400) {
                    throw new HttpClientException(String.format("%s request to %s failed with HTTP/%d", new Object[]{method, uri, response.statusCode()}));
                }
                response = null;
                httpResponse = this.config.responseFactory().make(responseContext, this.config.getMapper());
                if (response == null) break block17;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        LOGGER.debug("Closing unprocessed input stream for {} request to {} delegating to {} ...", new Object[]{method, uri, response.body()});
                        response.body().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                LOGGER.debug("Closing unprocessed input stream for {} request to {} delegating to {} ...", new Object[]{method, uri, response.body()});
                response.body().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return httpResponse;
    }

    private HttpRequest.BodyPublisher bodyPublisher(RequestContext context) {
        ClassLoader cl = this.getClass().getClassLoader();
        return HttpRequest.BodyPublishers.ofInputStream(() -> {
            try {
                Pipe pipe = Pipe.open();
                writerPool.execute(() -> {
                    ClassLoader restore = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(cl);
                        this.writeToOutputStream(context, Channels.newOutputStream(pipe.sink()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(restore);
                    }
                });
                return Channels.newInputStream(pipe.source());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

