/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.Pattern;
import javax.validation.constraints.NotBlank;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.api.v1.params.BaseMergeTransplant;
import org.projectnessie.api.v1.params.ImmutableMerge;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Merge Operation", properties={@SchemaProperty(name="fromRefName", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$"), @SchemaProperty(name="fromHash", pattern="^[0-9a-fA-F]{8,64}$")})
@JsonSerialize(as=ImmutableMerge.class)
@JsonDeserialize(as=ImmutableMerge.class)
@Value.Immutable
public interface Merge
extends BaseMergeTransplant {
    @NotBlank
    @jakarta.validation.constraints.NotBlank
    @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    public @NotBlank @jakarta.validation.constraints.NotBlank @javax.validation.constraints.Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String getFromHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getFromHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }
}

