/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.NoSuchElementException;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.client.api.QueryBuilder;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class NessieUtils$ {
    public static final NessieUtils$ MODULE$ = new NessieUtils$();
    private static final String BRANCH = "Branch";
    private static final String TAG = "Tag";
    private static final String HASH = "Hash";

    public String BRANCH() {
        return BRANCH;
    }

    public String TAG() {
        return TAG;
    }

    public String HASH() {
        return HASH;
    }

    public Reference calculateRef(String branch, Option<String> tsOrHash, NessieApiV1 api) {
        String hash = (String)tsOrHash.map((Function1 & Serializable)x -> x.replaceAll("`", "")).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieUtils$.$anonfun$calculateRef$2(x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (hash != null) {
            return this.findReferenceFromHash(branch, hash, api);
        }
        Instant timestamp = (Instant)tsOrHash.map((Function1 & Serializable)x -> x.replaceAll("`", "")).map((Function1 & Serializable)x -> {
            Instant instant;
            try {
                instant = ZonedDateTime.parse(x).toInstant();
            }
            catch (DateTimeParseException e) {
                throw new NessieNotFoundException(String.format("Invalid timestamp provided: %s. You need to provide it with a zone info. For more info, see: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html", e.getMessage()));
            }
            return instant;
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (timestamp == null) {
            return api.getReference().refName(branch).get();
        }
        return this.findReferenceFromTimestamp(branch, api, timestamp);
    }

    private Reference findReferenceFromHash(String branch, String requestedHash, NessieApiV1 api) {
        Option commit = Option$.MODULE$.apply(((PagingBuilder)api.getCommitLog().refName(branch).hashOnRef(Validation.validateHash(requestedHash))).stream().findFirst().orElse(null)).map((Function1 & Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieNotFoundException(String.format("Cannot find requested hash %s on reference %s.", requestedHash, branch));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String value = (String)some.value();
        String hash = value;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference findReferenceFromTimestamp(String branch, NessieApiV1 api, Instant timestamp) {
        Option commit = Option$.MODULE$.apply(((PagingBuilder)((QueryBuilder)api.getCommitLog().refName(branch)).filter(String.format("timestamp(commit.commitTime) <= timestamp('%s')", timestamp))).stream().findFirst().orElse(null)).map((Function1 & Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieNotFoundException(String.format("Cannot find a hash before %s.", timestamp));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String value = (String)some.value();
        String hash = value;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference convertToSpecificRef(String hash, Reference reference) {
        Reference reference2 = reference;
        if (reference2 instanceof ImmutableBranch) {
            ImmutableBranch immutableBranch = (ImmutableBranch)reference2;
            return Branch.of(immutableBranch.getName(), hash);
        }
        if (reference2 instanceof ImmutableTag) {
            ImmutableTag immutableTag = (ImmutableTag)reference2;
            return Tag.of(immutableTag.getName(), hash);
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(reference).toString());
    }

    public NessieApiV1 nessieAPI(CatalogPlugin currentCatalog, Option<String> catalog) {
        scala.collection.immutable.Map catalogConf;
        block4: {
            String string;
            String catalogName = (String)catalog.getOrElse((Function0 & Serializable)() -> currentCatalog.name());
            SparkConf sparkConf = SparkSession$.MODULE$.active().sparkContext().conf();
            catalogConf = Predef$.MODULE$.wrapRefArray((Object[])sparkConf.getAllWithPrefix(new StringBuilder(19).append("spark.sql.catalog.").append(catalogName).append(".").toString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option catalogClass = sparkConf.getOption(new StringBuilder(18).append("spark.sql.catalog.").append(catalogName).toString());
            boolean needsImplCheck = BoxesRunTime.unboxToBoolean((Object)catalogClass.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NessieUtils$.$anonfun$nessieAPI$2(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
            if (!needsImplCheck) break block4;
            Option catalogImpl = catalogConf.get((Object)"catalog-impl");
            Option option = catalogImpl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String clazz = (String)some.value();
                string = new StringBuilder(10).append("but ").append(catalogName).append(" is a ").append(clazz).toString();
            } else if (None$.MODULE$.equals(option)) {
                string = new StringBuilder(46).append("but spark.sql.catalog.").append(catalogName).append(".catalog-impl is not set").toString();
            } else {
                throw new MatchError((Object)option);
            }
            String catalogErrorDetail = string;
            Predef$.MODULE$.require(catalogImpl.exists((Function1 & Serializable)impl -> BoxesRunTime.boxToBoolean((boolean)impl.endsWith(".NessieCatalog"))), (Function0 & Serializable)() -> new StringBuilder(178).append("The command works only when the catalog is a NessieCatalog (").append(catalogErrorDetail).append("). Either set the catalog via USE <catalog_name> or provide the catalog during execution: <command> IN <catalog_name>.").toString());
        }
        return ((HttpClientBuilder)HttpClientBuilder.builder().fromConfig(x -> (String)catalogConf.getOrElse((Object)x.replace("nessie.", ""), (Function0 & Serializable)() -> null))).build(NessieApiV1.class);
    }

    public void setCurrentRefForSpark(CatalogPlugin currentCatalog, Option<String> catalog, Reference ref, boolean configureRefAtHash) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable)() -> currentCatalog.name());
        CatalogPlugin catalogImpl = SparkSession$.MODULE$.active().sessionState().catalogManager().catalog(catalogName);
        SparkSession$.MODULE$.active().sparkContext().conf().set(new StringBuilder(22).append("spark.sql.catalog.").append(catalogName).append(".ref").toString(), ref.getName());
        SparkConf sparkConf = configureRefAtHash ? SparkSession$.MODULE$.active().sparkContext().conf().set(new StringBuilder(27).append("spark.sql.catalog.").append(catalogName).append(".ref.hash").toString(), ref.getHash()) : SparkSession$.MODULE$.active().sparkContext().conf().remove(new StringBuilder(27).append("spark.sql.catalog.").append(catalogName).append(".ref.hash").toString());
        java.util.Map catalogConf = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.wrapRefArray((Object[])SparkSession$.MODULE$.active().sparkContext().conf().getAllWithPrefix(new StringBuilder(19).append("spark.sql.catalog.").append(catalogName).append(".").toString())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        catalogImpl.initialize(catalogName, new CaseInsensitiveStringMap(catalogConf));
    }

    public Reference getCurrentRef(NessieApiV1 api, CatalogPlugin currentCatalog, Option<String> catalog) {
        Reference reference;
        Tuple2<String, Option<String>> currentRef = this.getCurrentRef(currentCatalog, catalog);
        String refName = (String)currentRef._1();
        try {
            Reference ref = api.getReference().refName(refName).get();
            Option refHash = (Option)currentRef._2();
            if (refHash.nonEmpty()) {
                Reference.ReferenceType referenceType = ref.getType();
                Reference.ReferenceType referenceType2 = Reference.ReferenceType.BRANCH;
                ref = !(referenceType != null ? !((Object)((Object)referenceType)).equals((Object)referenceType2) : referenceType2 != null) ? Branch.of(ref.getName(), (String)refHash.get()) : Tag.of(ref.getName(), (String)refHash.get());
            }
            reference = ref;
        }
        catch (NessieNotFoundException e) {
            throw new NessieNotFoundException(new StringBuilder(83).append("Could not find current reference ").append(refName).append(" configured in spark configuration for catalog '").append(catalog.getOrElse((Function0 & Serializable)() -> currentCatalog.name())).append("'.").toString(), e);
        }
        return reference;
    }

    public Tuple2<String, Option<String>> getCurrentRef(CatalogPlugin currentCatalog, Option<String> catalog) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable)() -> currentCatalog.name());
        String refName = SparkSession$.MODULE$.active().sparkContext().conf().get(new StringBuilder(22).append("spark.sql.catalog.").append(catalogName).append(".ref").toString());
        None$ refHash = None$.MODULE$;
        try {
            refHash = new Some((Object)SparkSession$.MODULE$.active().sparkContext().conf().get(new StringBuilder(27).append("spark.sql.catalog.").append(catalogName).append(".ref.hash").toString()));
        }
        catch (NoSuchElementException noSuchElementException) {}
        return new Tuple2((Object)refName, (Object)refHash);
    }

    public String getRefType(Reference ref) {
        Reference reference = ref;
        if (reference instanceof ImmutableBranch) {
            return this.BRANCH();
        }
        if (reference instanceof ImmutableTag) {
            return this.TAG();
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(ref).toString());
    }

    public static final /* synthetic */ boolean $anonfun$calculateRef$2(String x) {
        return Validation.isValidHash(x);
    }

    public static final /* synthetic */ boolean $anonfun$nessieAPI$2(String x$1) {
        return !x$1.endsWith(".DeltaCatalog");
    }

    private NessieUtils$() {
    }
}

