/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v2api;

import java.util.stream.Stream;
import org.projectnessie.api.v2.params.CommitLogParams;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.builder.BaseGetCommitLogBuilder;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Reference;

final class HttpGetCommitLog
extends BaseGetCommitLogBuilder<CommitLogParams> {
    private final HttpClient client;

    HttpGetCommitLog(HttpClient client) {
        super(CommitLogParams::forNextPage);
        this.client = client;
    }

    @Override
    protected CommitLogParams params() {
        return CommitLogParams.builder().fetchOption(this.fetchOption).startHash(this.untilHash).maxRecords(this.maxRecords).filter(this.filter).build();
    }

    @Override
    protected LogResponse get(CommitLogParams p) throws NessieNotFoundException {
        return this.client.newRequest().path("trees/{ref}/history").resolveTemplate("ref", Reference.toPathString(this.refName, this.hashOnRef)).queryParam("max-records", p.maxRecords()).queryParam("page-token", p.pageToken()).queryParam("filter", p.filter()).queryParam("limit-hash", p.startHash()).queryParam("fetch", FetchOption.getFetchOptionName(p.fetchOption())).unwrap(NessieNotFoundException.class).get().readEntity(LogResponse.class);
    }

    @Override
    public Stream<LogResponse.LogEntry> stream() throws NessieNotFoundException {
        CommitLogParams p = this.params();
        return StreamingUtil.generateStream(LogResponse::getLogEntries, pageToken -> this.get(p.forNextPage(pageToken)));
    }
}

