/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.ser;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ser.CommitMetaSer;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="CommitMetaSer", generator="Immutables")
@Immutable
public final class ImmutableCommitMetaSer
extends CommitMetaSer {
    private final String hash;
    private final String committer;
    private final transient String author;
    private final List<String> allAuthors;
    private final transient String signedOffBy;
    private final List<String> allSignedOffBy;
    private final String message;
    private final Instant commitTime;
    private final Instant authorTime;
    private final Map<String, List<String>> allProperties;
    private final List<String> parentCommitHashes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCommitMetaSer(String hash, String committer, List<String> allAuthors, List<String> allSignedOffBy, String message, Instant commitTime, Instant authorTime, Map<String, List<String>> allProperties, List<String> parentCommitHashes) {
        this.hash = hash;
        this.committer = committer;
        this.allAuthors = allAuthors;
        this.allSignedOffBy = allSignedOffBy;
        this.message = message;
        this.commitTime = commitTime;
        this.authorTime = authorTime;
        this.allProperties = allProperties;
        this.parentCommitHashes = parentCommitHashes;
        this.author = this.initShim.getAuthor();
        this.signedOffBy = this.initShim.getSignedOffBy();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="committer")
    public String getCommitter() {
        return this.committer;
    }

    @Override
    @JsonProperty(value="author")
    @JsonView(value={Views.V1.class})
    public String getAuthor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAuthor() : this.author;
    }

    @Override
    @JsonView(value={Views.V2.class})
    @JsonProperty(value="authors")
    public List<String> getAllAuthors() {
        return this.allAuthors;
    }

    @Override
    @JsonProperty(value="signedOffBy")
    @JsonView(value={Views.V1.class})
    public String getSignedOffBy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSignedOffBy() : this.signedOffBy;
    }

    @Override
    @JsonProperty(value="allSignedOffBy")
    @JsonView(value={Views.V2.class})
    public List<String> getAllSignedOffBy() {
        return this.allSignedOffBy;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="commitTime")
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    public Instant getCommitTime() {
        return this.commitTime;
    }

    @Override
    @JsonProperty(value="authorTime")
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    public Instant getAuthorTime() {
        return this.authorTime;
    }

    @Override
    @JsonProperty(value="allProperties")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, List<String>> getAllProperties() {
        return this.allProperties;
    }

    @Override
    @JsonProperty(value="parentCommitHashes")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getParentCommitHashes() {
        return this.parentCommitHashes;
    }

    public final ImmutableCommitMetaSer withHash(String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new ImmutableCommitMetaSer(value, this.committer, this.allAuthors, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withCommitter(String value) {
        if (Objects.equals(this.committer, value)) {
            return this;
        }
        return new ImmutableCommitMetaSer(this.hash, value, this.allAuthors, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withAllAuthors(String ... elements) {
        List<String> newValue = ImmutableCommitMetaSer.createUnmodifiableList(false, ImmutableCommitMetaSer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitMetaSer(this.hash, this.committer, newValue, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withAllAuthors(Iterable<String> elements) {
        if (this.allAuthors == elements) {
            return this;
        }
        List<String> newValue = ImmutableCommitMetaSer.createUnmodifiableList(false, ImmutableCommitMetaSer.createSafeList(elements, true, false));
        return new ImmutableCommitMetaSer(this.hash, this.committer, newValue, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withAllSignedOffBy(String ... elements) {
        List<String> newValue = ImmutableCommitMetaSer.createUnmodifiableList(false, ImmutableCommitMetaSer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, newValue, this.message, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withAllSignedOffBy(Iterable<String> elements) {
        if (this.allSignedOffBy == elements) {
            return this;
        }
        List<String> newValue = ImmutableCommitMetaSer.createUnmodifiableList(false, ImmutableCommitMetaSer.createSafeList(elements, true, false));
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, newValue, this.message, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, this.allSignedOffBy, newValue, this.commitTime, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withCommitTime(Instant value) {
        if (this.commitTime == value) {
            return this;
        }
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, this.allSignedOffBy, this.message, value, this.authorTime, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withAuthorTime(Instant value) {
        if (this.authorTime == value) {
            return this;
        }
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, this.allSignedOffBy, this.message, this.commitTime, value, this.allProperties, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withAllProperties(Map<String, ? extends List<String>> entries) {
        if (this.allProperties == entries) {
            return this;
        }
        Map<String, List<String>> newValue = ImmutableCommitMetaSer.createUnmodifiableMap(true, false, entries);
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, newValue, this.parentCommitHashes);
    }

    public final ImmutableCommitMetaSer withParentCommitHashes(String ... elements) {
        List<String> newValue = ImmutableCommitMetaSer.createUnmodifiableList(false, ImmutableCommitMetaSer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, this.allProperties, newValue);
    }

    public final ImmutableCommitMetaSer withParentCommitHashes(Iterable<String> elements) {
        if (this.parentCommitHashes == elements) {
            return this;
        }
        List<String> newValue = ImmutableCommitMetaSer.createUnmodifiableList(false, ImmutableCommitMetaSer.createSafeList(elements, true, false));
        return new ImmutableCommitMetaSer(this.hash, this.committer, this.allAuthors, this.allSignedOffBy, this.message, this.commitTime, this.authorTime, this.allProperties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitMetaSer && this.equalTo(0, (ImmutableCommitMetaSer)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitMetaSer another) {
        return Objects.equals(this.hash, another.hash) && Objects.equals(this.committer, another.committer) && Objects.equals(this.author, another.author) && this.allAuthors.equals(another.allAuthors) && Objects.equals(this.signedOffBy, another.signedOffBy) && this.allSignedOffBy.equals(another.allSignedOffBy) && this.message.equals(another.message) && Objects.equals(this.commitTime, another.commitTime) && Objects.equals(this.authorTime, another.authorTime) && this.allProperties.equals(another.allProperties) && this.parentCommitHashes.equals(another.parentCommitHashes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.committer);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + this.allAuthors.hashCode();
        h += (h << 5) + Objects.hashCode(this.signedOffBy);
        h += (h << 5) + this.allSignedOffBy.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.commitTime);
        h += (h << 5) + Objects.hashCode(this.authorTime);
        h += (h << 5) + this.allProperties.hashCode();
        h += (h << 5) + this.parentCommitHashes.hashCode();
        return h;
    }

    public String toString() {
        return "CommitMetaSer{hash=" + this.hash + ", committer=" + this.committer + ", author=" + this.author + ", allAuthors=" + this.allAuthors + ", signedOffBy=" + this.signedOffBy + ", allSignedOffBy=" + this.allSignedOffBy + ", message=" + this.message + ", commitTime=" + this.commitTime + ", authorTime=" + this.authorTime + ", allProperties=" + this.allProperties + ", parentCommitHashes=" + this.parentCommitHashes + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitMetaSer fromJson(Json json) {
        Builder builder = ImmutableCommitMetaSer.builderSer();
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.committer != null) {
            builder.committer(json.committer);
        }
        if (json.allAuthors != null) {
            builder.addAllAllAuthors(json.allAuthors);
        }
        if (json.allSignedOffBy != null) {
            builder.addAllAllSignedOffBy(json.allSignedOffBy);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.commitTime != null) {
            builder.commitTime(json.commitTime);
        }
        if (json.authorTime != null) {
            builder.authorTime(json.authorTime);
        }
        if (json.allProperties != null) {
            builder.putAllAllProperties(json.allProperties);
        }
        if (json.parentCommitHashes != null) {
            builder.addAllParentCommitHashes(json.parentCommitHashes);
        }
        return builder.build();
    }

    public static ImmutableCommitMetaSer copyOf(CommitMetaSer instance) {
        if (instance instanceof ImmutableCommitMetaSer) {
            return (ImmutableCommitMetaSer)instance;
        }
        return ImmutableCommitMetaSer.builderSer().from(instance).build();
    }

    public static Builder builderSer() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CommitMetaSer", generator="Immutables")
    private final class InitShim {
        private byte authorBuildStage = 0;
        private String author;
        private byte signedOffByBuildStage = 0;
        private String signedOffBy;

        private InitShim() {
        }

        String getAuthor() {
            if (this.authorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorBuildStage == 0) {
                this.authorBuildStage = (byte)-1;
                this.author = ImmutableCommitMetaSer.super.getAuthor();
                this.authorBuildStage = 1;
            }
            return this.author;
        }

        String getSignedOffBy() {
            if (this.signedOffByBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signedOffByBuildStage == 0) {
                this.signedOffByBuildStage = (byte)-1;
                this.signedOffBy = ImmutableCommitMetaSer.super.getSignedOffBy();
                this.signedOffByBuildStage = 1;
            }
            return this.signedOffBy;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.authorBuildStage == -1) {
                attributes.add("author");
            }
            if (this.signedOffByBuildStage == -1) {
                attributes.add("signedOffBy");
            }
            return "Cannot build CommitMetaSer, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="CommitMetaSer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private long initBits = 1L;
        @Nullable
        private String hash;
        @Nullable
        private String committer;
        private List<String> allAuthors = new ArrayList<String>();
        private List<String> allSignedOffBy = new ArrayList<String>();
        @Nullable
        private String message;
        @Nullable
        private Instant commitTime;
        @Nullable
        private Instant authorTime;
        private Map<String, List<String>> allProperties = new LinkedHashMap<String, List<String>>();
        private List<String> parentCommitHashes = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(CommitMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(CommitMetaSer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof CommitMeta) {
                CommitMeta instance = (CommitMeta)object;
                String committerValue = instance.getCommitter();
                if (committerValue != null) {
                    this.committer(committerValue);
                }
                this.addAllParentCommitHashes(instance.getParentCommitHashes());
                Instant commitTimeValue = instance.getCommitTime();
                if (commitTimeValue != null) {
                    this.commitTime(commitTimeValue);
                }
                this.addAllAllAuthors(instance.getAllAuthors());
                this.putAllAllProperties(instance.getAllProperties());
                Instant authorTimeValue = instance.getAuthorTime();
                if (authorTimeValue != null) {
                    this.authorTime(authorTimeValue);
                }
                this.message(instance.getMessage());
                this.addAllAllSignedOffBy(instance.getAllSignedOffBy());
                String hashValue = instance.getHash();
                if (hashValue != null) {
                    this.hash(hashValue);
                }
            }
        }

        @JsonProperty(value="hash")
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="committer")
        public final Builder committer(String committer) {
            this.committer = committer;
            return this;
        }

        public final Builder addAllAuthors(String element) {
            this.allAuthors.add(Objects.requireNonNull(element, "allAuthors element"));
            return this;
        }

        public final Builder addAllAuthors(String ... elements) {
            for (String element : elements) {
                this.allAuthors.add(Objects.requireNonNull(element, "allAuthors element"));
            }
            return this;
        }

        @JsonView(value={Views.V2.class})
        @JsonProperty(value="authors")
        public final Builder allAuthors(Iterable<String> elements) {
            this.allAuthors.clear();
            return this.addAllAllAuthors(elements);
        }

        public final Builder addAllAllAuthors(Iterable<String> elements) {
            for (String element : elements) {
                this.allAuthors.add(Objects.requireNonNull(element, "allAuthors element"));
            }
            return this;
        }

        public final Builder addAllSignedOffBy(String element) {
            this.allSignedOffBy.add(Objects.requireNonNull(element, "allSignedOffBy element"));
            return this;
        }

        public final Builder addAllSignedOffBy(String ... elements) {
            for (String element : elements) {
                this.allSignedOffBy.add(Objects.requireNonNull(element, "allSignedOffBy element"));
            }
            return this;
        }

        @JsonProperty(value="allSignedOffBy")
        @JsonView(value={Views.V2.class})
        public final Builder allSignedOffBy(Iterable<String> elements) {
            this.allSignedOffBy.clear();
            return this.addAllAllSignedOffBy(elements);
        }

        public final Builder addAllAllSignedOffBy(Iterable<String> elements) {
            for (String element : elements) {
                this.allSignedOffBy.add(Objects.requireNonNull(element, "allSignedOffBy element"));
            }
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="commitTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public final Builder commitTime(Instant commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        @JsonProperty(value="authorTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public final Builder authorTime(Instant authorTime) {
            this.authorTime = authorTime;
            return this;
        }

        public final Builder putAllProperties(String key, List<String> value) {
            this.allProperties.put(Objects.requireNonNull(key, "allProperties key"), Objects.requireNonNull(value, value == null ? "allProperties value for key: " + key : null));
            return this;
        }

        public final Builder putAllProperties(Map.Entry<String, ? extends List<String>> entry) {
            List<String> v;
            String k = entry.getKey();
            this.allProperties.put(Objects.requireNonNull(k, "allProperties key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "allProperties value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="allProperties")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder allProperties(Map<String, ? extends List<String>> entries) {
            this.allProperties.clear();
            return this.putAllAllProperties(entries);
        }

        public final Builder putAllAllProperties(Map<String, ? extends List<String>> entries) {
            for (Map.Entry<String, ? extends List<String>> e : entries.entrySet()) {
                List<String> v;
                String k = e.getKey();
                this.allProperties.put(Objects.requireNonNull(k, "allProperties key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "allProperties value for key: " + k : null));
            }
            return this;
        }

        public final Builder addParentCommitHashes(String element) {
            this.parentCommitHashes.add(Objects.requireNonNull(element, "parentCommitHashes element"));
            return this;
        }

        public final Builder addParentCommitHashes(String ... elements) {
            for (String element : elements) {
                this.parentCommitHashes.add(Objects.requireNonNull(element, "parentCommitHashes element"));
            }
            return this;
        }

        @JsonProperty(value="parentCommitHashes")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder parentCommitHashes(Iterable<String> elements) {
            this.parentCommitHashes.clear();
            return this.addAllParentCommitHashes(elements);
        }

        public final Builder addAllParentCommitHashes(Iterable<String> elements) {
            for (String element : elements) {
                this.parentCommitHashes.add(Objects.requireNonNull(element, "parentCommitHashes element"));
            }
            return this;
        }

        public ImmutableCommitMetaSer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitMetaSer(this.hash, this.committer, ImmutableCommitMetaSer.createUnmodifiableList(true, this.allAuthors), ImmutableCommitMetaSer.createUnmodifiableList(true, this.allSignedOffBy), this.message, this.commitTime, this.authorTime, ImmutableCommitMetaSer.createUnmodifiableMap(false, false, this.allProperties), ImmutableCommitMetaSer.createUnmodifiableList(true, this.parentCommitHashes));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build CommitMetaSer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitMetaSer", generator="Immutables")
    static final class Json
    extends CommitMetaSer {
        @Nullable
        String hash;
        @Nullable
        String committer;
        @Nullable
        List<String> allAuthors = Collections.emptyList();
        @Nullable
        List<String> allSignedOffBy = Collections.emptyList();
        @Nullable
        String message;
        @Nullable
        Instant commitTime;
        @Nullable
        Instant authorTime;
        @Nullable
        Map<String, List<String>> allProperties = Collections.emptyMap();
        @Nullable
        List<String> parentCommitHashes = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="committer")
        public void setCommitter(String committer) {
            this.committer = committer;
        }

        @JsonView(value={Views.V2.class})
        @JsonProperty(value="authors")
        public void setAllAuthors(List<String> allAuthors) {
            this.allAuthors = allAuthors;
        }

        @JsonProperty(value="allSignedOffBy")
        @JsonView(value={Views.V2.class})
        public void setAllSignedOffBy(List<String> allSignedOffBy) {
            this.allSignedOffBy = allSignedOffBy;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="commitTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public void setCommitTime(Instant commitTime) {
            this.commitTime = commitTime;
        }

        @JsonProperty(value="authorTime")
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public void setAuthorTime(Instant authorTime) {
            this.authorTime = authorTime;
        }

        @JsonProperty(value="allProperties")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setAllProperties(Map<String, List<String>> allProperties) {
            this.allProperties = allProperties;
        }

        @JsonProperty(value="parentCommitHashes")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setParentCommitHashes(List<String> parentCommitHashes) {
            this.parentCommitHashes = parentCommitHashes;
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommitter() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getAuthor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllAuthors() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getSignedOffBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllSignedOffBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCommitTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getAuthorTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, List<String>> getAllProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getParentCommitHashes() {
            throw new UnsupportedOperationException();
        }
    }
}

