/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Locale;

public enum GrantType {
    CLIENT_CREDENTIALS("client_credentials"),
    PASSWORD("password"),
    AUTHORIZATION_CODE("authorization_code"),
    DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code"),
    REFRESH_TOKEN("refresh_token"),
    TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange");

    private final String canonicalName;

    private GrantType(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    @JsonValue
    public String canonicalName() {
        return this.canonicalName;
    }

    public static GrantType fromConfigName(String name) {
        for (GrantType grantType : GrantType.values()) {
            if (!grantType.name().equals(name.toUpperCase(Locale.ROOT)) && !grantType.canonicalName.equals(name)) continue;
            return grantType;
        }
        throw new IllegalArgumentException("Unknown grant type: " + name);
    }
}

