/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AuthorizationCodeTokensRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthorizationCodeTokensRequest", generator="Immutables")
@Immutable
final class ImmutableAuthorizationCodeTokensRequest
implements AuthorizationCodeTokensRequest {
    @Nullable
    private final String scope;
    private final GrantType grantType;
    private final String code;
    private final String redirectUri;
    private final String clientId;

    private ImmutableAuthorizationCodeTokensRequest(Builder builder) {
        this.scope = builder.scope;
        this.code = builder.code;
        this.redirectUri = builder.redirectUri;
        this.clientId = builder.clientId;
        this.grantType = builder.grantType != null ? builder.grantType : Objects.requireNonNull(AuthorizationCodeTokensRequest.super.getGrantType(), "grantType");
    }

    private ImmutableAuthorizationCodeTokensRequest(@Nullable String scope, GrantType grantType, String code, String redirectUri, String clientId) {
        this.scope = scope;
        this.grantType = grantType;
        this.code = code;
        this.redirectUri = redirectUri;
        this.clientId = clientId;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grant_type")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @Override
    @JsonProperty(value="redirect_uri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public final ImmutableAuthorizationCodeTokensRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(value, this.grantType, this.code, this.redirectUri, this.clientId);
    }

    public final ImmutableAuthorizationCodeTokensRequest withGrantType(GrantType value) {
        GrantType newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType == newValue) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, newValue, this.code, this.redirectUri, this.clientId);
    }

    public final ImmutableAuthorizationCodeTokensRequest withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, this.grantType, newValue, this.redirectUri, this.clientId);
    }

    public final ImmutableAuthorizationCodeTokensRequest withRedirectUri(String value) {
        String newValue = Objects.requireNonNull(value, "redirectUri");
        if (this.redirectUri.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, this.grantType, this.code, newValue, this.clientId);
    }

    public final ImmutableAuthorizationCodeTokensRequest withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthorizationCodeTokensRequest(this.scope, this.grantType, this.code, this.redirectUri, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizationCodeTokensRequest && this.equalTo(0, (ImmutableAuthorizationCodeTokensRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthorizationCodeTokensRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals((Object)another.grantType) && this.code.equals(another.code) && this.redirectUri.equals(another.redirectUri) && this.clientId.equals(another.clientId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.redirectUri.hashCode();
        h += (h << 5) + this.clientId.hashCode();
        return h;
    }

    public String toString() {
        return "AuthorizationCodeTokensRequest{scope=" + this.scope + ", grantType=" + (Object)((Object)this.grantType) + ", code=" + this.code + ", redirectUri=" + this.redirectUri + ", clientId=" + this.clientId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthorizationCodeTokensRequest fromJson(Json json) {
        Builder builder = ImmutableAuthorizationCodeTokensRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.grantType != null) {
            builder.grantType(json.grantType);
        }
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.redirectUri != null) {
            builder.redirectUri(json.redirectUri);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        return builder.build();
    }

    public static ImmutableAuthorizationCodeTokensRequest copyOf(AuthorizationCodeTokensRequest instance) {
        if (instance instanceof ImmutableAuthorizationCodeTokensRequest) {
            return (ImmutableAuthorizationCodeTokensRequest)instance;
        }
        return ImmutableAuthorizationCodeTokensRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthorizationCodeTokensRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_REDIRECT_URI = 2L;
        private static final long INIT_BIT_CLIENT_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private String scope;
        @Nullable
        private GrantType grantType;
        @Nullable
        private String code;
        @Nullable
        private String redirectUri;
        @Nullable
        private String clientId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthorizationCodeTokensRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String scopeValue;
            TokensRequestBase instance;
            long bits = 0L;
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof AuthorizationCodeTokensRequest) {
                instance = (AuthorizationCodeTokensRequest)object;
                this.redirectUri(instance.getRedirectUri());
                this.code(instance.getCode());
                this.clientId(instance.getClientId());
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="grant_type")
        @CanIgnoreReturnValue
        public final Builder grantType(GrantType grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @JsonProperty(value="code")
        @CanIgnoreReturnValue
        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="redirect_uri")
        @CanIgnoreReturnValue
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAuthorizationCodeTokensRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorizationCodeTokensRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("redirectUri");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build AuthorizationCodeTokensRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthorizationCodeTokensRequest", generator="Immutables")
    static final class Json
    implements AuthorizationCodeTokensRequest {
        @Nullable
        String scope;
        @Nullable
        GrantType grantType;
        @Nullable
        String code;
        @Nullable
        String redirectUri;
        @Nullable
        String clientId;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(GrantType grantType) {
            this.grantType = grantType;
        }

        @JsonProperty(value="code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="redirect_uri")
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @JsonProperty(value="client_id")
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRedirectUri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }
    }
}

