/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.util.Arrays;
import org.projectnessie.client.http.impl.HttpUtils;

public final class Status {
    private static final Status[][] LINES = new Status[10][];
    public static final int OK_CODE = 200;
    public static final Status OK;
    public static final int CREATED_CODE = 201;
    public static final Status CREATED;
    public static final int ACCEPTED_CODE = 202;
    public static final Status ACCEPTED;
    public static final int NO_CONTENT_CODE = 204;
    public static final Status NO_CONTENT;
    public static final int RESET_CONTENT_CODE = 205;
    public static final Status RESET_CONTENT;
    public static final int PARTIAL_CONTENT_CODE = 206;
    public static final Status PARTIAL_CONTENT;
    public static final int MOVED_PERMANENTLY_CODE = 301;
    public static final Status MOVED_PERMANENTLY;
    public static final int FOUND_CODE = 302;
    public static final Status FOUND;
    public static final int SEE_OTHER_CODE = 303;
    public static final Status SEE_OTHER;
    public static final int NOT_MODIFIED_CODE = 304;
    public static final Status NOT_MODIFIED;
    public static final int USE_PROXY_CODE = 305;
    public static final Status USE_PROXY;
    public static final int TEMPORARY_REDIRECT_CODE = 307;
    public static final Status TEMPORARY_REDIRECT;
    public static final int BAD_REQUEST_CODE = 400;
    public static final Status BAD_REQUEST;
    public static final int UNAUTHORIZED_CODE = 401;
    public static final Status UNAUTHORIZED;
    public static final int PAYMENT_REQUIRED_CODE = 402;
    public static final Status PAYMENT_REQUIRED;
    public static final int FORBIDDEN_CODE = 403;
    public static final Status FORBIDDEN;
    public static final int NOT_FOUND_CODE = 404;
    public static final Status NOT_FOUND;
    public static final int METHOD_NOT_ALLOWED_CODE = 405;
    public static final Status METHOD_NOT_ALLOWED;
    public static final int NOT_ACCEPTABLE_CODE = 406;
    public static final Status NOT_ACCEPTABLE;
    public static final int PROXY_AUTHENTICATION_REQUIRED_CODE = 407;
    public static final Status PROXY_AUTHENTICATION_REQUIRED;
    public static final int REQUEST_TIMEOUT_CODE = 408;
    public static final Status REQUEST_TIMEOUT;
    public static final int CONFLICT_CODE = 409;
    public static final Status CONFLICT;
    public static final int GONE_CODE = 410;
    public static final Status GONE;
    public static final int LENGTH_REQUIRED_CODE = 411;
    public static final Status LENGTH_REQUIRED;
    public static final int PRECONDITION_FAILED_CODE = 412;
    public static final Status PRECONDITION_FAILED;
    public static final int REQUEST_ENTITY_TOO_LARGE_CODE = 413;
    public static final Status REQUEST_ENTITY_TOO_LARGE;
    public static final int REQUEST_URI_TOO_LONG_CODE = 414;
    public static final Status REQUEST_URI_TOO_LONG;
    public static final int UNSUPPORTED_MEDIA_TYPE_CODE = 415;
    public static final Status UNSUPPORTED_MEDIA_TYPE;
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE_CODE = 416;
    public static final Status REQUESTED_RANGE_NOT_SATISFIABLE;
    public static final int EXPECTATION_FAILED_CODE = 417;
    public static final Status EXPECTATION_FAILED;
    public static final int PRECONDITION_REQUIRED_CODE = 428;
    public static final Status PRECONDITION_REQUIRED;
    public static final int TOO_MANY_REQUESTS_CODE = 429;
    public static final Status TOO_MANY_REQUESTS;
    public static final int REQUEST_HEADER_FIELDS_TOO_LARGE_CODE = 431;
    public static final Status REQUEST_HEADER_FIELDS_TOO_LARGE;
    public static final int INTERNAL_SERVER_ERROR_CODE = 500;
    public static final Status INTERNAL_SERVER_ERROR;
    public static final int NOT_IMPLEMENTED_CODE = 501;
    public static final Status NOT_IMPLEMENTED;
    public static final int BAD_GATEWAY_CODE = 502;
    public static final Status BAD_GATEWAY;
    public static final int SERVICE_UNAVAILABLE_CODE = 503;
    public static final Status SERVICE_UNAVAILABLE;
    public static final int GATEWAY_TIMEOUT_CODE = 504;
    public static final Status GATEWAY_TIMEOUT;
    public static final int HTTP_VERSION_NOT_SUPPORTED_CODE = 505;
    public static final Status HTTP_VERSION_NOT_SUPPORTED;
    public static final int NETWORK_AUTHENTICATION_REQUIRED_CODE = 511;
    public static final Status NETWORK_AUTHENTICATION_REQUIRED;
    private final int code;
    private final String reason;

    private static Status addCode(int code, String reason) {
        Status[][] lines = LINES;
        int line = code / 100;
        Status[] l = lines[line];
        int code100 = code % 100;
        if (l.length < code100 + 1) {
            lines[line] = Arrays.copyOf(l, code100 + 1);
            l = lines[line];
        }
        l[code100] = new Status(code, reason);
        return l[code100];
    }

    private Status(int statusCode, String reason) {
        this.code = statusCode;
        this.reason = reason;
    }

    public static Status fromCode(int code) {
        Status s;
        HttpUtils.checkArgument(code >= 0 && code < 1000, "Illegal HTTP status code %d", code);
        int code100 = code % 100;
        Status[] l = LINES[code / 100];
        if (l.length > code100 && (s = l[code100]) != null) {
            return s;
        }
        return new Status(code, "");
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return this.code == status.code && this.reason.equals(status.reason);
    }

    public int hashCode() {
        int result = this.code;
        result = 31 * result + this.reason.hashCode();
        return result;
    }

    public String toString() {
        return this.code + "/" + this.reason;
    }

    static {
        Arrays.fill((Object[])LINES, new Status[0]);
        OK = Status.addCode(200, "OK");
        CREATED = Status.addCode(201, "Created");
        ACCEPTED = Status.addCode(202, "Accepted");
        NO_CONTENT = Status.addCode(204, "No Content");
        RESET_CONTENT = Status.addCode(205, "Reset Content");
        PARTIAL_CONTENT = Status.addCode(206, "Partial Content");
        MOVED_PERMANENTLY = Status.addCode(301, "Moved Permanently");
        FOUND = Status.addCode(302, "Found");
        SEE_OTHER = Status.addCode(303, "See Other");
        NOT_MODIFIED = Status.addCode(304, "Not Modified");
        USE_PROXY = Status.addCode(305, "Use Proxy");
        TEMPORARY_REDIRECT = Status.addCode(307, "Temporary Redirect");
        BAD_REQUEST = Status.addCode(400, "Bad Request");
        UNAUTHORIZED = Status.addCode(401, "Unauthorized");
        PAYMENT_REQUIRED = Status.addCode(402, "Payment Required");
        FORBIDDEN = Status.addCode(403, "Forbidden");
        NOT_FOUND = Status.addCode(404, "Not Found");
        METHOD_NOT_ALLOWED = Status.addCode(405, "Method Not Allowed");
        NOT_ACCEPTABLE = Status.addCode(406, "Not Acceptable");
        PROXY_AUTHENTICATION_REQUIRED = Status.addCode(407, "Proxy Authentication Required");
        REQUEST_TIMEOUT = Status.addCode(408, "Request Timeout");
        CONFLICT = Status.addCode(409, "Conflict");
        GONE = Status.addCode(410, "Gone");
        LENGTH_REQUIRED = Status.addCode(411, "Length Required");
        PRECONDITION_FAILED = Status.addCode(412, "Precondition Failed");
        REQUEST_ENTITY_TOO_LARGE = Status.addCode(413, "Request Entity Too Large");
        REQUEST_URI_TOO_LONG = Status.addCode(414, "Request-URI Too Long");
        UNSUPPORTED_MEDIA_TYPE = Status.addCode(415, "Unsupported Media Type");
        REQUESTED_RANGE_NOT_SATISFIABLE = Status.addCode(416, "Requested Range Not Satisfiable");
        EXPECTATION_FAILED = Status.addCode(417, "Expectation Failed");
        PRECONDITION_REQUIRED = Status.addCode(428, "Precondition Required");
        TOO_MANY_REQUESTS = Status.addCode(429, "Too Many Requests");
        REQUEST_HEADER_FIELDS_TOO_LARGE = Status.addCode(431, "Request Header Fields Too Large");
        INTERNAL_SERVER_ERROR = Status.addCode(500, "Internal Server Error");
        NOT_IMPLEMENTED = Status.addCode(501, "Not Implemented");
        BAD_GATEWAY = Status.addCode(502, "Bad Gateway");
        SERVICE_UNAVAILABLE = Status.addCode(503, "Service Unavailable");
        GATEWAY_TIMEOUT = Status.addCode(504, "Gateway Timeout");
        HTTP_VERSION_NOT_SUPPORTED = Status.addCode(505, "HTTP Version Not Supported");
        NETWORK_AUTHENTICATION_REQUIRED = Status.addCode(511, "Network Authentication Required");
    }
}

