/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.grammar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.projectnessie.nessie.cli.grammar.InvalidToken;
import org.projectnessie.nessie.cli.grammar.NessieCliLexer;
import org.projectnessie.nessie.cli.grammar.Node;
import org.projectnessie.nessie.cli.grammar.TokenSource;
import org.projectnessie.nessie.cli.grammar.ast.BooleanLiteral;
import org.projectnessie.nessie.cli.grammar.ast.Branch;
import org.projectnessie.nessie.cli.grammar.ast.Command;
import org.projectnessie.nessie.cli.grammar.ast.Equal;
import org.projectnessie.nessie.cli.grammar.ast.Ident;
import org.projectnessie.nessie.cli.grammar.ast.Keyword;
import org.projectnessie.nessie.cli.grammar.ast.MultiLineComment;
import org.projectnessie.nessie.cli.grammar.ast.PositiveIntLiteral;
import org.projectnessie.nessie.cli.grammar.ast.Semicolon;
import org.projectnessie.nessie.cli.grammar.ast.SingleLineComment;
import org.projectnessie.nessie.cli.grammar.ast.SingleLineDashComment;
import org.projectnessie.nessie.cli.grammar.ast.StringLiteral;
import org.projectnessie.nessie.cli.grammar.ast.Tag;
import org.projectnessie.nessie.cli.grammar.ast.UriLiteral;
import org.projectnessie.nessie.cli.grammar.ast.Whitespace;

public class Token
implements CharSequence,
Node.TerminalNode {
    private NessieCliLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;

    @Override
    public void truncate(int amount) {
        int newEndOffset = Math.max(this.getBeginOffset(), this.getEndOffset() - amount);
        this.setEndOffset(newEndOffset);
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public NessieCliLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (NessieCliLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        NessieCliLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (Token)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return (Token)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        NessieCliLexer ts = this.getTokenSource();
        int beginOffset = this.getBeginOffset();
        int endOffset = this.getEndOffset();
        return ts == null || beginOffset <= 0 && endOffset <= 0 ? null : ts.getText(beginOffset, endOffset);
    }

    protected Token() {
    }

    public Token(TokenType type, NessieCliLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, NessieCliLexer tokenSource) {
        Token result = Token.newToken(type, tokenSource, 0, 0);
        return result;
    }

    public static Token newToken(TokenType type, String image, NessieCliLexer tokenSource) {
        Token newToken = Token.newToken(type, tokenSource);
        return newToken;
    }

    public static Token newToken(TokenType type, NessieCliLexer tokenSource, int beginOffset, int endOffset) {
        switch (type.ordinal()) {
            case 48: {
                return new Keyword(TokenType.NAMESPACE, tokenSource, beginOffset, endOffset);
            }
            case 10: {
                return new Command(TokenType.CREATE, tokenSource, beginOffset, endOffset);
            }
            case 11: {
                return new Command(TokenType.REVERT, tokenSource, beginOffset, endOffset);
            }
            case 22: {
                return new Keyword(TokenType.DRY, tokenSource, beginOffset, endOffset);
            }
            case 26: {
                return new Keyword(TokenType.FROM, tokenSource, beginOffset, endOffset);
            }
            case 28: {
                return new Keyword(TokenType.VIEW, tokenSource, beginOffset, endOffset);
            }
            case 34: {
                return new Keyword(TokenType.TABLE, tokenSource, beginOffset, endOffset);
            }
            case 13: {
                return new Semicolon(TokenType.SEMICOLON, tokenSource, beginOffset, endOffset);
            }
            case 57: {
                return new Whitespace(TokenType.WHITESPACE, tokenSource, beginOffset, endOffset);
            }
            case 49: {
                return new Keyword(TokenType.TIMESTAMP, tokenSource, beginOffset, endOffset);
            }
            case 52: {
                return new Keyword(TokenType.CONTAINING, tokenSource, beginOffset, endOffset);
            }
            case 16: {
                return new Keyword(TokenType.IF, tokenSource, beginOffset, endOffset);
            }
            case 43: {
                return new Keyword(TokenType.LICENSE, tokenSource, beginOffset, endOffset);
            }
            case 30: {
                return new Keyword(TokenType.ALLOW, tokenSource, beginOffset, endOffset);
            }
            case 47: {
                return new Keyword(TokenType.BEHAVIORS, tokenSource, beginOffset, endOffset);
            }
            case 61: {
                return new PositiveIntLiteral(TokenType.POSITIVE_INT, tokenSource, beginOffset, endOffset);
            }
            case 17: {
                return new Keyword(TokenType.IN, tokenSource, beginOffset, endOffset);
            }
            case 23: {
                return new Keyword(TokenType.LOG, tokenSource, beginOffset, endOffset);
            }
            case 53: {
                return new BooleanLiteral(TokenType.TRUE, tokenSource, beginOffset, endOffset);
            }
            case 35: {
                return new Keyword(TokenType.USING, tokenSource, beginOffset, endOffset);
            }
            case 24: {
                return new Keyword(TokenType.NOT, tokenSource, beginOffset, endOffset);
            }
            case 15: {
                return new Keyword(TokenType.AT, tokenSource, beginOffset, endOffset);
            }
            case 31: {
                return new Keyword(TokenType.FORCE, tokenSource, beginOffset, endOffset);
            }
            case 21: {
                return new Keyword(TokenType.AND, tokenSource, beginOffset, endOffset);
            }
            case 3: {
                return new Command(TokenType.LIST, tokenSource, beginOffset, endOffset);
            }
            case 42: {
                return new Keyword(TokenType.DELETES, tokenSource, beginOffset, endOffset);
            }
            case 6: {
                return new Command(TokenType.EXIT, tokenSource, beginOffset, endOffset);
            }
            case 7: {
                return new Command(TokenType.ALTER, tokenSource, beginOffset, endOffset);
            }
            case 27: {
                return new Keyword(TokenType.INTO, tokenSource, beginOffset, endOffset);
            }
            case 62: {
                return new SingleLineDashComment(TokenType.SINGLE_LINE_DASH_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case 25: {
                return new Keyword(TokenType.SET, tokenSource, beginOffset, endOffset);
            }
            case 8: {
                return new Command(TokenType.MERGE, tokenSource, beginOffset, endOffset);
            }
            case 33: {
                return new Keyword(TokenType.STATE, tokenSource, beginOffset, endOffset);
            }
            case 12: {
                return new Command(TokenType.CONNECT, tokenSource, beginOffset, endOffset);
            }
            case 32: {
                return new Keyword(TokenType.LIMIT, tokenSource, beginOffset, endOffset);
            }
            case 9: {
                return new Command(TokenType.ASSIGN, tokenSource, beginOffset, endOffset);
            }
            case 60: {
                return new UriLiteral(TokenType.URI, tokenSource, beginOffset, endOffset);
            }
            case 2: {
                return new Command(TokenType.DROP, tokenSource, beginOffset, endOffset);
            }
            case 45: {
                return new Keyword(TokenType.CONTENTS, tokenSource, beginOffset, endOffset);
            }
            case 63: {
                return new SingleLineComment(TokenType.SINGLE_LINE_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case 18: {
                return new Keyword(TokenType.OF, tokenSource, beginOffset, endOffset);
            }
            case 50: {
                return new Keyword(TokenType.REFERENCE, tokenSource, beginOffset, endOffset);
            }
            case 40: {
                return new Keyword(TokenType.REMOVE, tokenSource, beginOffset, endOffset);
            }
            case 4: {
                return new Command(TokenType.SHOW, tokenSource, beginOffset, endOffset);
            }
            case 41: {
                return new Keyword(TokenType.CONTENT, tokenSource, beginOffset, endOffset);
            }
            case 59: {
                return new Ident(TokenType.IDENTIFIER, tokenSource, beginOffset, endOffset);
            }
            case 19: {
                return new Keyword(TokenType.ON, tokenSource, beginOffset, endOffset);
            }
            case 5: {
                return new Command(TokenType.HELP, tokenSource, beginOffset, endOffset);
            }
            case 55: {
                return new Branch(TokenType.BRANCH, tokenSource, beginOffset, endOffset);
            }
            case 46: {
                return new Keyword(TokenType.STARTING, tokenSource, beginOffset, endOffset);
            }
            case 38: {
                return new Keyword(TokenType.FILTER, tokenSource, beginOffset, endOffset);
            }
            case 64: {
                return new MultiLineComment(TokenType.MULTI_LINE_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case 37: {
                return new Keyword(TokenType.EXISTS, tokenSource, beginOffset, endOffset);
            }
            case 36: {
                return new Keyword(TokenType.COMMIT, tokenSource, beginOffset, endOffset);
            }
            case 1: {
                return new Command(TokenType.USE, tokenSource, beginOffset, endOffset);
            }
            case 14: {
                return new Equal(TokenType.EQUAL, tokenSource, beginOffset, endOffset);
            }
            case 44: {
                return new Keyword(TokenType.BEHAVIOR, tokenSource, beginOffset, endOffset);
            }
            case 29: {
                return new Keyword(TokenType.WITH, tokenSource, beginOffset, endOffset);
            }
            case 54: {
                return new BooleanLiteral(TokenType.FALSE, tokenSource, beginOffset, endOffset);
            }
            case 58: {
                return new StringLiteral(TokenType.STRING_LITERAL, tokenSource, beginOffset, endOffset);
            }
            case 20: {
                return new Keyword(TokenType.TO, tokenSource, beginOffset, endOffset);
            }
            case 56: {
                return new Tag(TokenType.TAG, tokenSource, beginOffset, endOffset);
            }
            case 39: {
                return new Keyword(TokenType.NORMAL, tokenSource, beginOffset, endOffset);
            }
            case 51: {
                return new Keyword(TokenType.REFERENCES, tokenSource, beginOffset, endOffset);
            }
            case 66: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        return this.toString();
    }

    @Override
    public String toString() {
        String result = this.getSource();
        if (result == null) {
            result = this.getType().getLiteralString();
        }
        return result;
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        USE,
        DROP,
        LIST,
        SHOW,
        HELP,
        EXIT,
        ALTER,
        MERGE,
        ASSIGN,
        CREATE,
        REVERT,
        CONNECT,
        SEMICOLON,
        EQUAL,
        AT,
        IF,
        IN,
        OF,
        ON,
        TO,
        AND,
        DRY,
        LOG,
        NOT,
        SET,
        FROM,
        INTO,
        VIEW,
        WITH,
        ALLOW,
        FORCE,
        LIMIT,
        STATE,
        TABLE,
        USING,
        COMMIT,
        EXISTS,
        FILTER,
        NORMAL,
        REMOVE,
        CONTENT,
        DELETES,
        LICENSE,
        BEHAVIOR,
        CONTENTS,
        STARTING,
        BEHAVIORS,
        NAMESPACE,
        TIMESTAMP,
        REFERENCE,
        REFERENCES,
        CONTAINING,
        TRUE,
        FALSE,
        BRANCH,
        TAG,
        WHITESPACE,
        STRING_LITERAL,
        IDENTIFIER,
        URI,
        POSITIVE_INT,
        SINGLE_LINE_DASH_COMMENT,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        DUMMY,
        INVALID;

        private String literalString;

        private TokenType() {
        }

        private TokenType(String literalString) {
            this.literalString = literalString;
        }

        @Override
        public String getLiteralString() {
            return this.literalString;
        }

        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

