/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.CatalogBridge;
import org.apache.spark.sql.execution.datasources.v2.CatalogUtils;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import scala.Tuple2;

final class NessieCatalogBridge
implements CatalogBridge {
    private final SparkContext sparkContext;
    private final NessieApiV1 api;
    private final CatalogPlugin currentCatalog;
    private final String catalogName;
    private final String confPrefix;

    NessieCatalogBridge(SparkContext sparkContext, CatalogPlugin currentCatalog, String catalogName) {
        this.sparkContext = sparkContext;
        this.currentCatalog = currentCatalog;
        this.catalogName = catalogName;
        this.confPrefix = "spark.sql.catalog." + catalogName + ".";
        SparkConf sparkConf = sparkContext.conf();
        Map<String, String> catalogConf = Arrays.stream(sparkConf.getAllWithPrefix(this.confPrefix)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        this.api = CatalogUtils.buildApi(x -> (String)catalogConf.get(x.replace("nessie.", "")));
    }

    @Override
    public Reference getCurrentRef() throws NessieReferenceNotFoundException {
        String refHash;
        SparkConf activeConf = this.sparkContext.conf();
        String refName = activeConf.get(this.confPrefix + "ref");
        try {
            refHash = activeConf.get(this.confPrefix + "ref.hash");
        }
        catch (NoSuchElementException e) {
            refHash = null;
        }
        try {
            Reference ref = this.api.getReference().refName(refName).get();
            if (refHash != null) {
                ref = ref.getType() == Reference.ReferenceType.BRANCH ? Branch.of(ref.getName(), refHash) : Tag.of(ref.getName(), refHash);
            }
            return ref;
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException("Could not find current reference " + refName + " configured in spark configuration for catalog '" + this.catalogName + "'.", e);
        }
    }

    @Override
    public void setCurrentRefForSpark(Reference ref, boolean configureRefAtHash) {
        SparkConf activeConf = this.sparkContext.conf();
        activeConf.set(this.confPrefix + "ref", ref.getName());
        if (configureRefAtHash) {
            activeConf.set(this.confPrefix + "ref.hash", ref.getHash());
        } else {
            activeConf.remove(this.confPrefix + "ref.hash");
        }
        Map<String, String> catalogConf = Arrays.stream(activeConf.getAllWithPrefix(this.confPrefix)).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        this.currentCatalog.initialize(this.catalogName, new CaseInsensitiveStringMap(catalogConf));
    }

    @Override
    public NessieApiV1 api() {
        return this.api;
    }

    @Override
    public CatalogPlugin currentCatalog() {
        return this.currentCatalog;
    }

    @Override
    public void close() {
        this.api.close();
    }
}

