/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.api.CreateNamespaceResult;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Namespace;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateNamespaceResult", generator="Immutables")
@Immutable
public final class ImmutableCreateNamespaceResult
implements CreateNamespaceResult {
    private final Namespace namespace;
    private final Branch effectiveBranch;

    private ImmutableCreateNamespaceResult(Namespace namespace, Branch effectiveBranch) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.effectiveBranch = Objects.requireNonNull(effectiveBranch, "effectiveBranch");
    }

    private ImmutableCreateNamespaceResult(ImmutableCreateNamespaceResult original, Namespace namespace, Branch effectiveBranch) {
        this.namespace = namespace;
        this.effectiveBranch = effectiveBranch;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Branch getEffectiveBranch() {
        return this.effectiveBranch;
    }

    public final ImmutableCreateNamespaceResult withNamespace(Namespace value) {
        if (this.namespace == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "namespace");
        return new ImmutableCreateNamespaceResult(this, newValue, this.effectiveBranch);
    }

    public final ImmutableCreateNamespaceResult withEffectiveBranch(Branch value) {
        if (this.effectiveBranch == value) {
            return this;
        }
        Branch newValue = Objects.requireNonNull(value, "effectiveBranch");
        return new ImmutableCreateNamespaceResult(this, this.namespace, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateNamespaceResult && this.equalTo(0, (ImmutableCreateNamespaceResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateNamespaceResult another) {
        return this.namespace.equals(another.namespace) && this.effectiveBranch.equals(another.effectiveBranch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namespace.hashCode();
        h += (h << 5) + this.effectiveBranch.hashCode();
        return h;
    }

    public String toString() {
        return "CreateNamespaceResult{namespace=" + String.valueOf(this.namespace) + ", effectiveBranch=" + String.valueOf(this.effectiveBranch) + "}";
    }

    public static ImmutableCreateNamespaceResult of(Namespace namespace, Branch effectiveBranch) {
        return new ImmutableCreateNamespaceResult(namespace, effectiveBranch);
    }

    public static ImmutableCreateNamespaceResult copyOf(CreateNamespaceResult instance) {
        if (instance instanceof ImmutableCreateNamespaceResult) {
            return (ImmutableCreateNamespaceResult)instance;
        }
        return ImmutableCreateNamespaceResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateNamespaceResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private static final long INIT_BIT_EFFECTIVE_BRANCH = 2L;
        private long initBits = 3L;
        @Nullable
        private Namespace namespace;
        @Nullable
        private Branch effectiveBranch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateNamespaceResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.namespace(instance.getNamespace());
            this.effectiveBranch(instance.getEffectiveBranch());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Namespace namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder effectiveBranch(Branch effectiveBranch) {
            this.effectiveBranch = Objects.requireNonNull(effectiveBranch, "effectiveBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCreateNamespaceResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateNamespaceResult(null, this.namespace, this.effectiveBranch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("effectiveBranch");
            }
            return "Cannot build CreateNamespaceResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

