/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ShowLogCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="ShowLogCommandSpec", generator="Immutables")
public final class ImmutableShowLogCommandSpec
implements ShowLogCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    @Nullable
    private final String ref;
    @Nullable
    private final String refTimestampOrHash;
    @Nullable
    private final Integer limit;

    private ImmutableShowLogCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.limit = builder.limit;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : ShowLogCommandSpec.super.sourceNode();
    }

    private ImmutableShowLogCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable Integer limit) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.limit = limit;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    @Override
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public final ImmutableShowLogCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(value, this.sourceNode, this.ref, this.refTimestampOrHash, this.limit);
    }

    public final ImmutableShowLogCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, value, this.ref, this.refTimestampOrHash, this.limit);
    }

    public final ImmutableShowLogCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, this.sourceNode, value, this.refTimestampOrHash, this.limit);
    }

    public final ImmutableShowLogCommandSpec withRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, this.sourceNode, this.ref, value, this.limit);
    }

    public final ImmutableShowLogCommandSpec withLimit(@Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableShowLogCommandSpec(this.inCatalog, this.sourceNode, this.ref, this.refTimestampOrHash, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShowLogCommandSpec && this.equalsByValue((ImmutableShowLogCommandSpec)another);
    }

    private boolean equalsByValue(ImmutableShowLogCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ShowLogCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).add("limit", (Object)this.limit).toString();
    }

    public static ImmutableShowLogCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable Integer limit) {
        return new ImmutableShowLogCommandSpec(inCatalog, sourceNode, ref, refTimestampOrHash, limit);
    }

    public static ImmutableShowLogCommandSpec copyOf(ShowLogCommandSpec instance) {
        if (instance instanceof ImmutableShowLogCommandSpec) {
            return (ImmutableShowLogCommandSpec)instance;
        }
        return ImmutableShowLogCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShowLogCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private String ref;
        private String refTimestampOrHash;
        private Integer limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShowLogCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ShowLogCommandSpec) {
                instance = (ShowLogCommandSpec)object;
                Integer limitValue = instance.getLimit();
                if (limitValue != null) {
                    this.limit(limitValue);
                }
                if ((bits & 1L) == 0L) {
                    String refValue2 = instance.getRef();
                    if (refValue2 != null) {
                        this.ref(refValue2);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Node sourceNodeValue2 = instance.sourceNode();
                    if (sourceNodeValue2 != null) {
                        this.sourceNode(sourceNodeValue2);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public ImmutableShowLogCommandSpec build() {
            return new ImmutableShowLogCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

