/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.UseReferenceCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="UseReferenceCommandSpec", generator="Immutables")
public final class ImmutableUseReferenceCommandSpec
implements UseReferenceCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    @Nullable
    private final String refType;
    private final String ref;
    @Nullable
    private final String refTimestampOrHash;

    private ImmutableUseReferenceCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String refType, String ref, @Nullable String refTimestampOrHash) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.refType = refType;
        this.ref = Objects.requireNonNull(ref, "ref");
        this.refTimestampOrHash = refTimestampOrHash;
    }

    private ImmutableUseReferenceCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.refType = builder.refType;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : UseReferenceCommandSpec.super.sourceNode();
    }

    private ImmutableUseReferenceCommandSpec(ImmutableUseReferenceCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String refType, String ref, @Nullable String refTimestampOrHash) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.refType = refType;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    @Nullable
    public String getRefType() {
        return this.refType;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    public final ImmutableUseReferenceCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableUseReferenceCommandSpec(this, value, this.sourceNode, this.refType, this.ref, this.refTimestampOrHash);
    }

    public final ImmutableUseReferenceCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableUseReferenceCommandSpec(this, this.inCatalog, value, this.refType, this.ref, this.refTimestampOrHash);
    }

    public final ImmutableUseReferenceCommandSpec withRefType(@Nullable String value) {
        if (Objects.equals(this.refType, value)) {
            return this;
        }
        return new ImmutableUseReferenceCommandSpec(this, this.inCatalog, this.sourceNode, value, this.ref, this.refTimestampOrHash);
    }

    public final ImmutableUseReferenceCommandSpec withRef(String value) {
        String newValue = Objects.requireNonNull(value, "ref");
        if (this.ref.equals(newValue)) {
            return this;
        }
        return new ImmutableUseReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, newValue, this.refTimestampOrHash);
    }

    public final ImmutableUseReferenceCommandSpec withRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableUseReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, this.ref, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUseReferenceCommandSpec && this.equalsByValue((ImmutableUseReferenceCommandSpec)another);
    }

    private boolean equalsByValue(ImmutableUseReferenceCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && Objects.equals(this.refType, another.refType) && this.ref.equals(another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + Objects.hashCode(this.refType);
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UseReferenceCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("refType", (Object)this.refType).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).toString();
    }

    public static ImmutableUseReferenceCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String refType, String ref, @Nullable String refTimestampOrHash) {
        return new ImmutableUseReferenceCommandSpec(inCatalog, sourceNode, refType, ref, refTimestampOrHash);
    }

    public static ImmutableUseReferenceCommandSpec copyOf(UseReferenceCommandSpec instance) {
        if (instance instanceof ImmutableUseReferenceCommandSpec) {
            return (ImmutableUseReferenceCommandSpec)instance;
        }
        return ImmutableUseReferenceCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UseReferenceCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REF = 1L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 1L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private String refType;
        private String ref;
        private String refTimestampOrHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UseReferenceCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof UseReferenceCommandSpec) {
                instance = (UseReferenceCommandSpec)object;
                String refTypeValue = instance.getRefType();
                if (refTypeValue != null) {
                    this.refType(refTypeValue);
                }
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Node sourceNodeValue2 = instance.sourceNode();
                    if (sourceNodeValue2 != null) {
                        this.sourceNode(sourceNodeValue2);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refType(@Nullable String refType) {
            this.refType = refType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(String ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        public ImmutableUseReferenceCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUseReferenceCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ref");
            }
            return "Cannot build UseReferenceCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

