/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.builder;

import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.PaginatedResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    public static <ENTRY, RESP extends PaginatedResponse> Stream<ENTRY> generateStream(Function<RESP, List<ENTRY>> entriesExtractor, PageFetcher<RESP> pageFetcher) throws NessieNotFoundException {
        return new ResultStreamPaginator<RESP, ENTRY>(entriesExtractor, pageFetcher).generateStream();
    }

    static final class ResultStreamPaginator<R extends PaginatedResponse, E> {
        private final Function<R, List<E>> entriesFromResponse;
        private final PageFetcher<R> fetcher;

        ResultStreamPaginator(Function<R, List<E>> entriesFromResponse, PageFetcher<R> fetcher) {
            this.entriesFromResponse = entriesFromResponse;
            this.fetcher = fetcher;
        }

        Stream<E> generateStream() throws NessieNotFoundException {
            final PaginatedResponse firstPage = (PaginatedResponse)this.fetcher.fetchPage(null);
            Spliterator spliterator = new Spliterator<E>(){
                private String pageToken;
                private boolean eof;
                private int offsetInPage;
                private R currentPage;
                {
                    this.currentPage = firstPage;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    if (this.eof) {
                        return false;
                    }
                    if (this.currentPage != null && entriesFromResponse.apply(this.currentPage).size() == this.offsetInPage) {
                        if (!this.currentPage.isHasMore()) {
                            this.eof = true;
                            return false;
                        }
                        this.pageToken = this.currentPage.getToken();
                        this.currentPage = null;
                        this.offsetInPage = 0;
                    }
                    if (this.currentPage == null) {
                        try {
                            this.currentPage = (PaginatedResponse)fetcher.fetchPage(this.pageToken);
                            this.offsetInPage = 0;
                            if (entriesFromResponse.apply(this.currentPage).isEmpty()) {
                                if (this.currentPage.isHasMore()) {
                                    throw new IllegalStateException("Backend returned empty page, but indicates there are more results");
                                }
                                this.eof = true;
                                return false;
                            }
                        }
                        catch (NessieNotFoundException e) {
                            this.eof = true;
                            throw new RuntimeException(e);
                        }
                    }
                    action.accept(entriesFromResponse.apply(this.currentPage).get(this.offsetInPage++));
                    return true;
                }

                @Override
                public Spliterator<E> trySplit() {
                    return null;
                }

                @Override
                public long estimateSize() {
                    return 0L;
                }

                @Override
                public int characteristics() {
                    return 0;
                }
            };
            return StreamSupport.stream(spliterator, false);
        }
    }

    @FunctionalInterface
    public static interface PageFetcher<R> {
        public R fetchPage(String var1) throws NessieNotFoundException;
    }
}

