/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.v2.params.AbstractParams;
import org.projectnessie.model.ContentKey;

public abstract class KeyRangeParams<IMPL extends KeyRangeParams<IMPL>>
extends AbstractParams<IMPL> {
    @Parameter(description="The lower bound of the content key range to retrieve (inclusive). The content keys of all returned entries will be greater than or equal to the min-value. Content-keys are compared as a 'whole', unlike prefix-keys.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n", examples={@ExampleObject(ref="ContentKeyGet")})
    @QueryParam(value="min-key")
    @Nullable
    private ContentKey minKey;
    @Parameter(description="The upper bound of the content key range to retrieve (inclusive). The content keys of all returned entries will be less than or equal to the max-value. Content-keys are compared as a 'whole', unlike prefix-keys.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n", examples={@ExampleObject(ref="ContentKeyGet")})
    @QueryParam(value="max-key")
    @Nullable
    private ContentKey maxKey;
    @Parameter(description="The content key prefix to retrieve (inclusive). A content key matches a given prefix, a content key's elements starts with all elements of the prefix-key. Key prefixes exactly match key-element boundaries.\n\nMust not be combined with min/max-key parameters.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n", examples={@ExampleObject(ref="ContentKeyGet")})
    @QueryParam(value="prefix-key")
    @Nullable
    private ContentKey prefixKey;

    protected KeyRangeParams() {
    }

    public KeyRangeParams(@Nullable Integer maxRecords, @Nullable String pageToken, @Nullable ContentKey minKey, @Nullable ContentKey maxKey, @Nullable ContentKey prefixKey) {
        super(maxRecords, pageToken);
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.prefixKey = prefixKey;
    }

    @Nullable
    public ContentKey minKey() {
        return this.minKey;
    }

    @Nullable
    public ContentKey maxKey() {
        return this.maxKey;
    }

    @Nullable
    public ContentKey prefixKey() {
        return this.prefixKey;
    }
}

