/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClientBuilderImpl;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;

public interface HttpClient
extends AutoCloseable {
    default public HttpRequest newRequest() {
        return this.newRequest(this.getBaseUri());
    }

    public HttpRequest newRequest(URI var1);

    public static Builder builder() {
        return new HttpClientBuilderImpl();
    }

    public URI getBaseUri();

    @Override
    public void close();

    public static interface Builder {
        public Builder copy();

        @CanIgnoreReturnValue
        public Builder setClientSpec(int var1);

        @CanIgnoreReturnValue
        public Builder setBaseUri(URI var1);

        @CanIgnoreReturnValue
        public Builder setDisableCompression(boolean var1);

        @CanIgnoreReturnValue
        public Builder setObjectMapper(ObjectMapper var1);

        @CanIgnoreReturnValue
        public Builder setJsonView(Class<?> var1);

        @CanIgnoreReturnValue
        public Builder setResponseFactory(HttpResponseFactory var1);

        @CanIgnoreReturnValue
        public Builder setSslContext(SSLContext var1);

        @CanIgnoreReturnValue
        public Builder setSslParameters(SSLParameters var1);

        @CanIgnoreReturnValue
        public Builder setAuthentication(HttpAuthentication var1);

        @CanIgnoreReturnValue
        public Builder setHttp2Upgrade(boolean var1);

        @CanIgnoreReturnValue
        public Builder setFollowRedirects(String var1);

        @CanIgnoreReturnValue
        public Builder setForceUrlConnectionClient(boolean var1);

        @CanIgnoreReturnValue
        public Builder setReadTimeoutMillis(int var1);

        @CanIgnoreReturnValue
        public Builder setConnectionTimeoutMillis(int var1);

        @CanIgnoreReturnValue
        public Builder addRequestFilter(RequestFilter var1);

        @CanIgnoreReturnValue
        public Builder addResponseFilter(ResponseFilter var1);

        @CanIgnoreReturnValue
        public Builder clearRequestFilters();

        @CanIgnoreReturnValue
        public Builder clearResponseFilters();

        @CanIgnoreReturnValue
        public Builder addTracing();

        public HttpClient build();
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

