/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableAddedContent;
import org.projectnessie.model.ImmutableCommitResponse;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="Commit Response")
@JsonSerialize(as=ImmutableCommitResponse.class)
@JsonDeserialize(as=ImmutableCommitResponse.class)
@Value.Immutable
public interface CommitResponse {
    public static ImmutableCommitResponse.Builder builder() {
        return ImmutableCommitResponse.builder();
    }

    @NotNull
    public Branch getTargetBranch();

    @JsonView(value={Views.V2.class})
    @Nullable
    public List<AddedContent> getAddedContents();

    @Value.NonAttribute
    default public Map<ContentKey, String> toAddedContentsMap() {
        List<AddedContent> added = this.getAddedContents();
        if (added == null) {
            throw new UnsupportedOperationException("toAddedContentsMap is not available in API v1");
        }
        return added.stream().collect(Collectors.toMap(AddedContent::getKey, AddedContent::contentId));
    }

    default public <T extends Content> T contentWithAssignedId(ContentKey key, T content) {
        List<AddedContent> addedContents = this.getAddedContents();
        if (addedContents == null) {
            throw new UnsupportedOperationException("toAddedContentsMap is not available in API v1");
        }
        return (T)this.getAddedContents().stream().filter(added -> added.getKey().equals(key)).findFirst().map(added -> content.withId(added.contentId())).orElse(content);
    }

    @JsonSerialize(as=ImmutableAddedContent.class)
    @JsonDeserialize(as=ImmutableAddedContent.class)
    @Value.Immutable
    public static interface AddedContent {
        @NotNull
        @Value.Parameter(order=1)
        public ContentKey getKey();

        @NotNull
        @Value.Parameter(order=2)
        public String contentId();

        public static AddedContent addedContent(ContentKey key, String contentId) {
            return ImmutableAddedContent.of(key, contentId);
        }
    }
}

