/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.jsongrammar;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;
import org.projectnessie.nessie.cli.jsongrammar.InvalidToken;
import org.projectnessie.nessie.cli.jsongrammar.Token;
import org.projectnessie.nessie.cli.jsongrammar.TokenSource;

public class JsonCLexer
extends TokenSource {
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = null;
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static NfaFunction[] nfaFunctions;

    public JsonCLexer(CharSequence input) {
        this("input", input);
    }

    public JsonCLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.JSON, 1, 1);
    }

    public JsonCLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(51);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(51);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(51);
        BitSet nextStates = new BitSet(51);
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = JsonCLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = JsonCLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.COLON, Token.TokenType.COMMA, Token.TokenType.OPEN_BRACKET, Token.TokenType.CLOSE_BRACKET, Token.TokenType.OPEN_BRACE, Token.TokenType.CLOSE_BRACE, Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.NULL, Token.TokenType.STRING_LITERAL, Token.TokenType.NUMBER});
        unparsedTokens = EnumSet.of(Token.TokenType.SINGLE_LINE_COMMENT, Token.TokenType.MULTI_LINE_COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType.WHITESPACE);
        moreTokens = EnumSet.noneOf(Token.TokenType.class);
        JSON.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        JSON;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class JSON {
        private static final int[] NFA_MOVES_JSON_40 = JSON.NFA_MOVES_JSON_40_init();

        private JSON() {
        }

        private static Token.TokenType getNfaNameJSONIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL)) {
                    nextStates.set(9);
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NUMBER)) {
                    nextStates.set(10);
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                    nextStates.set(14);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    nextStates.set(12);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(19);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NULL)) {
                    nextStates.set(29);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(16);
                }
            } else if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NUMBER)) {
                    nextStates.set(22);
                    type = Token.TokenType.NUMBER;
                }
            } else if (ch >= 49 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NUMBER)) {
                    nextStates.set(4);
                    type = Token.TokenType.NUMBER;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(2);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(2);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(2);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 32) {
                if (validTypes == null || validTypes.contains(Token.TokenType.WHITESPACE)) {
                    nextStates.set(2);
                    type = Token.TokenType.WHITESPACE;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_BRACE)) {
                    type = Token.TokenType.CLOSE_BRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OPEN_BRACE)) {
                    type = Token.TokenType.OPEN_BRACE;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_BRACKET)) {
                    type = Token.TokenType.CLOSE_BRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OPEN_BRACKET)) {
                    type = Token.TokenType.OPEN_BRACKET;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 58 && (validTypes == null || validTypes.contains(Token.TokenType.COLON))) {
                type = Token.TokenType.COLON;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJSONIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch == 47) {
                return Token.TokenType.MULTI_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9) {
                nextStates.set(2);
                type = Token.TokenType.WHITESPACE;
            } else if (ch == 10) {
                nextStates.set(2);
                type = Token.TokenType.WHITESPACE;
            } else if (ch == 13) {
                nextStates.set(2);
                type = Token.TokenType.WHITESPACE;
            } else if (ch == 32) {
                nextStates.set(2);
                type = Token.TokenType.WHITESPACE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJSONIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(6);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(18);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(4);
                type = Token.TokenType.NUMBER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJSONIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(5);
                return Token.TokenType.NUMBER;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(7);
                return Token.TokenType.NUMBER;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(18);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(7);
                type = Token.TokenType.NUMBER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJSONIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 32 || ch == 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(9);
            } else if (ch == 92) {
                nextStates.set(23);
                nextStates.set(28);
            } else if (ch == 34) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJSONIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 48) {
                nextStates.set(22);
                type = Token.TokenType.NUMBER;
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(4);
                type = Token.TokenType.NUMBER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameJSONIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.NULL;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(13);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(13);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch == 42) {
                nextStates.set(15);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(15);
            }
            if (ch == 42) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(5);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(21);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(6);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(26);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(27);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (TokenSource.checkIntervals(NFA_MOVES_JSON_40, ch)) {
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(30);
            }
            return null;
        }

        private static Token.TokenType getNfaNameJSONIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(11);
            }
            return null;
        }

        private static int[] NFA_MOVES_JSON_40_init() {
            return new int[]{34, 34, 47, 47, 92, 92, 98, 98, 102, 102, 110, 110, 114, 114, 116, 116};
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{JSON::getNfaNameJSONIndex0, JSON::getNfaNameJSONIndex1, JSON::getNfaNameJSONIndex2, JSON::getNfaNameJSONIndex3, JSON::getNfaNameJSONIndex4, JSON::getNfaNameJSONIndex5, JSON::getNfaNameJSONIndex6, JSON::getNfaNameJSONIndex7, JSON::getNfaNameJSONIndex8, JSON::getNfaNameJSONIndex9, JSON::getNfaNameJSONIndex10, JSON::getNfaNameJSONIndex11, JSON::getNfaNameJSONIndex12, JSON::getNfaNameJSONIndex13, JSON::getNfaNameJSONIndex14, JSON::getNfaNameJSONIndex15, JSON::getNfaNameJSONIndex16, JSON::getNfaNameJSONIndex17, JSON::getNfaNameJSONIndex18, JSON::getNfaNameJSONIndex19, JSON::getNfaNameJSONIndex20, JSON::getNfaNameJSONIndex21, JSON::getNfaNameJSONIndex22, JSON::getNfaNameJSONIndex23, JSON::getNfaNameJSONIndex24, JSON::getNfaNameJSONIndex25, JSON::getNfaNameJSONIndex26, JSON::getNfaNameJSONIndex27, JSON::getNfaNameJSONIndex28, JSON::getNfaNameJSONIndex29, JSON::getNfaNameJSONIndex30};
        }
    }
}

