/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.AssignReferenceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithTypeCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AssignReferenceCommandSpec", generator="Immutables")
@Immutable
public final class ImmutableAssignReferenceCommandSpec
implements AssignReferenceCommandSpec {
    @jakarta.annotation.Nullable
    private final String inCatalog;
    @jakarta.annotation.Nullable
    private final Node sourceNode;
    private final String refType;
    private final String ref;
    private final String to;
    @jakarta.annotation.Nullable
    private final String refTimestampOrHash;

    private ImmutableAssignReferenceCommandSpec(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String refType, String ref, String to, @jakarta.annotation.Nullable String refTimestampOrHash) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.refType = Objects.requireNonNull(refType, "refType");
        this.ref = Objects.requireNonNull(ref, "ref");
        this.to = Objects.requireNonNull(to, "to");
        this.refTimestampOrHash = refTimestampOrHash;
    }

    private ImmutableAssignReferenceCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.refType = builder.refType;
        this.ref = builder.ref;
        this.to = builder.to;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : AssignReferenceCommandSpec.super.sourceNode();
    }

    private ImmutableAssignReferenceCommandSpec(ImmutableAssignReferenceCommandSpec original, @jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String refType, String ref, String to, @jakarta.annotation.Nullable String refTimestampOrHash) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.refType = refType;
        this.ref = ref;
        this.to = to;
        this.refTimestampOrHash = refTimestampOrHash;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @jakarta.annotation.Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getRefType() {
        return this.refType;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    public final ImmutableAssignReferenceCommandSpec withInCatalog(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableAssignReferenceCommandSpec(this, value, this.sourceNode, this.refType, this.ref, this.to, this.refTimestampOrHash);
    }

    public final ImmutableAssignReferenceCommandSpec withSourceNode(@jakarta.annotation.Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableAssignReferenceCommandSpec(this, this.inCatalog, value, this.refType, this.ref, this.to, this.refTimestampOrHash);
    }

    public final ImmutableAssignReferenceCommandSpec withRefType(String value) {
        String newValue = Objects.requireNonNull(value, "refType");
        if (this.refType.equals(newValue)) {
            return this;
        }
        return new ImmutableAssignReferenceCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.ref, this.to, this.refTimestampOrHash);
    }

    public final ImmutableAssignReferenceCommandSpec withRef(String value) {
        String newValue = Objects.requireNonNull(value, "ref");
        if (this.ref.equals(newValue)) {
            return this;
        }
        return new ImmutableAssignReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, newValue, this.to, this.refTimestampOrHash);
    }

    public final ImmutableAssignReferenceCommandSpec withTo(String value) {
        String newValue = Objects.requireNonNull(value, "to");
        if (this.to.equals(newValue)) {
            return this;
        }
        return new ImmutableAssignReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, this.ref, newValue, this.refTimestampOrHash);
    }

    public final ImmutableAssignReferenceCommandSpec withRefTimestampOrHash(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableAssignReferenceCommandSpec(this, this.inCatalog, this.sourceNode, this.refType, this.ref, this.to, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAssignReferenceCommandSpec && this.equalTo(0, (ImmutableAssignReferenceCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableAssignReferenceCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.refType.equals(another.refType) && this.ref.equals(another.ref) && this.to.equals(another.to) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.refType.hashCode();
        h += (h << 5) + this.ref.hashCode();
        h += (h << 5) + this.to.hashCode();
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AssignReferenceCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("refType", (Object)this.refType).add("ref", (Object)this.ref).add("to", (Object)this.to).add("refTimestampOrHash", (Object)this.refTimestampOrHash).toString();
    }

    public static ImmutableAssignReferenceCommandSpec of(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String refType, String ref, String to, @jakarta.annotation.Nullable String refTimestampOrHash) {
        return new ImmutableAssignReferenceCommandSpec(inCatalog, sourceNode, refType, ref, to, refTimestampOrHash);
    }

    public static ImmutableAssignReferenceCommandSpec copyOf(AssignReferenceCommandSpec instance) {
        if (instance instanceof ImmutableAssignReferenceCommandSpec) {
            return (ImmutableAssignReferenceCommandSpec)instance;
        }
        return ImmutableAssignReferenceCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AssignReferenceCommandSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REF_TYPE = 1L;
        private static final long INIT_BIT_REF = 2L;
        private static final long INIT_BIT_TO = 4L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String inCatalog;
        @Nullable
        private Node sourceNode;
        @Nullable
        private String refType;
        @Nullable
        private String ref;
        @Nullable
        private String to;
        @Nullable
        private String refTimestampOrHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithTypeCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AssignReferenceCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String refTimestampOrHashValue;
            String inCatalogValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 0x10L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof RefWithTypeCommandSpec) {
                instance = (RefWithTypeCommandSpec)object;
                if ((bits & 8L) == 0L) {
                    this.refType(instance.getRefType());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AssignReferenceCommandSpec) {
                instance = (AssignReferenceCommandSpec)object;
                if ((bits & 8L) == 0L) {
                    this.refType(instance.getRefType());
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                this.to(instance.getTo());
                if ((bits & 0x10L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    this.ref(instance.getRef());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@jakarta.annotation.Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@jakarta.annotation.Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refType(String refType) {
            this.refType = Objects.requireNonNull(refType, "refType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(String ref) {
            this.ref = Objects.requireNonNull(ref, "ref");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder to(String to) {
            this.to = Objects.requireNonNull(to, "to");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@jakarta.annotation.Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        public ImmutableAssignReferenceCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAssignReferenceCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ref");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("to");
            }
            return "Cannot build AssignReferenceCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

