/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.MergeBranchCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithTypeCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeBranchCommandSpec", generator="Immutables")
@Immutable
public final class ImmutableMergeBranchCommandSpec
implements MergeBranchCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    private final boolean isDryRun;
    @Nullable
    private final String refType;
    @Nullable
    private final String ref;
    @Nullable
    private final String refTimestampOrHash;
    @Nullable
    private final String into;
    @Nullable
    private final String defaultMergeBehavior;
    private final ImmutableMap<String, String> keyMergeBehaviors;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMergeBranchCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, @Nullable String refType, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable String into, @Nullable String defaultMergeBehavior, Map<String, ? extends String> keyMergeBehaviors) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.isDryRun = isDryRun;
        this.refType = refType;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.into = into;
        this.defaultMergeBehavior = defaultMergeBehavior;
        this.keyMergeBehaviors = ImmutableMap.copyOf(keyMergeBehaviors);
        this.initShim = null;
    }

    private ImmutableMergeBranchCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.refType = builder.refType;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.into = builder.into;
        this.defaultMergeBehavior = builder.defaultMergeBehavior;
        this.keyMergeBehaviors = builder.keyMergeBehaviors.build();
        if (builder.sourceNodeIsSet()) {
            this.initShim.sourceNode(builder.sourceNode);
        }
        if (builder.isDryRunIsSet()) {
            this.initShim.isDryRun(builder.isDryRun);
        }
        this.sourceNode = this.initShim.sourceNode();
        this.isDryRun = this.initShim.isDryRun();
        this.initShim = null;
    }

    private ImmutableMergeBranchCommandSpec(ImmutableMergeBranchCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, @Nullable String refType, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable String into, @Nullable String defaultMergeBehavior, ImmutableMap<String, String> keyMergeBehaviors) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.isDryRun = isDryRun;
        this.refType = refType;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.into = into;
        this.defaultMergeBehavior = defaultMergeBehavior;
        this.keyMergeBehaviors = keyMergeBehaviors;
        this.initShim = null;
    }

    @Nullable
    private Node sourceNodeInitialize() {
        return MergeBranchCommandSpec.super.sourceNode();
    }

    private boolean isDryRunInitialize() {
        return MergeBranchCommandSpec.super.isDryRun();
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNode() : this.sourceNode;
    }

    @Override
    public boolean isDryRun() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDryRun() : this.isDryRun;
    }

    @Override
    @Nullable
    public String getRefType() {
        return this.refType;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    @Override
    @Nullable
    public String getInto() {
        return this.into;
    }

    @Override
    @Nullable
    public String getDefaultMergeBehavior() {
        return this.defaultMergeBehavior;
    }

    public ImmutableMap<String, String> getKeyMergeBehaviors() {
        return this.keyMergeBehaviors;
    }

    public final ImmutableMergeBranchCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, value, this.sourceNode, this.isDryRun, this.refType, this.ref, this.refTimestampOrHash, this.into, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, value, this.isDryRun, this.refType, this.ref, this.refTimestampOrHash, this.into, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withIsDryRun(boolean value) {
        if (this.isDryRun == value) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, value, this.refType, this.ref, this.refTimestampOrHash, this.into, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withRefType(@Nullable String value) {
        if (Objects.equals(this.refType, value)) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, value, this.ref, this.refTimestampOrHash, this.into, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.refType, value, this.refTimestampOrHash, this.into, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.refType, this.ref, value, this.into, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withInto(@Nullable String value) {
        if (Objects.equals(this.into, value)) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.refType, this.ref, this.refTimestampOrHash, value, this.defaultMergeBehavior, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withDefaultMergeBehavior(@Nullable String value) {
        if (Objects.equals(this.defaultMergeBehavior, value)) {
            return this;
        }
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.refType, this.ref, this.refTimestampOrHash, this.into, value, this.keyMergeBehaviors);
    }

    public final ImmutableMergeBranchCommandSpec withKeyMergeBehaviors(Map<String, ? extends String> entries) {
        if (this.keyMergeBehaviors == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMergeBranchCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.refType, this.ref, this.refTimestampOrHash, this.into, this.defaultMergeBehavior, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeBranchCommandSpec && this.equalTo(0, (ImmutableMergeBranchCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeBranchCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.isDryRun == another.isDryRun && Objects.equals(this.refType, another.refType) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash) && Objects.equals(this.into, another.into) && Objects.equals(this.defaultMergeBehavior, another.defaultMergeBehavior) && this.keyMergeBehaviors.equals(another.keyMergeBehaviors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + Booleans.hashCode((boolean)this.isDryRun);
        h += (h << 5) + Objects.hashCode(this.refType);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        h += (h << 5) + Objects.hashCode(this.into);
        h += (h << 5) + Objects.hashCode(this.defaultMergeBehavior);
        h += (h << 5) + this.keyMergeBehaviors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MergeBranchCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("isDryRun", this.isDryRun).add("refType", (Object)this.refType).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).add("into", (Object)this.into).add("defaultMergeBehavior", (Object)this.defaultMergeBehavior).add("keyMergeBehaviors", this.keyMergeBehaviors).toString();
    }

    public static ImmutableMergeBranchCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, @Nullable String refType, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable String into, @Nullable String defaultMergeBehavior, Map<String, ? extends String> keyMergeBehaviors) {
        return new ImmutableMergeBranchCommandSpec(inCatalog, sourceNode, isDryRun, refType, ref, refTimestampOrHash, into, defaultMergeBehavior, keyMergeBehaviors);
    }

    public static ImmutableMergeBranchCommandSpec copyOf(MergeBranchCommandSpec instance) {
        if (instance instanceof ImmutableMergeBranchCommandSpec) {
            return (ImmutableMergeBranchCommandSpec)instance;
        }
        return ImmutableMergeBranchCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeBranchCommandSpec", generator="Immutables")
    private final class InitShim {
        private byte sourceNodeBuildStage = 0;
        private Node sourceNode;
        private byte isDryRunBuildStage = 0;
        private boolean isDryRun;

        private InitShim() {
        }

        Node sourceNode() {
            if (this.sourceNodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodeBuildStage == 0) {
                this.sourceNodeBuildStage = (byte)-1;
                this.sourceNode = ImmutableMergeBranchCommandSpec.this.sourceNodeInitialize();
                this.sourceNodeBuildStage = 1;
            }
            return this.sourceNode;
        }

        void sourceNode(Node sourceNode) {
            this.sourceNode = sourceNode;
            this.sourceNodeBuildStage = 1;
        }

        boolean isDryRun() {
            if (this.isDryRunBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDryRunBuildStage == 0) {
                this.isDryRunBuildStage = (byte)-1;
                this.isDryRun = ImmutableMergeBranchCommandSpec.this.isDryRunInitialize();
                this.isDryRunBuildStage = 1;
            }
            return this.isDryRun;
        }

        void isDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            this.isDryRunBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sourceNodeBuildStage == -1) {
                attributes.add("sourceNode");
            }
            if (this.isDryRunBuildStage == -1) {
                attributes.add("isDryRun");
            }
            return "Cannot build MergeBranchCommandSpec, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MergeBranchCommandSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private static final long OPT_BIT_IS_DRY_RUN = 2L;
        private long optBits;
        @javax.annotation.Nullable
        private String inCatalog;
        @javax.annotation.Nullable
        private Node sourceNode;
        private boolean isDryRun;
        @javax.annotation.Nullable
        private String refType;
        @javax.annotation.Nullable
        private String ref;
        @javax.annotation.Nullable
        private String refTimestampOrHash;
        @javax.annotation.Nullable
        private String into;
        @javax.annotation.Nullable
        private String defaultMergeBehavior;
        private ImmutableMap.Builder<String, String> keyMergeBehaviors = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithTypeCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeBranchCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 0x10L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof RefWithTypeCommandSpec) {
                instance = (RefWithTypeCommandSpec)object;
                if ((bits & 8L) == 0L) {
                    String refTypeValue = instance.getRefType();
                    if (refTypeValue != null) {
                        this.refType(refTypeValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof MergeBranchCommandSpec) {
                instance = (MergeBranchCommandSpec)object;
                String intoValue = instance.getInto();
                if (intoValue != null) {
                    this.into(intoValue);
                }
                if ((bits & 1L) == 0L) {
                    String refValue2 = instance.getRef();
                    if (refValue2 != null) {
                        this.ref(refValue2);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Node sourceNodeValue2 = instance.sourceNode();
                    if (sourceNodeValue2 != null) {
                        this.sourceNode(sourceNodeValue2);
                    }
                    bits |= 2L;
                }
                this.putAllKeyMergeBehaviors(instance.getKeyMergeBehaviors());
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    String refTypeValue = instance.getRefType();
                    if (refTypeValue != null) {
                        this.refType(refTypeValue);
                    }
                    bits |= 8L;
                }
                this.isDryRun(instance.isDryRun());
                String defaultMergeBehaviorValue = instance.getDefaultMergeBehavior();
                if (defaultMergeBehaviorValue != null) {
                    this.defaultMergeBehavior(defaultMergeBehaviorValue);
                }
                if ((bits & 0x10L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 0x10L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refType(@Nullable String refType) {
            this.refType = refType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder into(@Nullable String into) {
            this.into = into;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultMergeBehavior(@Nullable String defaultMergeBehavior) {
            this.defaultMergeBehavior = defaultMergeBehavior;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKeyMergeBehavior(String key, String value) {
            this.keyMergeBehaviors.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putKeyMergeBehavior(Map.Entry<String, ? extends String> entry) {
            this.keyMergeBehaviors.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyMergeBehaviors(Map<String, ? extends String> entries) {
            this.keyMergeBehaviors = ImmutableMap.builder();
            return this.putAllKeyMergeBehaviors(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllKeyMergeBehaviors(Map<String, ? extends String> entries) {
            this.keyMergeBehaviors.putAll(entries);
            return this;
        }

        public ImmutableMergeBranchCommandSpec build() {
            return new ImmutableMergeBranchCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isDryRunIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

