/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ShowContentCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ShowContentCommandSpec", generator="Immutables")
@Immutable
public final class ImmutableShowContentCommandSpec
implements ShowContentCommandSpec {
    @jakarta.annotation.Nullable
    private final String inCatalog;
    @jakarta.annotation.Nullable
    private final Node sourceNode;
    private final String contentKind;
    @jakarta.annotation.Nullable
    private final String ref;
    @jakarta.annotation.Nullable
    private final String refTimestampOrHash;
    @jakarta.annotation.Nullable
    private final String contentKey;

    private ImmutableShowContentCommandSpec(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String contentKind, @jakarta.annotation.Nullable String ref, @jakarta.annotation.Nullable String refTimestampOrHash, @jakarta.annotation.Nullable String contentKey) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.contentKind = Objects.requireNonNull(contentKind, "contentKind");
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.contentKey = contentKey;
    }

    private ImmutableShowContentCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.contentKind = builder.contentKind;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.contentKey = builder.contentKey;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : ShowContentCommandSpec.super.sourceNode();
    }

    private ImmutableShowContentCommandSpec(ImmutableShowContentCommandSpec original, @jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String contentKind, @jakarta.annotation.Nullable String ref, @jakarta.annotation.Nullable String refTimestampOrHash, @jakarta.annotation.Nullable String contentKey) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.contentKind = contentKind;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.contentKey = contentKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @jakarta.annotation.Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getContentKind() {
        return this.contentKind;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getContentKey() {
        return this.contentKey;
    }

    public final ImmutableShowContentCommandSpec withInCatalog(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, value, this.sourceNode, this.contentKind, this.ref, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withSourceNode(@jakarta.annotation.Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, value, this.contentKind, this.ref, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withContentKind(String value) {
        String newValue = Objects.requireNonNull(value, "contentKind");
        if (this.contentKind.equals(newValue)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.ref, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withRef(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, value, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withRefTimestampOrHash(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, this.ref, value, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withContentKey(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.contentKey, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, this.ref, this.refTimestampOrHash, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShowContentCommandSpec && this.equalTo(0, (ImmutableShowContentCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableShowContentCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.contentKind.equals(another.contentKind) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash) && Objects.equals(this.contentKey, another.contentKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.contentKind.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        h += (h << 5) + Objects.hashCode(this.contentKey);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ShowContentCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("contentKind", (Object)this.contentKind).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).add("contentKey", (Object)this.contentKey).toString();
    }

    public static ImmutableShowContentCommandSpec of(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String contentKind, @jakarta.annotation.Nullable String ref, @jakarta.annotation.Nullable String refTimestampOrHash, @jakarta.annotation.Nullable String contentKey) {
        return new ImmutableShowContentCommandSpec(inCatalog, sourceNode, contentKind, ref, refTimestampOrHash, contentKey);
    }

    public static ImmutableShowContentCommandSpec copyOf(ShowContentCommandSpec instance) {
        if (instance instanceof ImmutableShowContentCommandSpec) {
            return (ImmutableShowContentCommandSpec)instance;
        }
        return ImmutableShowContentCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShowContentCommandSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_KIND = 1L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String inCatalog;
        @Nullable
        private Node sourceNode;
        @Nullable
        private String contentKind;
        @Nullable
        private String ref;
        @Nullable
        private String refTimestampOrHash;
        @Nullable
        private String contentKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShowContentCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof ShowContentCommandSpec) {
                String contentKeyValue;
                instance = (ShowContentCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((contentKeyValue = instance.getContentKey()) != null) {
                    this.contentKey(contentKeyValue);
                }
                if ((bits & 2L) == 0L) {
                    Node sourceNodeValue2 = instance.sourceNode();
                    if (sourceNodeValue2 != null) {
                        this.sourceNode(sourceNodeValue2);
                    }
                    bits |= 2L;
                }
                this.contentKind(instance.getContentKind());
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@jakarta.annotation.Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@jakarta.annotation.Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKind(String contentKind) {
            this.contentKind = Objects.requireNonNull(contentKind, "contentKind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@jakarta.annotation.Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@jakarta.annotation.Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKey(@jakarta.annotation.Nullable String contentKey) {
            this.contentKey = contentKey;
            return this;
        }

        public ImmutableShowContentCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableShowContentCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentKind");
            }
            return "Cannot build ShowContentCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

