/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.Tokens;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tokens", generator="Immutables")
@Immutable
final class ImmutableTokens
implements Tokens {
    private final AccessToken accessToken;
    @Nullable
    private final RefreshToken refreshToken;

    private ImmutableTokens(AccessToken accessToken, @Nullable RefreshToken refreshToken) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    @Override
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Override
    @Nullable
    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public final ImmutableTokens withAccessToken(AccessToken value) {
        if (this.accessToken == value) {
            return this;
        }
        AccessToken newValue = Objects.requireNonNull(value, "accessToken");
        return new ImmutableTokens(newValue, this.refreshToken);
    }

    public final ImmutableTokens withRefreshToken(@Nullable RefreshToken value) {
        if (this.refreshToken == value) {
            return this;
        }
        return new ImmutableTokens(this.accessToken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokens && this.equalTo(0, (ImmutableTokens)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokens another) {
        return this.accessToken.equals(another.accessToken) && Objects.equals(this.refreshToken, another.refreshToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessToken.hashCode();
        h += (h << 5) + Objects.hashCode(this.refreshToken);
        return h;
    }

    public String toString() {
        return "Tokens{accessToken=" + String.valueOf(this.accessToken) + ", refreshToken=" + String.valueOf(this.refreshToken) + "}";
    }

    public static ImmutableTokens copyOf(Tokens instance) {
        if (instance instanceof ImmutableTokens) {
            return (ImmutableTokens)instance;
        }
        return ImmutableTokens.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Tokens", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESS_TOKEN = 1L;
        private long initBits = 1L;
        @Nullable
        private AccessToken accessToken;
        @Nullable
        private RefreshToken refreshToken;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Tokens instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessToken(instance.getAccessToken());
            RefreshToken refreshTokenValue = instance.getRefreshToken();
            if (refreshTokenValue != null) {
                this.refreshToken(refreshTokenValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessToken(AccessToken accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refreshToken(@Nullable RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public ImmutableTokens build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokens(this.accessToken, this.refreshToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessToken");
            }
            return "Cannot build Tokens, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

