/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.spark.source.HasIcebergCatalog;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.execution.datasources.v2.CatalogBridge;
import org.apache.spark.sql.execution.datasources.v2.NessieCatalogBridge;
import org.apache.spark.sql.execution.datasources.v2.RestCatalogBridge;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.config.NessieClientConfigSource;

public final class CatalogUtils {
    private CatalogUtils() {
    }

    public static CatalogBridge buildBridge(CatalogPlugin currentCatalog, String catalog) {
        SparkSession sparkSession = SparkSession.active();
        SparkContext sparkContext = sparkSession.sparkContext();
        if (!(currentCatalog instanceof HasIcebergCatalog)) {
            currentCatalog = sparkSession.sessionState().catalogManager().catalog(catalog);
        }
        if (!(currentCatalog instanceof HasIcebergCatalog)) {
            throw new IllegalArgumentException("The command works only when the catalog is a NessieCatalog or a RESTCatalog using the Nessie Catalog Server, but " + catalog + " does not expose an Iceberg catalog. Either set the catalog via USE <catalog_name> or provide the catalog during execution: <command> IN <catalog_name>.");
        }
        Catalog icebergCatalog = ((HasIcebergCatalog)currentCatalog).icebergCatalog();
        icebergCatalog = CatalogUtils.unwrapCachingCatalog(icebergCatalog);
        switch (icebergCatalog.getClass().getSimpleName()) {
            case "NessieCatalog": {
                return new NessieCatalogBridge(sparkContext, currentCatalog, catalog);
            }
            case "RESTCatalog": {
                return new RestCatalogBridge(sparkContext, currentCatalog, catalog, icebergCatalog);
            }
        }
        throw new IllegalArgumentException("The command works only when the catalog is a NessieCatalog or a RESTCatalog using the Nessie Catalog Server, but " + catalog + " is a " + icebergCatalog.getClass().getName() + ". Either set the catalog via USE <catalog_name> or provide the catalog during execution: <command> IN <catalog_name>.");
    }

    static NessieApiV1 buildApi(NessieClientConfigSource nessieClientConfigMapper) {
        NessieClientBuilder nessieClientBuilder = NessieClientBuilder.createClientBuilderFromSystemSettings(nessieClientConfigMapper);
        String clientApiVer = nessieClientConfigMapper.getValue("nessie.client-api-version");
        if (clientApiVer == null) {
            clientApiVer = "1";
        }
        switch (clientApiVer) {
            case "1": {
                return nessieClientBuilder.build(NessieApiV1.class);
            }
            case "2": {
                return nessieClientBuilder.build(NessieApiV2.class);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported client-api-version value: %s. Can only be 1 or 2", clientApiVer));
    }

    static String refFromRestPrefix(String prefix) {
        int idx = (prefix = CatalogUtils.decodePrefix(prefix)).indexOf("|");
        return idx == -1 ? prefix : prefix.substring(0, idx);
    }

    static Optional<String> warehouseFromRestPrefix(String prefix) {
        int idx = (prefix = CatalogUtils.decodePrefix(prefix)).indexOf("|");
        return idx == -1 ? Optional.empty() : Optional.of(prefix.substring(idx + 1));
    }

    static ParsedReference referenceFromRestPrefix(String prefix) {
        String ref = CatalogUtils.refFromRestPrefix(prefix = CatalogUtils.decodePrefix(prefix));
        int i = ref.indexOf("@");
        return i == -1 ? ParsedReference.parsedReference(ref, null, null) : ParsedReference.parsedReference(ref.substring(0, i), ref.substring(i + 1), null);
    }

    private static String decodePrefix(String prefix) {
        try {
            prefix = URLDecoder.decode(prefix, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return prefix;
    }

    static Map<String, String> propertiesFromCatalog(Catalog icebergCatalog) {
        try {
            Method catalogProperties = icebergCatalog.getClass().getDeclaredMethod("properties", new Class[0]);
            catalogProperties.setAccessible(true);
            Object props = catalogProperties.invoke((Object)icebergCatalog, new Object[0]);
            Map properties = (Map)props;
            return properties;
        }
        catch (Exception e) {
            throw new IllegalStateException("Iceberg catalog implementation " + icebergCatalog.getClass().getName() + " does not expose its properties");
        }
    }

    static Catalog unwrapCachingCatalog(Catalog icebergCatalog) {
        try {
            if (icebergCatalog instanceof CachingCatalog) {
                Field cachingCatalogCatalog = icebergCatalog.getClass().getDeclaredField("catalog");
                cachingCatalogCatalog.setAccessible(true);
                icebergCatalog = (Catalog)cachingCatalogCatalog.get(icebergCatalog);
            }
            return icebergCatalog;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String resolveViaEnvironment(Map<String, String> properties, String property, String defaultValue) {
        String value = properties.get(property);
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith("env:")) {
            String env = System.getenv(value.substring("env:".length()));
            if (env == null) {
                return defaultValue;
            }
            return env;
        }
        return value;
    }

    static String resolveOAuthScope(Map<String, String> catalogProperties) {
        String nessieScope = CatalogUtils.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-scopes", null);
        if (nessieScope != null) {
            return nessieScope;
        }
        return CatalogUtils.resolveViaEnvironment(catalogProperties, "scope", "catalog");
    }

    static Credential resolveCredential(Map<String, String> catalogProperties) {
        String nessieClientId = CatalogUtils.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-id", null);
        String nessieClientSecret = CatalogUtils.resolveViaEnvironment(catalogProperties, "nessie.authentication.oauth2.client-secret", null);
        Credential credentialFromIceberg = CatalogUtils.parseIcebergCredential(CatalogUtils.resolveViaEnvironment(catalogProperties, "credential", null));
        return new Credential(nessieClientId != null ? nessieClientId : credentialFromIceberg.clientId, nessieClientSecret != null ? nessieClientSecret : credentialFromIceberg.secret);
    }

    static Credential parseIcebergCredential(String credential) {
        if (credential == null) {
            return new Credential(null, null);
        }
        int colon = credential.indexOf(58);
        if (colon == -1) {
            return new Credential(null, credential);
        }
        return new Credential(credential.substring(0, colon), credential.substring(colon + 1));
    }

    static void reinitializeCatalog(Catalog catalog, Map<String, String> properties) {
        if (catalog instanceof AutoCloseable) {
            try {
                ((AutoCloseable)catalog).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String name = catalog.name();
        catalog.initialize(name, properties);
    }

    static final class Credential {
        final String clientId;
        final String secret;

        Credential(String clientId, String secret) {
            this.clientId = clientId;
            this.secret = secret;
        }
    }
}

