/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ShowContentCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="ShowContentCommandSpec", generator="Immutables")
public final class ImmutableShowContentCommandSpec
implements ShowContentCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    private final String contentKind;
    @Nullable
    private final String ref;
    @Nullable
    private final String refTimestampOrHash;
    @Nullable
    private final String contentKey;

    private ImmutableShowContentCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, String contentKind, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable String contentKey) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.contentKind = Objects.requireNonNull(contentKind, "contentKind");
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.contentKey = contentKey;
    }

    private ImmutableShowContentCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.contentKind = builder.contentKind;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.contentKey = builder.contentKey;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : ShowContentCommandSpec.super.sourceNode();
    }

    private ImmutableShowContentCommandSpec(ImmutableShowContentCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, String contentKind, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable String contentKey) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.contentKind = contentKind;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
        this.contentKey = contentKey;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getContentKind() {
        return this.contentKind;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    @Override
    @Nullable
    public String getContentKey() {
        return this.contentKey;
    }

    public final ImmutableShowContentCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, value, this.sourceNode, this.contentKind, this.ref, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, value, this.contentKind, this.ref, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withContentKind(String value) {
        String newValue = Objects.requireNonNull(value, "contentKind");
        if (this.contentKind.equals(newValue)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.ref, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, value, this.refTimestampOrHash, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, this.ref, value, this.contentKey);
    }

    public final ImmutableShowContentCommandSpec withContentKey(@Nullable String value) {
        if (Objects.equals(this.contentKey, value)) {
            return this;
        }
        return new ImmutableShowContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, this.ref, this.refTimestampOrHash, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShowContentCommandSpec && this.equalsByValue((ImmutableShowContentCommandSpec)another);
    }

    private boolean equalsByValue(ImmutableShowContentCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.contentKind.equals(another.contentKind) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash) && Objects.equals(this.contentKey, another.contentKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.contentKind.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        h += (h << 5) + Objects.hashCode(this.contentKey);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ShowContentCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("contentKind", (Object)this.contentKind).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).add("contentKey", (Object)this.contentKey).toString();
    }

    public static ImmutableShowContentCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, String contentKind, @Nullable String ref, @Nullable String refTimestampOrHash, @Nullable String contentKey) {
        return new ImmutableShowContentCommandSpec(inCatalog, sourceNode, contentKind, ref, refTimestampOrHash, contentKey);
    }

    public static ImmutableShowContentCommandSpec copyOf(ShowContentCommandSpec instance) {
        if (instance instanceof ImmutableShowContentCommandSpec) {
            return (ImmutableShowContentCommandSpec)instance;
        }
        return ImmutableShowContentCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShowContentCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_KIND = 1L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 1L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private String contentKind;
        private String ref;
        private String refTimestampOrHash;
        private String contentKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShowContentCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof ShowContentCommandSpec) {
                String contentKeyValue;
                instance = (ShowContentCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((contentKeyValue = instance.getContentKey()) != null) {
                    this.contentKey(contentKeyValue);
                }
                if ((bits & 2L) == 0L) {
                    Node sourceNodeValue2 = instance.sourceNode();
                    if (sourceNodeValue2 != null) {
                        this.sourceNode(sourceNodeValue2);
                    }
                    bits |= 2L;
                }
                this.contentKind(instance.getContentKind());
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKind(String contentKind) {
            this.contentKind = Objects.requireNonNull(contentKind, "contentKind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKey(@Nullable String contentKey) {
            this.contentKey = contentKey;
            return this;
        }

        public ImmutableShowContentCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableShowContentCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentKind");
            }
            return "Cannot build ShowContentCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

