/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.syntax;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.congocc.core.BNFProduction;
import org.congocc.core.Expansion;
import org.congocc.core.Grammar;
import org.congocc.core.LexerData;
import org.congocc.core.NonTerminal;
import org.congocc.core.RegularExpression;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.BaseNode;
import org.congocc.parser.tree.Delimiter;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.Operator;
import org.congocc.parser.tree.RegexpStringLiteral;
import org.congocc.parser.tree.Terminal;
import org.projectnessie.nessie.cli.syntax.SyntaxPrinter;

public class Syntax {
    private final Grammar grammar;
    private final Map<String, String> stringLiterals;
    private final String level;
    private static final int SPLIT_LINE_LENGTH = 60;

    public Syntax(Path grammarFile, Map<String, String> preprocessorSymbols) throws IOException {
        this.grammar = new Grammar(null, "java", 17, false, preprocessorSymbols);
        this.level = "    ";
        this.grammar.parse(grammarFile, true);
        this.grammar.doSanityChecks();
        this.grammar.generateLexer();
        LexerData lexerData = this.grammar.getLexerData();
        this.stringLiterals = new HashMap<String, String>();
        for (RegularExpression orderedNamedToken : lexerData.getOrderedNamedTokens()) {
            RegexpStringLiteral regexpStringLiteral;
            String literalString;
            if (!(orderedNamedToken instanceof RegexpStringLiteral) || (literalString = (regexpStringLiteral = (RegexpStringLiteral)orderedNamedToken).getLiteralString()) == null) continue;
            this.stringLiterals.put(regexpStringLiteral.getLabel(), regexpStringLiteral.getLiteralString());
        }
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void print(BNFProduction production, SyntaxPrinter syntaxPrinter) {
        BNFProduction prod = production;
        for (int i = 0; i < production.size(); ++i) {
            if (!(production.get(i) instanceof Operator) || ((Operator)production.get(i)).getType() != Token.TokenType.COLON) continue;
            prod = new BaseNode();
            ++i;
            while (i < production.size()) {
                prod.add((Object)production.get(i));
                ++i;
            }
            break;
        }
        Coll root = new Coll("", "");
        root.collectFrom((Node)prod);
        root.maybeSplit();
        root.print(syntaxPrinter);
    }

    class Coll
    extends Obj {
        final List<Obj> children = new ArrayList<Obj>();
        final List<String> pre = new ArrayList<String>();
        final List<String> post = new ArrayList<String>();

        Coll(String pre, String post) {
            if (!pre.isEmpty()) {
                this.pre.add(pre);
            }
            if (!post.isEmpty()) {
                this.post.add(post);
            }
        }

        @Override
        void print(SyntaxPrinter syntaxPrinter) {
            boolean needSpace = false;
            for (String s : this.pre) {
                if (needSpace) {
                    syntaxPrinter.space();
                }
                syntaxPrinter.write(SyntaxPrinter.Type.PRE, s);
                needSpace = true;
            }
            for (Obj obj : this.children) {
                if (needSpace) {
                    syntaxPrinter.space();
                }
                obj.print(syntaxPrinter);
                needSpace = true;
            }
            for (int i = this.post.size() - 1; i >= 0; --i) {
                syntaxPrinter.space();
                syntaxPrinter.write(SyntaxPrinter.Type.POST, this.post.get(i));
            }
        }

        @Override
        int length() {
            int l = 0;
            boolean needSpace = false;
            for (String s : this.pre) {
                if (needSpace) {
                    ++l;
                }
                l += s.length();
                needSpace = true;
            }
            for (Obj obj : this.children) {
                if (needSpace) {
                    ++l;
                }
                l += obj.length();
                needSpace = true;
            }
            for (int i = this.post.size() - 1; i >= 0; --i) {
                ++l;
                l += this.post.get(i).length();
            }
            return l;
        }

        void maybeSplit() {
            int len = this.length();
            if (len < 60) {
                return;
            }
            ArrayList<Obj> prev = new ArrayList<Obj>(this.children);
            this.children.clear();
            boolean hadNewline = false;
            Coll line = null;
            for (Obj obj : prev) {
                if (obj instanceof Coll) {
                    if (line != null) {
                        this.children.add(new Newline(line, Syntax.this.level));
                        line = null;
                    }
                    this.children.add(new Newline((Coll)obj, Syntax.this.level));
                    hadNewline = true;
                    continue;
                }
                if (hadNewline) {
                    if (line == null) {
                        line = new Coll("", "");
                    }
                    line.children.add(obj);
                    continue;
                }
                this.children.add(obj);
            }
            if (line != null) {
                this.children.add(new Newline(line, Syntax.this.level));
            }
        }

        void collectFrom(Node prod) {
            Obj ch;
            Coll coll;
            for (Object node : prod.children()) {
                if (node instanceof Terminal) {
                    Terminal terminal = (Terminal)node;
                    String label = terminal.getLabel();
                    this.maybeAdd(SyntaxPrinter.Type.TERMINAL, Syntax.this.stringLiterals.get(label));
                    continue;
                }
                if (node instanceof NonTerminal) {
                    NonTerminal nonTerminal = (NonTerminal)node;
                    this.maybeAdd(SyntaxPrinter.Type.NON_TERMINAL, nonTerminal.getName());
                    continue;
                }
                if (node instanceof Identifier) {
                    Identifier identifier = (Identifier)node;
                    this.maybeAdd(SyntaxPrinter.Type.IDENTIFIER, identifier.toString());
                    continue;
                }
                if (node instanceof Operator) {
                    Operator operator = (Operator)node;
                    String source = operator.getSource();
                    if (!"|".equals(source)) continue;
                    this.children.add(new Element(SyntaxPrinter.Type.SEP, source));
                    continue;
                }
                if (node instanceof Delimiter || !(node instanceof Expansion)) continue;
                Expansion expansion = (Expansion)node;
                coll = null;
                switch (expansion.getSimpleName()) {
                    case "ZeroOrOne": {
                        coll = new Coll("[", "]");
                        break;
                    }
                    case "ZeroOrMore": {
                        coll = new Coll("{", "}");
                        break;
                    }
                    case "ExpansionWithParentheses": {
                        coll = new Coll("(", ")");
                        break;
                    }
                    case "ExpansionSequence": 
                    case "ExpansionChoice": {
                        coll = new Coll("", "");
                        break;
                    }
                }
                if (coll == null) continue;
                coll.collectFrom((Node)node);
                this.children.add(coll);
            }
            ArrayList<Obj> prev = new ArrayList<Obj>(this.children);
            this.children.clear();
            for (Obj ch2 : prev) {
                if (ch2 instanceof Coll) {
                    coll = (Coll)ch2;
                    if (coll.noPrePost()) {
                        this.children.addAll(coll.children);
                        continue;
                    }
                    this.children.add(ch2);
                    continue;
                }
                this.children.add(ch2);
            }
            while (this.children.size() == 1 && (ch = this.children.get(0)) instanceof Coll) {
                Coll coll2 = (Coll)ch;
                if (coll2.children.size() == 1) {
                    this.pre.addAll(coll2.pre);
                    this.post.addAll(coll2.post);
                    this.children.clear();
                    this.children.addAll(coll2.children);
                    continue;
                }
                if (!coll2.noPrePost()) break;
                this.children.clear();
                this.children.addAll(coll2.children);
            }
        }

        private boolean noPrePost() {
            return this.pre.isEmpty() && this.post.isEmpty();
        }

        void maybeAdd(SyntaxPrinter.Type type, String str) {
            if (str == null || str.isEmpty()) {
                return;
            }
            this.children.add(new Element(type, str));
        }

        public String toString() {
            return "Coll{children=" + String.valueOf(this.children) + ", pre=" + String.valueOf(this.pre) + ", post=" + String.valueOf(this.post) + "}";
        }
    }

    static class Element
    extends Obj {
        final SyntaxPrinter.Type type;
        final String text;

        public Element(SyntaxPrinter.Type type, String text) {
            this.type = type;
            this.text = text;
        }

        @Override
        void print(SyntaxPrinter syntaxPrinter) {
            syntaxPrinter.write(this.type, this.text);
        }

        @Override
        int length() {
            return this.text.length();
        }

        public String toString() {
            return "Element{type=" + String.valueOf((Object)this.type) + ", text='" + this.text + "'}";
        }
    }

    class Newline
    extends Obj {
        final Coll coll;
        final String indent;

        Newline(Coll coll, String indent) {
            this.coll = coll;
            this.indent = indent;
        }

        @Override
        int length() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void print(SyntaxPrinter syntaxPrinter) {
            void var4_8;
            syntaxPrinter.newline(this.indent);
            boolean needSpace = false;
            for (String string : this.coll.pre) {
                if (needSpace) {
                    syntaxPrinter.space();
                }
                syntaxPrinter.write(SyntaxPrinter.Type.PRE, string);
                needSpace = true;
            }
            boolean didNewline = false;
            for (Obj obj : this.coll.children) {
                if (obj instanceof Element && ((Element)obj).type == SyntaxPrinter.Type.SEP) {
                    didNewline = true;
                    syntaxPrinter.newline(this.indent);
                    needSpace = false;
                }
                if (needSpace) {
                    syntaxPrinter.space();
                }
                obj.print(syntaxPrinter);
                needSpace = true;
            }
            if (didNewline) {
                syntaxPrinter.newline(this.indent);
                needSpace = false;
            }
            int n = this.coll.post.size() - 1;
            while (var4_8 >= 0) {
                if (needSpace) {
                    syntaxPrinter.space();
                }
                syntaxPrinter.write(SyntaxPrinter.Type.POST, this.coll.post.get((int)var4_8));
                needSpace = true;
                --var4_8;
            }
        }

        public String toString() {
            return "Newline{coll=" + String.valueOf(this.coll) + ", indent='" + this.indent + "'}";
        }
    }

    static abstract class Obj {
        Obj() {
        }

        abstract void print(SyntaxPrinter var1);

        abstract int length();
    }
}

