/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk8;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import java.util.function.BiConsumer;
import javax.net.ssl.HttpsURLConnection;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpClientReadTimeoutException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.HttpResponse;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.impl.BaseHttpRequest;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.HttpUtils;
import org.projectnessie.client.http.impl.RequestContextImpl;
import org.projectnessie.client.http.impl.jdk8.UrlConnectionResponseContext;

final class UrlConnectionRequest
extends BaseHttpRequest {
    UrlConnectionRequest(HttpRuntimeConfig config) {
        super(config);
    }

    @Override
    public HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        URI uri = this.uriBuilder.build();
        try {
            HttpURLConnection con = (HttpURLConnection)uri.toURL().openConnection();
            con.setReadTimeout(this.config.getReadTimeoutMillis());
            con.setConnectTimeout(this.config.getConnectionTimeoutMillis());
            if (con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.config.getSslContext().getSocketFactory());
            }
            RequestContextImpl context = new RequestContextImpl(this.headers, uri, method, body);
            UrlConnectionResponseContext responseContext = new UrlConnectionResponseContext(con, uri);
            try {
                boolean doesOutput = this.prepareRequest(context);
                HttpUtils.applyHeaders(this.headers, con);
                con.setRequestMethod(method.name());
                if (doesOutput) {
                    con.setDoOutput(true);
                    this.writeToOutputStream(context, con.getOutputStream());
                }
                con.connect();
                con.getResponseCode();
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(responseContext, null));
                }
            }
            catch (IOException e) {
                List<BiConsumer<ResponseContext, Exception>> callbacks = context.getResponseCallbacks();
                if (callbacks != null) {
                    callbacks.forEach(callback -> callback.accept(null, e));
                }
                throw e;
            }
            this.config.getResponseFilters().forEach(responseFilter -> responseFilter.filter(responseContext));
            return this.config.responseFactory().make(responseContext, this.config.getMapper());
        }
        catch (ProtocolException e) {
            throw new HttpClientException(String.format("Cannot perform request against '%s'. Invalid protocol %s", new Object[]{uri, method}), e);
        }
        catch (MalformedURLException e) {
            throw new HttpClientException(String.format("Cannot perform %s request. Malformed Url for %s", new Object[]{method, uri}), e);
        }
        catch (SocketTimeoutException e) {
            throw new HttpClientReadTimeoutException(String.format("Cannot finish %s request against '%s'. Timeout while waiting for response with a timeout of %ds", new Object[]{method, uri, this.config.getReadTimeoutMillis() / 1000}), e);
        }
        catch (IOException e) {
            throw new HttpClientException(String.format("Failed to execute %s request against '%s'.", new Object[]{method, uri}), e);
        }
    }

    @Override
    public HttpResponse get() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.GET, null);
    }

    @Override
    public HttpResponse delete() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.DELETE, null);
    }

    @Override
    public HttpResponse post(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.POST, obj);
    }

    @Override
    public HttpResponse put(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.PUT, obj);
    }

    @Override
    public HttpRequest resolveTemplate(String name, String value) {
        this.uriBuilder.resolveTemplate(name, value);
        return this;
    }
}

