/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.immutables.value.Value;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.http.impl.ImmutableHttpRuntimeConfig;

@Value.Immutable
public interface HttpRuntimeConfig
extends AutoCloseable {
    public static ImmutableHttpRuntimeConfig.Builder builder() {
        return ImmutableHttpRuntimeConfig.builder();
    }

    @Value.Check
    default public void check() {
        URI baseUri = this.getBaseUri();
        if (!"http".equals(baseUri.getScheme()) && !"https".equals(baseUri.getScheme())) {
            throw new IllegalArgumentException(String.format("Cannot start http client. %s must be a valid http or https address", baseUri));
        }
    }

    public URI getBaseUri();

    public ObjectMapper getMapper();

    @Nullable
    public Class<?> getJsonView();

    public HttpResponseFactory responseFactory();

    public int getReadTimeoutMillis();

    public int getConnectionTimeoutMillis();

    public boolean isDisableCompression();

    public SSLContext getSslContext();

    @Nullable
    public HttpAuthentication getAuthentication();

    public List<RequestFilter> getRequestFilters();

    public List<ResponseFilter> getResponseFilters();

    @Nullable
    public String getFollowRedirects();

    @Nullable
    public SSLParameters getSslParameters();

    @Value.Default
    default public boolean isHttp11Only() {
        return true;
    }

    @Value.Default
    default public boolean forceUrlConnectionClient() {
        return false;
    }

    @Value.Default
    default public int getClientSpec() {
        return 2;
    }

    @Override
    default public void close() {
        HttpAuthentication authentication = this.getAuthentication();
        if (authentication != null) {
            authentication.close();
        }
    }
}

