/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.immutables.value.Generated;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpResponseFactory;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpRuntimeConfig", generator="Immutables")
@Immutable
public final class ImmutableHttpRuntimeConfig
implements HttpRuntimeConfig {
    private final URI baseUri;
    private final ObjectMapper mapper;
    @Nullable
    private final Class<?> jsonView;
    private final HttpResponseFactory responseFactory;
    private final int readTimeoutMillis;
    private final int connectionTimeoutMillis;
    private final boolean isDisableCompression;
    private final SSLContext sslContext;
    @javax.annotation.Nullable
    private final HttpAuthentication authentication;
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    @Nullable
    private final String followRedirects;
    @Nullable
    private final SSLParameters sslParameters;
    private final boolean isHttp11Only;
    private final boolean forceUrlConnectionClient;
    private final int clientSpec;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableHttpRuntimeConfig(Builder builder) {
        this.baseUri = builder.baseUri;
        this.mapper = builder.mapper;
        this.jsonView = builder.jsonView;
        this.responseFactory = builder.responseFactory;
        this.readTimeoutMillis = builder.readTimeoutMillis;
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.isDisableCompression = builder.isDisableCompression;
        this.sslContext = builder.sslContext;
        this.authentication = builder.authentication;
        this.requestFilters = ImmutableHttpRuntimeConfig.createUnmodifiableList(true, builder.requestFilters);
        this.responseFilters = ImmutableHttpRuntimeConfig.createUnmodifiableList(true, builder.responseFilters);
        this.followRedirects = builder.followRedirects;
        this.sslParameters = builder.sslParameters;
        if (builder.isHttp11OnlyIsSet()) {
            this.initShim.isHttp11Only(builder.isHttp11Only);
        }
        if (builder.forceUrlConnectionClientIsSet()) {
            this.initShim.forceUrlConnectionClient(builder.forceUrlConnectionClient);
        }
        if (builder.clientSpecIsSet()) {
            this.initShim.clientSpec(builder.clientSpec);
        }
        this.isHttp11Only = this.initShim.isHttp11Only();
        this.forceUrlConnectionClient = this.initShim.forceUrlConnectionClient();
        this.clientSpec = this.initShim.getClientSpec();
        this.initShim = null;
    }

    private ImmutableHttpRuntimeConfig(URI baseUri, ObjectMapper mapper, @Nullable Class<?> jsonView, HttpResponseFactory responseFactory, int readTimeoutMillis, int connectionTimeoutMillis, boolean isDisableCompression, SSLContext sslContext, @javax.annotation.Nullable HttpAuthentication authentication, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, @Nullable String followRedirects, @Nullable SSLParameters sslParameters, boolean isHttp11Only, boolean forceUrlConnectionClient, int clientSpec) {
        this.baseUri = baseUri;
        this.mapper = mapper;
        this.jsonView = jsonView;
        this.responseFactory = responseFactory;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.isDisableCompression = isDisableCompression;
        this.sslContext = sslContext;
        this.authentication = authentication;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.followRedirects = followRedirects;
        this.sslParameters = sslParameters;
        this.isHttp11Only = isHttp11Only;
        this.forceUrlConnectionClient = forceUrlConnectionClient;
        this.clientSpec = clientSpec;
        this.initShim = null;
    }

    private boolean isHttp11OnlyInitialize() {
        return HttpRuntimeConfig.super.isHttp11Only();
    }

    private boolean forceUrlConnectionClientInitialize() {
        return HttpRuntimeConfig.super.forceUrlConnectionClient();
    }

    private int getClientSpecInitialize() {
        return HttpRuntimeConfig.super.getClientSpec();
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    @Nullable
    public Class<?> getJsonView() {
        return this.jsonView;
    }

    @Override
    public HttpResponseFactory responseFactory() {
        return this.responseFactory;
    }

    @Override
    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public boolean isDisableCompression() {
        return this.isDisableCompression;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    @javax.annotation.Nullable
    public HttpAuthentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    public List<ResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    @Override
    @Nullable
    public String getFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    @Nullable
    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    @Override
    public boolean isHttp11Only() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isHttp11Only() : this.isHttp11Only;
    }

    @Override
    public boolean forceUrlConnectionClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forceUrlConnectionClient() : this.forceUrlConnectionClient;
    }

    @Override
    public int getClientSpec() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClientSpec() : this.clientSpec;
    }

    public final ImmutableHttpRuntimeConfig withBaseUri(URI value) {
        if (this.baseUri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "baseUri");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(newValue, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withMapper(ObjectMapper value) {
        if (this.mapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "mapper");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, newValue, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withJsonView(@Nullable Class<?> value) {
        if (this.jsonView == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, value, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withResponseFactory(HttpResponseFactory value) {
        if (this.responseFactory == value) {
            return this;
        }
        HttpResponseFactory newValue = Objects.requireNonNull(value, "responseFactory");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, newValue, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withReadTimeoutMillis(int value) {
        if (this.readTimeoutMillis == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, value, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withConnectionTimeoutMillis(int value) {
        if (this.connectionTimeoutMillis == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, value, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withIsDisableCompression(boolean value) {
        if (this.isDisableCompression == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, value, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withSslContext(SSLContext value) {
        if (this.sslContext == value) {
            return this;
        }
        SSLContext newValue = Objects.requireNonNull(value, "sslContext");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, newValue, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withAuthentication(@javax.annotation.Nullable HttpAuthentication value) {
        if (this.authentication == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, value, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withRequestFilters(RequestFilter ... elements) {
        List<RequestFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, newValue, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withRequestFilters(Iterable<? extends RequestFilter> elements) {
        if (this.requestFilters == elements) {
            return this;
        }
        List<RequestFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(elements, true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, newValue, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withResponseFilters(ResponseFilter ... elements) {
        List<ResponseFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, newValue, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withResponseFilters(Iterable<? extends ResponseFilter> elements) {
        if (this.responseFilters == elements) {
            return this;
        }
        List<ResponseFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(elements, true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, newValue, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withFollowRedirects(@Nullable String value) {
        if (Objects.equals(this.followRedirects, value)) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, value, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withSslParameters(@Nullable SSLParameters value) {
        if (this.sslParameters == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, value, this.isHttp11Only, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withIsHttp11Only(boolean value) {
        if (this.isHttp11Only == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, value, this.forceUrlConnectionClient, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withForceUrlConnectionClient(boolean value) {
        if (this.forceUrlConnectionClient == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, value, this.clientSpec));
    }

    public final ImmutableHttpRuntimeConfig withClientSpec(int value) {
        if (this.clientSpec == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.jsonView, this.responseFactory, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.authentication, this.requestFilters, this.responseFilters, this.followRedirects, this.sslParameters, this.isHttp11Only, this.forceUrlConnectionClient, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpRuntimeConfig && this.equalTo(0, (ImmutableHttpRuntimeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableHttpRuntimeConfig another) {
        return this.baseUri.equals(another.baseUri) && this.mapper.equals(another.mapper) && Objects.equals(this.jsonView, another.jsonView) && this.responseFactory.equals(another.responseFactory) && this.readTimeoutMillis == another.readTimeoutMillis && this.connectionTimeoutMillis == another.connectionTimeoutMillis && this.isDisableCompression == another.isDisableCompression && this.sslContext.equals(another.sslContext) && Objects.equals(this.authentication, another.authentication) && this.requestFilters.equals(another.requestFilters) && this.responseFilters.equals(another.responseFilters) && Objects.equals(this.followRedirects, another.followRedirects) && Objects.equals(this.sslParameters, another.sslParameters) && this.isHttp11Only == another.isHttp11Only && this.forceUrlConnectionClient == another.forceUrlConnectionClient && this.clientSpec == another.clientSpec;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.baseUri.hashCode();
        h += (h << 5) + this.mapper.hashCode();
        h += (h << 5) + Objects.hashCode(this.jsonView);
        h += (h << 5) + this.responseFactory.hashCode();
        h += (h << 5) + this.readTimeoutMillis;
        h += (h << 5) + this.connectionTimeoutMillis;
        h += (h << 5) + Boolean.hashCode(this.isDisableCompression);
        h += (h << 5) + this.sslContext.hashCode();
        h += (h << 5) + Objects.hashCode(this.authentication);
        h += (h << 5) + this.requestFilters.hashCode();
        h += (h << 5) + this.responseFilters.hashCode();
        h += (h << 5) + Objects.hashCode(this.followRedirects);
        h += (h << 5) + Objects.hashCode(this.sslParameters);
        h += (h << 5) + Boolean.hashCode(this.isHttp11Only);
        h += (h << 5) + Boolean.hashCode(this.forceUrlConnectionClient);
        h += (h << 5) + this.clientSpec;
        return h;
    }

    public String toString() {
        return "HttpRuntimeConfig{baseUri=" + this.baseUri + ", mapper=" + this.mapper + ", jsonView=" + this.jsonView + ", responseFactory=" + this.responseFactory + ", readTimeoutMillis=" + this.readTimeoutMillis + ", connectionTimeoutMillis=" + this.connectionTimeoutMillis + ", isDisableCompression=" + this.isDisableCompression + ", sslContext=" + this.sslContext + ", authentication=" + this.authentication + ", requestFilters=" + this.requestFilters + ", responseFilters=" + this.responseFilters + ", followRedirects=" + this.followRedirects + ", sslParameters=" + this.sslParameters + ", isHttp11Only=" + this.isHttp11Only + ", forceUrlConnectionClient=" + this.forceUrlConnectionClient + ", clientSpec=" + this.clientSpec + "}";
    }

    private static ImmutableHttpRuntimeConfig validate(ImmutableHttpRuntimeConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHttpRuntimeConfig copyOf(HttpRuntimeConfig instance) {
        if (instance instanceof ImmutableHttpRuntimeConfig) {
            return (ImmutableHttpRuntimeConfig)instance;
        }
        return ImmutableHttpRuntimeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static /* synthetic */ boolean access$2000(ImmutableHttpRuntimeConfig x0) {
        return x0.isHttp11OnlyInitialize();
    }

    static /* synthetic */ boolean access$2100(ImmutableHttpRuntimeConfig x0) {
        return x0.forceUrlConnectionClientInitialize();
    }

    static /* synthetic */ int access$2200(ImmutableHttpRuntimeConfig x0) {
        return x0.getClientSpecInitialize();
    }

    static /* synthetic */ ImmutableHttpRuntimeConfig access$2500(ImmutableHttpRuntimeConfig x0) {
        return ImmutableHttpRuntimeConfig.validate(x0);
    }

    @Generated(from="HttpRuntimeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BASE_URI = 1L;
        private static final long INIT_BIT_MAPPER = 2L;
        private static final long INIT_BIT_RESPONSE_FACTORY = 4L;
        private static final long INIT_BIT_READ_TIMEOUT_MILLIS = 8L;
        private static final long INIT_BIT_CONNECTION_TIMEOUT_MILLIS = 16L;
        private static final long INIT_BIT_IS_DISABLE_COMPRESSION = 32L;
        private static final long INIT_BIT_SSL_CONTEXT = 64L;
        private static final long OPT_BIT_IS_HTTP11_ONLY = 1L;
        private static final long OPT_BIT_FORCE_URL_CONNECTION_CLIENT = 2L;
        private static final long OPT_BIT_CLIENT_SPEC = 4L;
        private long initBits = 127L;
        private long optBits;
        @javax.annotation.Nullable
        private URI baseUri;
        @javax.annotation.Nullable
        private ObjectMapper mapper;
        @javax.annotation.Nullable
        private Class<?> jsonView;
        @javax.annotation.Nullable
        private HttpResponseFactory responseFactory;
        private int readTimeoutMillis;
        private int connectionTimeoutMillis;
        private boolean isDisableCompression;
        @javax.annotation.Nullable
        private SSLContext sslContext;
        @javax.annotation.Nullable
        private HttpAuthentication authentication;
        private List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
        private List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();
        @javax.annotation.Nullable
        private String followRedirects;
        @javax.annotation.Nullable
        private SSLParameters sslParameters;
        private boolean isHttp11Only;
        private boolean forceUrlConnectionClient;
        private int clientSpec;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HttpRuntimeConfig instance) {
            SSLParameters sslParametersValue;
            Objects.requireNonNull(instance, "instance");
            this.baseUri(instance.getBaseUri());
            this.mapper(instance.getMapper());
            Class<?> jsonViewValue = instance.getJsonView();
            if (jsonViewValue != null) {
                this.jsonView(jsonViewValue);
            }
            this.responseFactory(instance.responseFactory());
            this.readTimeoutMillis(instance.getReadTimeoutMillis());
            this.connectionTimeoutMillis(instance.getConnectionTimeoutMillis());
            this.isDisableCompression(instance.isDisableCompression());
            this.sslContext(instance.getSslContext());
            HttpAuthentication authenticationValue = instance.getAuthentication();
            if (authenticationValue != null) {
                this.authentication(authenticationValue);
            }
            this.addAllRequestFilters(instance.getRequestFilters());
            this.addAllResponseFilters(instance.getResponseFilters());
            String followRedirectsValue = instance.getFollowRedirects();
            if (followRedirectsValue != null) {
                this.followRedirects(followRedirectsValue);
            }
            if ((sslParametersValue = instance.getSslParameters()) != null) {
                this.sslParameters(sslParametersValue);
            }
            this.isHttp11Only(instance.isHttp11Only());
            this.forceUrlConnectionClient(instance.forceUrlConnectionClient());
            this.clientSpec(instance.getClientSpec());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseUri(URI baseUri) {
            this.baseUri = Objects.requireNonNull(baseUri, "baseUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mapper(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jsonView(Class<?> jsonView) {
            this.jsonView = jsonView;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder responseFactory(HttpResponseFactory responseFactory) {
            this.responseFactory = Objects.requireNonNull(responseFactory, "responseFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder readTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDisableCompression(boolean isDisableCompression) {
            this.isDisableCompression = isDisableCompression;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslContext(SSLContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authentication(@javax.annotation.Nullable HttpAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestFilters(RequestFilter element) {
            this.requestFilters.add(Objects.requireNonNull(element, "requestFilters element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestFilters(RequestFilter ... elements) {
            for (RequestFilter element : elements) {
                this.requestFilters.add(Objects.requireNonNull(element, "requestFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestFilters(Iterable<? extends RequestFilter> elements) {
            this.requestFilters.clear();
            return this.addAllRequestFilters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestFilters(Iterable<? extends RequestFilter> elements) {
            for (RequestFilter requestFilter : elements) {
                this.requestFilters.add(Objects.requireNonNull(requestFilter, "requestFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResponseFilters(ResponseFilter element) {
            this.responseFilters.add(Objects.requireNonNull(element, "responseFilters element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResponseFilters(ResponseFilter ... elements) {
            for (ResponseFilter element : elements) {
                this.responseFilters.add(Objects.requireNonNull(element, "responseFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder responseFilters(Iterable<? extends ResponseFilter> elements) {
            this.responseFilters.clear();
            return this.addAllResponseFilters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllResponseFilters(Iterable<? extends ResponseFilter> elements) {
            for (ResponseFilter responseFilter : elements) {
                this.responseFilters.add(Objects.requireNonNull(responseFilter, "responseFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder followRedirects(String followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isHttp11Only(boolean isHttp11Only) {
            this.isHttp11Only = isHttp11Only;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder forceUrlConnectionClient(boolean forceUrlConnectionClient) {
            this.forceUrlConnectionClient = forceUrlConnectionClient;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSpec(int clientSpec) {
            this.clientSpec = clientSpec;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableHttpRuntimeConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this));
        }

        private boolean isHttp11OnlyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean forceUrlConnectionClientIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean clientSpecIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("baseUri");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mapper");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("responseFactory");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("readTimeoutMillis");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("connectionTimeoutMillis");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("isDisableCompression");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("sslContext");
            }
            return "Cannot build HttpRuntimeConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="HttpRuntimeConfig", generator="Immutables")
    private final class InitShim {
        private byte isHttp11OnlyBuildStage = 0;
        private boolean isHttp11Only;
        private byte forceUrlConnectionClientBuildStage = 0;
        private boolean forceUrlConnectionClient;
        private byte clientSpecBuildStage = 0;
        private int clientSpec;

        private InitShim() {
        }

        boolean isHttp11Only() {
            if (this.isHttp11OnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isHttp11OnlyBuildStage == 0) {
                this.isHttp11OnlyBuildStage = (byte)-1;
                this.isHttp11Only = ImmutableHttpRuntimeConfig.this.isHttp11OnlyInitialize();
                this.isHttp11OnlyBuildStage = 1;
            }
            return this.isHttp11Only;
        }

        void isHttp11Only(boolean isHttp11Only) {
            this.isHttp11Only = isHttp11Only;
            this.isHttp11OnlyBuildStage = 1;
        }

        boolean forceUrlConnectionClient() {
            if (this.forceUrlConnectionClientBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceUrlConnectionClientBuildStage == 0) {
                this.forceUrlConnectionClientBuildStage = (byte)-1;
                this.forceUrlConnectionClient = ImmutableHttpRuntimeConfig.this.forceUrlConnectionClientInitialize();
                this.forceUrlConnectionClientBuildStage = 1;
            }
            return this.forceUrlConnectionClient;
        }

        void forceUrlConnectionClient(boolean forceUrlConnectionClient) {
            this.forceUrlConnectionClient = forceUrlConnectionClient;
            this.forceUrlConnectionClientBuildStage = 1;
        }

        int getClientSpec() {
            if (this.clientSpecBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clientSpecBuildStage == 0) {
                this.clientSpecBuildStage = (byte)-1;
                this.clientSpec = ImmutableHttpRuntimeConfig.this.getClientSpecInitialize();
                this.clientSpecBuildStage = 1;
            }
            return this.clientSpec;
        }

        void clientSpec(int clientSpec) {
            this.clientSpec = clientSpec;
            this.clientSpecBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isHttp11OnlyBuildStage == -1) {
                attributes.add("isHttp11Only");
            }
            if (this.forceUrlConnectionClientBuildStage == -1) {
                attributes.add("forceUrlConnectionClient");
            }
            if (this.clientSpecBuildStage == -1) {
                attributes.add("clientSpec");
            }
            return "Cannot build HttpRuntimeConfig, attribute initializers form cycle " + attributes;
        }
    }
}

