/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class HttpHeaders {
    private final Map<String, HttpHeader> headers = new LinkedHashMap<String, HttpHeader>();

    public void put(String name, String value) {
        String key = name.toLowerCase(Locale.ROOT);
        this.headers.computeIfAbsent(key, x -> new HttpHeader(name)).addValue(value);
    }

    public boolean contains(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        return this.headers.containsKey(key);
    }

    public void remove(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        this.headers.remove(key);
    }

    public Iterable<String> getValues(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        HttpHeader h = this.headers.get(key);
        return h != null ? h.getValues() : Collections.emptyList();
    }

    public Optional<String> getFirstValue(String name) {
        Iterator<String> it;
        String key = name.toLowerCase(Locale.ROOT);
        HttpHeader h = this.headers.get(key);
        if (h != null && (it = h.getValues().iterator()).hasNext()) {
            return Optional.of(it.next());
        }
        return Optional.empty();
    }

    public Map<String, Iterable<String>> asMap() {
        return this.headers.values().stream().collect(Collectors.toMap(HttpHeader::getName, HttpHeader::getValues));
    }

    public Collection<HttpHeader> allHeaders() {
        return this.headers.values();
    }

    public static final class HttpHeader {
        final String name;
        final Set<String> values = new LinkedHashSet<String>();

        HttpHeader(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addValue(String value) {
            this.values.add(value);
        }

        public Iterable<String> getValues() {
            return this.values;
        }
    }
}

