/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.EntriesParamsBuilder;
import org.projectnessie.api.v2.params.KeyRangeParams;
import org.projectnessie.model.ContentKey;

public class EntriesParams
extends KeyRangeParams<EntriesParams> {
    @Parameter(description="Restrict the result to one or more keys.\n\nCan be combined with min/max-key and prefix-key parameters, however both predicates must match. This means that keys specified via this parameter that do not match a given min/max-key or prefix-key will not be returned.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n")
    @QueryParam(value="key")
    private List<ContentKey> requestedKeys;
    @Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'entry.namespace' (string) & 'entry.contentType' (string)", examples={@ExampleObject(ref="expr_by_namespace"), @ExampleObject(ref="expr_by_contentType"), @ExampleObject(ref="expr_by_namespace_and_contentType")})
    @QueryParam(value="filter")
    private String filter;
    @Nullable
    @Parameter(description="Optionally request to return 'Content' objects for the returned keys.")
    @QueryParam(value="content")
    private Boolean withContent;

    public EntriesParams() {
    }

    @Builder.Constructor
    EntriesParams(@Nullable Integer maxRecords, @Nullable String pageToken, @Nullable ContentKey minKey, @Nullable ContentKey maxKey, @Nullable ContentKey prefixKey, @Nullable List<ContentKey> requestedKeys, @Nullable String filter, @Nullable Boolean withContent) {
        super(maxRecords, pageToken, minKey, maxKey, prefixKey);
        this.filter = filter;
        this.withContent = withContent;
        this.requestedKeys = requestedKeys;
    }

    public static EntriesParamsBuilder builder() {
        return new EntriesParamsBuilder();
    }

    public static EntriesParams empty() {
        return EntriesParams.builder().build();
    }

    public List<ContentKey> getRequestedKeys() {
        return this.requestedKeys;
    }

    @Nullable
    public String filter() {
        return this.filter;
    }

    public boolean withContent() {
        return this.withContent != null && this.withContent != false;
    }

    @Override
    public EntriesParams forNextPage(String pageToken) {
        return new EntriesParams(this.maxRecords(), pageToken, this.minKey(), this.maxKey(), this.prefixKey(), this.requestedKeys, this.filter, this.withContent);
    }
}

