/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.jsongrammar.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projectnessie.nessie.cli.jsongrammar.JsonCLexer;
import org.projectnessie.nessie.cli.jsongrammar.Node;
import org.projectnessie.nessie.cli.jsongrammar.Token;
import org.projectnessie.nessie.cli.jsongrammar.TokenSource;

public class BaseNode
implements Node {
    private JsonCLexer tokenSource;
    private static Class<? extends List<Node>> listClass;
    private Node parent;
    private final List<Node> children = this.newList();
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Map<String, Node> namedChildMap;
    private Map<String, List<Node>> namedChildListMap;

    @Override
    public JsonCLexer getTokenSource() {
        if (this.tokenSource == null) {
            for (Node child : this.children()) {
                if (child.getTokenSource() instanceof JsonCLexer) {
                    this.tokenSource = (JsonCLexer)child.getTokenSource();
                }
                if (this.tokenSource == null) continue;
                break;
            }
        }
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (JsonCLexer)tokenSource;
    }

    public static void setListClass(Class<? extends List<Node>> listClass) {
        BaseNode.listClass = listClass;
    }

    private List<Node> newList() {
        if (listClass == null) {
            return new ArrayList<Node>();
        }
        try {
            return listClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public boolean add(Node n) {
        n.setParent(this);
        return this.children.add(n);
    }

    @Override
    public void add(int i, Node n) {
        this.children.add(i, n);
        n.setParent(this);
    }

    @Override
    public Node get(int i) {
        return this.children.get(i);
    }

    @Override
    public Node set(int i, Node n) {
        this.children.get(i).setParent(null);
        n.setParent(this);
        return this.children.set(i, n);
    }

    @Override
    public Node remove(int i) {
        Node n = this.children.remove(i);
        n.setParent(null);
        return n;
    }

    @Override
    public boolean remove(Object obj) {
        Node n = (Node)obj;
        n.setParent(null);
        return this.children.remove(n);
    }

    @Override
    public void clear() {
        for (Node child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public List<Node> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public List<Node> subList(int from, int to) {
        return this.children.subList(from, to);
    }

    public List<Token> getRealTokens() {
        return this.descendants(Token.class, t -> !t.isUnparsed());
    }

    @Override
    public boolean addAll(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.setParent(this);
        }
        return this.children.addAll(nodes);
    }

    @Override
    public boolean addAll(int i, Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.setParent(this);
        }
        return this.children.addAll(i, nodes);
    }

    @Override
    public boolean containsAll(Collection<?> nodes) {
        return this.children.containsAll(nodes);
    }

    @Override
    public boolean retainAll(Collection<?> nodes) {
        return this.children.containsAll(nodes);
    }

    @Override
    public boolean removeAll(Collection<?> nodes) {
        return this.children.removeAll(nodes);
    }

    public String toString() {
        return this.getSource();
    }

    public Node getNamedChild(String name) {
        if (this.namedChildMap == null) {
            return null;
        }
        return this.namedChildMap.get(name);
    }

    public void setNamedChild(String name, Node node) {
        if (this.namedChildMap == null) {
            this.namedChildMap = new HashMap<String, Node>();
        }
        if (this.namedChildMap.containsKey(name)) {
            String msg = String.format("Duplicate named child not allowed: {0}", name);
            throw new RuntimeException(msg);
        }
        this.namedChildMap.put(name, node);
    }

    public List<Node> getNamedChildList(String name) {
        if (this.namedChildListMap == null) {
            return null;
        }
        return this.namedChildListMap.get(name);
    }

    public void addToNamedChildList(String name, Node node) {
        if (this.namedChildListMap == null) {
            this.namedChildListMap = new HashMap<String, List<Node>>();
        }
        List nodeList = this.namedChildListMap.computeIfAbsent(name, k -> new ArrayList());
        nodeList.add(node);
    }
}

