/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithHashCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ShowReferenceCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="ShowReferenceCommandSpec", generator="Immutables")
public final class ImmutableShowReferenceCommandSpec
implements ShowReferenceCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    @Nullable
    private final String ref;
    @Nullable
    private final String refTimestampOrHash;

    private ImmutableShowReferenceCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.ref = builder.ref;
        this.refTimestampOrHash = builder.refTimestampOrHash;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : ShowReferenceCommandSpec.super.sourceNode();
    }

    private ImmutableShowReferenceCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String ref, @Nullable String refTimestampOrHash) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.ref = ref;
        this.refTimestampOrHash = refTimestampOrHash;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getRefTimestampOrHash() {
        return this.refTimestampOrHash;
    }

    public final ImmutableShowReferenceCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableShowReferenceCommandSpec(value, this.sourceNode, this.ref, this.refTimestampOrHash);
    }

    public final ImmutableShowReferenceCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableShowReferenceCommandSpec(this.inCatalog, value, this.ref, this.refTimestampOrHash);
    }

    public final ImmutableShowReferenceCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableShowReferenceCommandSpec(this.inCatalog, this.sourceNode, value, this.refTimestampOrHash);
    }

    public final ImmutableShowReferenceCommandSpec withRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.refTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableShowReferenceCommandSpec(this.inCatalog, this.sourceNode, this.ref, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShowReferenceCommandSpec && this.equalTo(0, (ImmutableShowReferenceCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableShowReferenceCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && Objects.equals(this.ref, another.ref) && Objects.equals(this.refTimestampOrHash, another.refTimestampOrHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refTimestampOrHash);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ShowReferenceCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("ref", (Object)this.ref).add("refTimestampOrHash", (Object)this.refTimestampOrHash).toString();
    }

    public static ImmutableShowReferenceCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, @Nullable String ref, @Nullable String refTimestampOrHash) {
        return new ImmutableShowReferenceCommandSpec(inCatalog, sourceNode, ref, refTimestampOrHash);
    }

    public static ImmutableShowReferenceCommandSpec copyOf(ShowReferenceCommandSpec instance) {
        if (instance instanceof ImmutableShowReferenceCommandSpec) {
            return (ImmutableShowReferenceCommandSpec)instance;
        }
        return ImmutableShowReferenceCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShowReferenceCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private String ref;
        private String refTimestampOrHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShowReferenceCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithHashCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String refTimestampOrHashValue;
            String inCatalogValue;
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof ShowReferenceCommandSpec) {
                instance = (ShowReferenceCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RefWithHashCommandSpec) {
                instance = (RefWithHashCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    refTimestampOrHashValue = instance.getRefTimestampOrHash();
                    if (refTimestampOrHashValue != null) {
                        this.refTimestampOrHash(refTimestampOrHashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refTimestampOrHash(@Nullable String refTimestampOrHash) {
            this.refTimestampOrHash = refTimestampOrHash;
            return this;
        }

        public ImmutableShowReferenceCommandSpec build() {
            return new ImmutableShowReferenceCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

