/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.apache;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.http.impl.ResponseClosingInputStream;

final class ApacheResponseContext
implements ResponseContext {
    private final ClassicHttpResponse response;
    private final URI uri;
    private InputStream inputStream;

    ApacheResponseContext(ClassicHttpResponse response, URI uri) {
        this.response = response;
        this.uri = uri;
    }

    @Override
    public Status getStatus() {
        return Status.fromCode(this.response.getCode());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream base = this.safeGetInputStream();
        if (base == null) {
            return null;
        }
        if (this.inputStream == null) {
            this.inputStream = new ResponseClosingInputStream(base, (Closeable)this.response);
        }
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        Header header = this.response.getFirstHeader("Content-Type");
        return header != null ? header.getValue() : null;
    }

    @Override
    public URI getRequestedUri() {
        return this.uri;
    }

    @Override
    public void close(Exception error) {
        if (error != null) {
            try {
                EntityUtils.consume((HttpEntity)this.response.getEntity());
            }
            catch (IOException e) {
                error.addSuppressed(e);
            }
            finally {
                try {
                    this.response.close();
                }
                catch (IOException e) {
                    error.addSuppressed(e);
                }
            }
        }
    }

    private InputStream safeGetInputStream() throws IOException {
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity == null) {
                return null;
            }
            return entity.getContent();
        }
        catch (IOException e) {
            try {
                this.response.close();
            }
            catch (IOException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }
}

