/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ContentTypes;
import org.projectnessie.model.types.GenericContent;

public final class ContentTypeIdResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    public void init(JavaType bt) {
        this.baseType = bt;
    }

    public String idFromValue(Object value) {
        return this.getId(value);
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.getId(value);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    private String getId(Object value) {
        if (value instanceof Content) {
            return ((Content)value).getType().name();
        }
        return null;
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        Content.Type subType;
        try {
            subType = ContentTypes.forName(id);
        }
        catch (IllegalArgumentException e) {
            return context.constructSpecializedType(this.baseType, GenericContent.class);
        }
        Class<? extends Content> asType = subType.type();
        if (this.baseType.getRawClass().isAssignableFrom(asType)) {
            return context.constructSpecializedType(this.baseType, asType);
        }
        Class concrete = this.baseType.getRawClass();
        return context.constructSpecializedType(this.baseType, concrete);
    }
}

