/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceHistoryResponse;
import org.projectnessie.model.ReferenceHistoryState;

@ParametersAreNonnullByDefault
@Generated(from="ReferenceHistoryResponse", generator="Immutables")
@Immutable
public final class ImmutableReferenceHistoryResponse
implements ReferenceHistoryResponse {
    private final Reference reference;
    private final ReferenceHistoryState current;
    private final List<ReferenceHistoryState> previous;
    private final CommitConsistency commitLogConsistency;

    private ImmutableReferenceHistoryResponse(Reference reference, ReferenceHistoryState current, List<ReferenceHistoryState> previous, CommitConsistency commitLogConsistency) {
        this.reference = reference;
        this.current = current;
        this.previous = previous;
        this.commitLogConsistency = commitLogConsistency;
    }

    @Override
    @JsonProperty(value="reference", required=true)
    public Reference getReference() {
        return this.reference;
    }

    @Override
    @JsonProperty(value="current", required=true)
    public ReferenceHistoryState current() {
        return this.current;
    }

    @Override
    @JsonProperty(value="previous")
    public List<ReferenceHistoryState> previous() {
        return this.previous;
    }

    @Override
    @JsonProperty(value="commitLogConsistency", required=true)
    public CommitConsistency commitLogConsistency() {
        return this.commitLogConsistency;
    }

    public final ImmutableReferenceHistoryResponse withReference(Reference value) {
        if (this.reference == value) {
            return this;
        }
        Reference newValue = Objects.requireNonNull(value, "reference");
        return new ImmutableReferenceHistoryResponse(newValue, this.current, this.previous, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistoryResponse withCurrent(ReferenceHistoryState value) {
        if (this.current == value) {
            return this;
        }
        ReferenceHistoryState newValue = Objects.requireNonNull(value, "current");
        return new ImmutableReferenceHistoryResponse(this.reference, newValue, this.previous, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistoryResponse withPrevious(ReferenceHistoryState ... elements) {
        List<ReferenceHistoryState> newValue = ImmutableReferenceHistoryResponse.createUnmodifiableList(false, ImmutableReferenceHistoryResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReferenceHistoryResponse(this.reference, this.current, newValue, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistoryResponse withPrevious(Iterable<? extends ReferenceHistoryState> elements) {
        if (this.previous == elements) {
            return this;
        }
        List<ReferenceHistoryState> newValue = ImmutableReferenceHistoryResponse.createUnmodifiableList(false, ImmutableReferenceHistoryResponse.createSafeList(elements, true, false));
        return new ImmutableReferenceHistoryResponse(this.reference, this.current, newValue, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistoryResponse withCommitLogConsistency(CommitConsistency value) {
        CommitConsistency newValue = Objects.requireNonNull(value, "commitLogConsistency");
        if (this.commitLogConsistency == newValue) {
            return this;
        }
        return new ImmutableReferenceHistoryResponse(this.reference, this.current, this.previous, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceHistoryResponse && this.equalsByValue((ImmutableReferenceHistoryResponse)another);
    }

    private boolean equalsByValue(ImmutableReferenceHistoryResponse another) {
        return this.reference.equals(another.reference) && this.current.equals(another.current) && this.previous.equals(another.previous) && this.commitLogConsistency.equals((Object)another.commitLogConsistency);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reference.hashCode();
        h += (h << 5) + this.current.hashCode();
        h += (h << 5) + this.previous.hashCode();
        h += (h << 5) + this.commitLogConsistency.hashCode();
        return h;
    }

    public String toString() {
        return "ReferenceHistoryResponse{reference=" + String.valueOf(this.reference) + ", current=" + String.valueOf(this.current) + ", previous=" + String.valueOf(this.previous) + ", commitLogConsistency=" + String.valueOf((Object)this.commitLogConsistency) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReferenceHistoryResponse fromJson(Json json) {
        Builder builder = ImmutableReferenceHistoryResponse.builder();
        if (json._reference != null) {
            builder.reference(json._reference);
        }
        if (json._current != null) {
            builder.current(json._current);
        }
        if (json._previous != null) {
            builder.addAllPrevious(json._previous);
        }
        if (json._commitLogConsistency != null) {
            builder.commitLogConsistency(json._commitLogConsistency);
        }
        return builder.build();
    }

    public static ImmutableReferenceHistoryResponse copyOf(ReferenceHistoryResponse instance) {
        if (instance instanceof ImmutableReferenceHistoryResponse) {
            return (ImmutableReferenceHistoryResponse)instance;
        }
        return ImmutableReferenceHistoryResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ReferenceHistoryResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REFERENCE = 1L;
        private static final long INIT_BIT_CURRENT = 2L;
        private static final long INIT_BIT_COMMIT_LOG_CONSISTENCY = 4L;
        private long initBits = 7L;
        private Reference reference;
        private ReferenceHistoryState current;
        private List<ReferenceHistoryState> previous = new ArrayList<ReferenceHistoryState>();
        private CommitConsistency commitLogConsistency;

        private Builder() {
        }

        public final Builder from(ReferenceHistoryResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.reference(instance.getReference());
            this.current(instance.current());
            this.addAllPrevious(instance.previous());
            this.commitLogConsistency(instance.commitLogConsistency());
            return this;
        }

        @JsonProperty(value="reference", required=true)
        public final Builder reference(Reference reference) {
            this.reference = Objects.requireNonNull(reference, "reference");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="current", required=true)
        public final Builder current(ReferenceHistoryState current) {
            this.current = Objects.requireNonNull(current, "current");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPrevious(ReferenceHistoryState element) {
            this.previous.add(Objects.requireNonNull(element, "previous element"));
            return this;
        }

        public final Builder addPrevious(ReferenceHistoryState ... elements) {
            for (ReferenceHistoryState element : elements) {
                this.previous.add(Objects.requireNonNull(element, "previous element"));
            }
            return this;
        }

        @JsonProperty(value="previous")
        public final Builder previous(Iterable<? extends ReferenceHistoryState> elements) {
            this.previous.clear();
            return this.addAllPrevious(elements);
        }

        public final Builder addAllPrevious(Iterable<? extends ReferenceHistoryState> elements) {
            for (ReferenceHistoryState referenceHistoryState : elements) {
                this.previous.add(Objects.requireNonNull(referenceHistoryState, "previous element"));
            }
            return this;
        }

        @JsonProperty(value="commitLogConsistency", required=true)
        public final Builder commitLogConsistency(CommitConsistency commitLogConsistency) {
            this.commitLogConsistency = Objects.requireNonNull(commitLogConsistency, "commitLogConsistency");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReferenceHistoryResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceHistoryResponse(this.reference, this.current, ImmutableReferenceHistoryResponse.createUnmodifiableList(true, this.previous), this.commitLogConsistency);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reference");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("current");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("commitLogConsistency");
            }
            return "Cannot build ReferenceHistoryResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ReferenceHistoryResponse", generator="Immutables")
    static final class Json
    implements ReferenceHistoryResponse {
        @JsonIgnore
        Reference _reference;
        @JsonIgnore
        ReferenceHistoryState _current;
        @JsonIgnore
        List<ReferenceHistoryState> _previous = Collections.emptyList();
        @JsonIgnore
        CommitConsistency _commitLogConsistency;

        Json() {
        }

        @JsonProperty(value="reference", required=true)
        public void setReference(Reference reference) {
            this._reference = reference;
        }

        @JsonProperty(value="current", required=true)
        public void setCurrent(ReferenceHistoryState current) {
            this._current = current;
        }

        @JsonProperty(value="previous")
        public void setPrevious(List<ReferenceHistoryState> previous) {
            this._previous = previous;
        }

        @JsonProperty(value="commitLogConsistency", required=true)
        public void setCommitLogConsistency(CommitConsistency commitLogConsistency) {
            this._commitLogConsistency = commitLogConsistency;
        }

        @Override
        public Reference getReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceHistoryState current() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ReferenceHistoryState> previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommitConsistency commitLogConsistency() {
            throw new UnsupportedOperationException();
        }
    }
}

