/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.syntax;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.core.BNFProduction;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.projectnessie.nessie.cli.grammar.Token;
import org.projectnessie.nessie.cli.syntax.Syntax;
import org.projectnessie.nessie.cli.syntax.SyntaxPrinter;

public class SyntaxTool {
    static final String MARKDOWN_ESCAPES = "\\`*_{}[]<>#+-.!";

    public static void main(String[] args) throws Exception {
        Path outputDir = Paths.get(args[0], new String[0]);
        Files.createDirectories(outputDir, new FileAttribute[0]);
        HashMap<String, String> preprocessorSymbols = new HashMap<String, String>();
        for (int i = 2; i < args.length; ++i) {
            String arg = args[i];
            int eq = arg.indexOf(61);
            String k = arg.substring(0, eq);
            String v = arg.substring(eq + 1);
            preprocessorSymbols.put(k, v);
        }
        Syntax syntax = new Syntax(Paths.get(args[1], new String[0]), preprocessorSymbols);
        Map<SyntaxPrinter.Type, AttributedStyle> styleMap = SyntaxTool.ansiStyleMap();
        for (Map.Entry productionEntry : syntax.getGrammar().getProductionTable().entrySet()) {
            String name = (String)productionEntry.getKey();
            List<Token.TokenType> leadingTokens = SyntaxTool.leadingTokens(name);
            String ansi = SyntaxTool.syntaxAsAnsi(leadingTokens, syntax, (BNFProduction)productionEntry.getValue(), styleMap);
            String markdown = SyntaxTool.syntaxAsMarkdown(leadingTokens, syntax, (BNFProduction)productionEntry.getValue());
            String plain = SyntaxTool.syntaxAsPlain(leadingTokens, syntax, (BNFProduction)productionEntry.getValue());
            String refs = SyntaxTool.syntaxReferences(syntax, (BNFProduction)productionEntry.getValue());
            Files.writeString(outputDir.resolve(name + ".ansi.txt"), (CharSequence)ansi, new OpenOption[0]);
            Files.writeString(outputDir.resolve(name + ".plain.txt"), (CharSequence)plain, new OpenOption[0]);
            Files.writeString(outputDir.resolve(name + ".md"), (CharSequence)markdown, new OpenOption[0]);
            Files.writeString(outputDir.resolve(name + ".refs"), (CharSequence)refs, new OpenOption[0]);
        }
    }

    @VisibleForTesting
    static List<Token.TokenType> leadingTokens(String name) throws ClassNotFoundException, IllegalAccessException {
        List leadingTokens = List.of();
        Class<?> statementClass = Class.forName("org.projectnessie.nessie.cli.grammar.ast." + name);
        try {
            leadingTokens = (List)statementClass.getDeclaredField("LEADING_TOKENS").get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return leadingTokens;
    }

    static Map<SyntaxPrinter.Type, AttributedStyle> ansiStyleMap() {
        EnumMap<SyntaxPrinter.Type, AttributedStyle> styleMap = new EnumMap<SyntaxPrinter.Type, AttributedStyle>(SyntaxPrinter.Type.class);
        AttributedStyle def = AttributedStyle.DEFAULT;
        AttributedStyle bold = def.bold();
        styleMap.put(SyntaxPrinter.Type.PRE, def);
        styleMap.put(SyntaxPrinter.Type.POST, def);
        styleMap.put(SyntaxPrinter.Type.SEP, def);
        styleMap.put(SyntaxPrinter.Type.IDENTIFIER, bold.foreground(3));
        styleMap.put(SyntaxPrinter.Type.TERMINAL, bold.foreground(6));
        styleMap.put(SyntaxPrinter.Type.NON_TERMINAL, bold.foreground(2));
        styleMap.put(SyntaxPrinter.Type.UNKNOWN, bold.foreground(1));
        return styleMap;
    }

    static String syntaxAsMarkdown(List<Token.TokenType> leadingTokens, Syntax syntax, BNFProduction production) {
        final StringBuilder sb = new StringBuilder();
        sb.append("> ");
        SyntaxPrinter printer = new SyntaxPrinter(){

            @Override
            public void newline(String indent) {
                sb.append("<br>\n  ").append(indent);
            }

            @Override
            public void space() {
                sb.append(' ');
            }

            @Override
            public void write(SyntaxPrinter.Type type, String str) {
                String pre = "";
                String post = "";
                switch (type) {
                    case PRE: 
                    case POST: 
                    case SEP: {
                        break;
                    }
                    case IDENTIFIER: {
                        pre = "**`";
                        post = "`**";
                        break;
                    }
                    case TERMINAL: {
                        post = "`";
                        pre = "`";
                        break;
                    }
                    case NON_TERMINAL: {
                        post = "**";
                        pre = "**";
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                }
                sb.append(pre);
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (SyntaxTool.MARKDOWN_ESCAPES.indexOf(c) != -1) {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                sb.append(post);
            }
        };
        for (Token.TokenType leadingToken : leadingTokens) {
            printer.write(SyntaxPrinter.Type.TERMINAL, leadingToken.name());
            printer.space();
        }
        syntax.print(production, printer);
        return sb.toString();
    }

    static String syntaxAsAnsi(List<Token.TokenType> leadingTokens, Syntax syntax, BNFProduction production, final Map<SyntaxPrinter.Type, AttributedStyle> styleMap) {
        final AttributedStringBuilder sb = new AttributedStringBuilder();
        SyntaxPrinter printer = new SyntaxPrinter(){

            @Override
            public void newline(String indent) {
                sb.append('\n').append((CharSequence)indent);
            }

            @Override
            public void space() {
                sb.append(' ');
            }

            @Override
            public void write(SyntaxPrinter.Type type, String str) {
                sb.append((CharSequence)str, (AttributedStyle)styleMap.get((Object)type));
            }
        };
        for (Token.TokenType leadingToken : leadingTokens) {
            printer.write(SyntaxPrinter.Type.TERMINAL, leadingToken.name());
            printer.space();
        }
        syntax.print(production, printer);
        return sb.toAnsi(256, AttributedCharSequence.ForceMode.Force256Colors);
    }

    static String syntaxAsPlain(List<Token.TokenType> leadingTokens, Syntax syntax, BNFProduction production) {
        final StringBuilder sb = new StringBuilder();
        SyntaxPrinter printer = new SyntaxPrinter(){

            @Override
            public void newline(String indent) {
                sb.append('\n').append(indent);
            }

            @Override
            public void space() {
                sb.append(' ');
            }

            @Override
            public void write(SyntaxPrinter.Type type, String str) {
                sb.append(str);
            }
        };
        for (Token.TokenType leadingToken : leadingTokens) {
            printer.write(SyntaxPrinter.Type.TERMINAL, leadingToken.name());
            printer.space();
        }
        syntax.print(production, printer);
        return sb.toString();
    }

    static String syntaxReferences(Syntax syntax, BNFProduction production) {
        final StringBuilder sb = new StringBuilder();
        SyntaxPrinter printer = new SyntaxPrinter(){
            final Set<String> seen = new HashSet<String>();

            @Override
            public void newline(String indent) {
            }

            @Override
            public void space() {
            }

            @Override
            public void write(SyntaxPrinter.Type type, String str) {
                if (type == SyntaxPrinter.Type.NON_TERMINAL && this.seen.add(str)) {
                    sb.append(str).append('\n');
                }
            }
        };
        syntax.print(production, printer);
        return sb.toString();
    }
}

