/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk11;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

final class JavaResponseContext
implements ResponseContext {
    private final HttpResponse<InputStream> response;
    private final InputStream inputStream;

    JavaResponseContext(HttpResponse<InputStream> response) {
        this.response = response;
        try {
            this.inputStream = this.maybeDecompress();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Status getResponseCode() {
        return Status.fromCode(this.response.statusCode());
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.response.headers().firstValue("Content-Type").orElse(null);
    }

    @Override
    public URI getRequestedUri() {
        return this.response.uri();
    }

    private InputStream maybeDecompress() throws IOException {
        InputStream base = this.response.body();
        String contentEncoding = this.response.headers().firstValue("Content-Encoding").orElse("");
        if ("gzip".equals(contentEncoding)) {
            return new GZIPInputStream(base);
        }
        if ("deflate".equals(contentEncoding)) {
            return new InflaterInputStream(base);
        }
        return base;
    }
}

