/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.jsongrammar;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.projectnessie.nessie.cli.jsongrammar.TokenSource;

public interface Node
extends List<Node> {
    default public NodeType getType() {
        return null;
    }

    default public void open() {
    }

    default public void close() {
    }

    default public String getInputSource() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? "input" : tokenSource.getInputSource();
    }

    default public boolean hasChildNodes() {
        return this.size() > 0;
    }

    public void setParent(Node var1);

    public Node getParent();

    default public boolean replace(Node current, Node replacement) {
        int index = this.indexOf(current);
        if (index == -1) {
            return false;
        }
        this.set(index, replacement);
        current.setParent(null);
        return true;
    }

    default public boolean prependChild(Node where, Node inserted) {
        int index = this.indexOf(where);
        if (index == -1) {
            return false;
        }
        this.add(index, inserted);
        return true;
    }

    default public boolean appendChild(Node where, Node inserted) {
        int index = this.indexOf(where);
        if (index == -1) {
            return false;
        }
        this.add(index + 1, inserted);
        return true;
    }

    default public int indexOf(Node child) {
        for (int i = 0; i < this.size(); ++i) {
            if (child != this.get(i)) continue;
            return i;
        }
        return -1;
    }

    default public Node previousSibling() {
        Node parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int idx = parent.indexOf(this);
        if (idx <= 0) {
            return null;
        }
        return (Node)parent.get(idx - 1);
    }

    default public Node nextSibling() {
        Node parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int idx = parent.indexOf(this);
        if (idx >= parent.size() - 1) {
            return null;
        }
        return (Node)parent.get(idx + 1);
    }

    default public List<Node> children(boolean includeUnparsedTokens) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.size(); ++i) {
            TerminalNode tok;
            Node child = (Node)this.get(i);
            if (includeUnparsedTokens && child instanceof TerminalNode && !(tok = (TerminalNode)child).isUnparsed()) {
                result.addAll(tok.precedingUnparsedTokens());
            }
            result.add(child);
        }
        return result;
    }

    default public List<Node> children() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.size(); ++i) {
            result.add((Node)this.get(i));
        }
        return result;
    }

    default public List<Node> children(Predicate<? super Node> predicate) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (predicate != null && !predicate.test(child)) continue;
            result.add(child);
        }
        return result;
    }

    default public List<? extends TerminalNode> getAllTokens(boolean includeCommentTokens) {
        ArrayList<TerminalNode> result = new ArrayList<TerminalNode>();
        for (Node child : this) {
            if (child instanceof TerminalNode) {
                TerminalNode tn = (TerminalNode)child;
                if (tn.isUnparsed()) continue;
                if (includeCommentTokens) {
                    result.addAll(tn.precedingUnparsedTokens());
                }
                result.add(tn);
                continue;
            }
            if (child.size() <= 0) continue;
            result.addAll(child.getAllTokens(includeCommentTokens));
        }
        return result;
    }

    public TokenSource getTokenSource();

    public void setTokenSource(TokenSource var1);

    default public String getSource() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? null : tokenSource.getText(this.getBeginOffset(), this.getEndOffset());
    }

    default public String getImage() {
        return this.getSource();
    }

    default public int getLength() {
        return this.getEndOffset() - this.getBeginOffset();
    }

    default public int getBeginLine() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getBeginOffset());
    }

    default public int getEndLine() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getEndOffset() - 1);
    }

    default public int getBeginColumn() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    default public int getEndColumn() {
        TokenSource tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getEndOffset() - 1);
    }

    public int getBeginOffset();

    public int getEndOffset();

    public void setBeginOffset(int var1);

    public void setEndOffset(int var1);

    default public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    default public boolean isUnparsed() {
        return false;
    }

    public void setUnparsed(boolean var1);

    default public <T> T firstChildOfType(Class<T> clazz) {
        return this.firstChildOfType(clazz, null);
    }

    default public <T> T firstChildOfType(Class<T> clazz, Predicate<? super T> pred) {
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (!clazz.isInstance(child)) continue;
            T t = clazz.cast(child);
            if (pred != null && !pred.test(t)) continue;
            return t;
        }
        return null;
    }

    default public Node firstDescendantOfType(NodeType type, Predicate<? super Node> pred) {
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (child.getType() == type) {
                if (pred != null && !pred.test(child)) continue;
                return child;
            }
            Node tok = child.firstDescendantOfType(type, pred);
            if (tok == null) continue;
            return tok;
        }
        return null;
    }

    default public Node firstDescendantOfType(NodeType type) {
        return this.firstDescendantOfType(type, null);
    }

    default public Node firstChildOfType(NodeType type) {
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (child.getType() != type) continue;
            return child;
        }
        return null;
    }

    default public <T extends Node> T firstDescendantOfType(Class<T> clazz, Predicate<? super T> pred) {
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (clazz.isInstance(child)) {
                Node t = (Node)clazz.cast(child);
                if (pred != null && !pred.test(t)) continue;
                return (T)t;
            }
            T descendant = child.firstDescendantOfType(clazz, pred);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    default public <T extends Node> T firstDescendantOfType(Class<T> clazz) {
        return this.firstDescendantOfType(clazz, null);
    }

    default public <T> List<T> childrenOfType(Class<T> clazz, Predicate<? super T> pred) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (!clazz.isInstance(child)) continue;
            T t = clazz.cast(child);
            if (pred != null && !pred.test(t)) continue;
            result.add(t);
        }
        return result;
    }

    default public List<Node> childrenOfType(NodeType type, Predicate<? super Node> pred) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (child.getType() != type || pred != null && !pred.test(child)) continue;
            result.add(child);
        }
        return result;
    }

    default public List<Node> childrenOfType(NodeType type) {
        return this.childrenOfType(type, null);
    }

    default public <T> List<T> childrenOfType(Class<T> clazz) {
        return this.childrenOfType(clazz, null);
    }

    default public <T extends Node> List<T> descendantsOfType(Class<T> clazz, Predicate<? super T> pred) {
        return this.descendants(clazz, pred);
    }

    default public <T extends Node> List<T> descendantsOfType(Class<T> clazz) {
        return this.descendants(clazz, null);
    }

    default public <T extends Node> T firstAncestorOfType(Class<T> clazz) {
        Node parent = this;
        while (parent != null) {
            if (!clazz.isInstance(parent = parent.getParent())) continue;
            return (T)((Node)clazz.cast(parent));
        }
        return null;
    }

    default public void copyLocationInfo(Node from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    default public void copyLocationInfo(Node start, Node end) {
        this.setTokenSource(start.getTokenSource());
        if (this.getTokenSource() == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    default public void replace(Node toBeReplaced) {
        this.copyLocationInfo(toBeReplaced);
        Node parent = toBeReplaced.getParent();
        if (parent != null) {
            int index = parent.indexOf(toBeReplaced);
            parent.set(index, this);
        }
    }

    default public Node getFirstChild() {
        return this.size() > 0 ? (Node)this.get(0) : null;
    }

    default public Node getLastChild() {
        int count = this.size();
        return count > 0 ? (Node)this.get(count - 1) : null;
    }

    default public Node getRoot() {
        Node parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    default public List<Node> descendants() {
        return this.descendants(Node.class, null);
    }

    default public List<Node> descendants(Predicate<? super Node> predicate) {
        return this.descendants(Node.class, predicate);
    }

    default public <T extends Node> List<T> descendants(Class<T> clazz) {
        return this.descendants(clazz, null);
    }

    default public <T extends Node> List<T> descendants(Class<T> clazz, Predicate<? super T> predicate) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.size(); ++i) {
            Node child = (Node)this.get(i);
            if (clazz.isInstance(child)) {
                Node t = (Node)clazz.cast(child);
                if (predicate == null || predicate.test(t)) {
                    result.add(t);
                }
            }
            result.addAll(child.descendants(clazz, predicate));
        }
        return result;
    }

    default public void dump(String prefix, PrintStream ps) {
        Object output;
        if (this instanceof TerminalNode) {
            output = this.getType().isEOF() ? "EOF" : (this.getType().isInvalid() ? "Lexically Invalid Input:" + this.toString() : this.toString().trim());
            output = String.format("%s: (%d, %d) - (%d, %d): %s", this.getClass().getSimpleName(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn(), output);
        } else {
            output = String.format("<%s (%d, %d)-(%d, %d)>", this.getClass().getSimpleName(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        }
        if (((String)output).length() > 0) {
            ps.println(prefix + (String)output);
        }
        for (Node child : this) {
            child.dump(prefix + "  ", ps);
        }
    }

    default public void dump(String prefix) {
        this.dump(prefix, System.out);
    }

    default public void dump() {
        this.dump("");
    }

    @Override
    default public ListIterator<Node> iterator() {
        return new ListIterator<Node>(){
            private int current = -1;
            private boolean justModified;

            @Override
            public boolean hasNext() {
                return this.current + 1 < Node.this.size();
            }

            @Override
            public Node next() {
                this.justModified = false;
                return (Node)Node.this.get(++this.current);
            }

            @Override
            public Node previous() {
                this.justModified = false;
                return (Node)Node.this.get(--this.current);
            }

            @Override
            public void remove() {
                if (this.justModified) {
                    throw new IllegalStateException();
                }
                Node.this.remove(this.current);
                --this.current;
                this.justModified = true;
            }

            @Override
            public void add(Node n) {
                if (this.justModified) {
                    throw new IllegalStateException();
                }
                Node.this.add(this.current + 1, n);
                this.justModified = true;
            }

            @Override
            public boolean hasPrevious() {
                return this.current > 0;
            }

            @Override
            public int nextIndex() {
                return this.current + 1;
            }

            @Override
            public int previousIndex() {
                return this.current;
            }

            @Override
            public void set(Node n) {
                Node.this.set(this.current, n);
            }
        };
    }

    @Override
    default public List<Node> subList(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public ListIterator<Node> listIterator() {
        return this.iterator();
    }

    @Override
    default public ListIterator<Node> listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public int indexOf(Object obj) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Node)this.get(i)).equals(obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object obj) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!((Node)this.get(i)).equals(obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public boolean addAll(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean addAll(int i, Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean containsAll(Collection<?> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean retainAll(Collection<?> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean removeAll(Collection<?> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public <T> T[] toArray(T[] nodes) {
        return this.children().toArray(nodes);
    }

    @Override
    default public Object[] toArray() {
        return this.children().toArray();
    }

    @Override
    default public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public void clear() {
    }

    public static interface TerminalNode
    extends Node {
        public TerminalNode getNext();

        public List<? extends TerminalNode> precedingUnparsedTokens();

        default public void truncate(int amount) {
            int newEndOffset = Math.max(this.getBeginOffset(), this.getEndOffset() - amount);
            this.setEndOffset(newEndOffset);
        }

        @Override
        default public boolean add(Node n) {
            throw new UnsupportedOperationException("This is a terminal node. It has no child nodes.");
        }

        @Override
        default public void add(int i, Node n) {
            throw new UnsupportedOperationException("This is a terminal node. It has no child nodes.");
        }

        @Override
        default public Node remove(int i) {
            throw new UnsupportedOperationException("This is a terminal node. It has no child nodes.");
        }

        @Override
        default public boolean remove(Object obj) {
            throw new UnsupportedOperationException("This is a terminal node. It has no child nodes.");
        }

        @Override
        default public Node set(int i, Node n) {
            throw new UnsupportedOperationException("This is a terminal node. It has no child nodes.");
        }

        @Override
        default public int indexOf(Node n) {
            return -1;
        }

        @Override
        default public int size() {
            return 0;
        }

        @Override
        default public Node get(int i) {
            throw new UnsupportedOperationException("This is a terminal node. It has no child nodes.");
        }

        @Override
        default public List<Node> children() {
            return Collections.emptyList();
        }
    }

    public static interface NodeType {
        public boolean isUndefined();

        public boolean isInvalid();

        public boolean isEOF();

        default public String getLiteralString() {
            return null;
        }
    }

    public static abstract class Visitor {
        private static Map<Class<? extends Visitor>, Map<Class<? extends Node>, Method>> mapLookup;
        private static final Method DUMMY_METHOD;
        private Map<Class<? extends Node>, Method> methodCache = mapLookup.get(this.getClass());
        protected boolean visitUnparsedTokens;

        public Visitor() {
            if (this.methodCache == null) {
                this.methodCache = new ConcurrentHashMap<Class<? extends Node>, Method>();
                mapLookup.put(this.getClass(), this.methodCache);
            }
        }

        private Method getVisitMethod(Node node) {
            Class<?> nodeClass = node.getClass();
            Method method = this.methodCache.get(nodeClass);
            if (method == null) {
                method = this.getVisitMethodImpl(nodeClass);
                this.methodCache.put(nodeClass, method);
            }
            return method;
        }

        private Method getVisitMethodImpl(Class<?> nodeClass) {
            if (nodeClass == null || !Node.class.isAssignableFrom(nodeClass)) {
                return DUMMY_METHOD;
            }
            try {
                Method m = this.getClass().getDeclaredMethod("visit", nodeClass);
                if (!Modifier.isPublic(nodeClass.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                    m.setAccessible(true);
                }
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class<?> interf : nodeClass.getInterfaces()) {
                    if (!Node.class.isAssignableFrom(interf) || Node.class.equals(interf)) continue;
                    try {
                        Method m = this.getClass().getDeclaredMethod("visit", interf);
                        if (!Modifier.isPublic(interf.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                            m.setAccessible(true);
                        }
                        return m;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
                return this.getVisitMethodImpl(nodeClass.getSuperclass());
            }
        }

        public void visit(Node node) {
            if (node == null) {
                return;
            }
            Method visitMethod = this.getVisitMethod(node);
            if (visitMethod == DUMMY_METHOD) {
                this.recurse(node);
            } else {
                try {
                    visitMethod.invoke((Object)this, node);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(ite);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
            }
        }

        public void recurse(Node node) {
            if (node != null) {
                for (Node child : node.children(this.visitUnparsedTokens)) {
                    this.visit(child);
                }
            }
        }

        static {
            try {
                DUMMY_METHOD = Object.class.getMethod("toString", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            mapLookup = Collections.synchronizedMap(new HashMap());
        }
    }
}

