/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projectnessie.nessie.cli.grammar.CompletionType;
import org.projectnessie.nessie.cli.grammar.NessieCliParser;
import org.projectnessie.nessie.cli.grammar.ParseException;
import org.projectnessie.nessie.cli.grammar.Token;

public abstract class CliCompleter {
    private final String source;
    private final NessieCliParser parser;
    private final Consumer<NessieCliParser> producer;

    public CliCompleter(String input, int cursor, Function<String, NessieCliParser> parserForSource, Consumer<NessieCliParser> producer) {
        this.source = input.substring(0, cursor);
        this.parser = parserForSource.apply(this.source);
        this.producer = producer;
    }

    public NessieCliParser parser() {
        return this.parser;
    }

    public boolean tryStatement() {
        try {
            List<Token.TokenType> optionalTokens;
            this.producer.accept(this.parser);
            if (this.parser.getToken(0).getType().isEOF()) {
                Token prev = this.parser.getToken(-1);
                switch (prev.getType()) {
                    case IDENTIFIER: 
                    case STRING_LITERAL: 
                    case URI: {
                        this.completeWithIdentifier(this.source.substring(0, prev.getEndOffset()), this.source.substring(prev.getBeginOffset()));
                        break;
                    }
                }
            }
            if (!(optionalTokens = this.parser.optionalNextTokenTypes()).isEmpty()) {
                Object preceding = this.source;
                if (!((String)preceding).isEmpty() && !Character.isWhitespace(((String)preceding).charAt(((String)preceding).length() - 1))) {
                    preceding = (String)preceding + " ";
                }
                for (Token.TokenType optionalToken : optionalTokens) {
                    if (!this.parser.isTokenActive(optionalToken)) continue;
                    this.tokenCandidateOther((String)preceding, optionalToken);
                }
            }
            return false;
        }
        catch (ParseException e) {
            Object trimmed;
            Token c;
            int index = 0;
            Token currentToken = this.parser.getToken(index);
            int cursor = this.source.length();
            while (currentToken.getBeginOffset() > cursor || cursor > currentToken.getEndOffset()) {
                Token next;
                if (cursor < currentToken.getEndOffset()) {
                    Token prev;
                    if ((prev = this.parser.getToken(--index)) == null) break;
                    currentToken = prev;
                }
                if (cursor < currentToken.getEndOffset()) continue;
                if ((next = this.parser.getToken(++index)) == null || next.getType().isEOF()) break;
                currentToken = next;
            }
            int i = index;
            while ((c = this.parser.getToken(i)) != null) {
                if (c.getType().isInvalid()) {
                    currentToken = c;
                }
                --i;
            }
            if (currentToken.isInvalid()) {
                trimmed = this.source.substring(0, currentToken.getBeginOffset());
            } else {
                trimmed = this.source;
                if (!((String)trimmed).isEmpty() && !Character.isWhitespace(((String)trimmed).charAt(((String)trimmed).length() - 1))) {
                    trimmed = (String)trimmed + " ";
                }
            }
            String currentSource = this.source.substring(currentToken.getBeginOffset(), cursor);
            String currentUpper = currentSource.toUpperCase(Locale.ROOT);
            boolean currentIsEmpty = currentSource.trim().isEmpty();
            boolean handledIdentifier = false;
            ArrayList<Token.TokenType> expectedTokenTypes = new ArrayList<Token.TokenType>(this.parser.optionalNextTokenTypes());
            block14: for (Token.TokenType expected : e.getExpectedTokenTypes()) {
                switch (expected) {
                    case EOF: 
                    case DUMMY: 
                    case WHITESPACE: {
                        continue block14;
                    }
                }
                if (!this.parser.isTokenActive(expected)) continue;
                expectedTokenTypes.add(expected);
            }
            block15: for (Token.TokenType expected : expectedTokenTypes) {
                switch (expected) {
                    case IDENTIFIER: 
                    case STRING_LITERAL: 
                    case URI: {
                        if (handledIdentifier) continue block15;
                        this.completeWithIdentifier((String)trimmed, currentSource);
                        handledIdentifier = true;
                        continue block15;
                    }
                }
                String tokenString = this.parser.tokenToLiteral(expected);
                String tokenUpper = tokenString.toUpperCase(Locale.ROOT);
                if (currentIsEmpty) {
                    this.tokenCandidateOther((String)trimmed, expected);
                    continue;
                }
                if (tokenUpper.startsWith(currentUpper)) {
                    this.tokenCandidateStartsWith((String)trimmed, expected);
                    continue;
                }
                if (tokenUpper.contains(currentUpper)) {
                    this.tokenCandidateContains((String)trimmed, expected);
                    continue;
                }
                this.tokenCandidateOther((String)trimmed, expected);
            }
            return true;
        }
    }

    private void completeWithIdentifier(String preceding, String toComplete) {
        char c;
        boolean quoted = false;
        char c2 = c = !toComplete.isEmpty() ? toComplete.charAt(0) : (char)'\u0000';
        if (c == '\"' || c == '\'' || c == '`') {
            quoted = true;
            if ((toComplete = toComplete.substring(1)).endsWith("" + c)) {
                toComplete = toComplete.substring(0, toComplete.length() - 1);
            }
        }
        this.completeWithLiteral(this.parser.completionType(), preceding, toComplete, quoted);
    }

    protected abstract void completeWithLiteral(CompletionType var1, String var2, String var3, boolean var4);

    protected abstract void tokenCandidateStartsWith(String var1, Token.TokenType var2);

    protected abstract void tokenCandidateContains(String var1, Token.TokenType var2);

    protected abstract void tokenCandidateOther(String var1, Token.TokenType var2);
}

