/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.ConnectCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="ConnectCommandSpec", generator="Immutables")
public final class ImmutableConnectCommandSpec
implements ConnectCommandSpec {
    @Nullable
    private final Node sourceNode;
    private final String uri;
    @Nullable
    private final String initialReference;
    private final ImmutableMap<String, String> parameters;

    private ImmutableConnectCommandSpec(@Nullable Node sourceNode, String uri, @Nullable String initialReference, Map<String, ? extends String> parameters) {
        this.sourceNode = sourceNode;
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initialReference = initialReference;
        this.parameters = ImmutableMap.copyOf(parameters);
    }

    private ImmutableConnectCommandSpec(Builder builder) {
        this.uri = builder.uri;
        this.initialReference = builder.initialReference;
        this.parameters = builder.parameters.build();
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : ConnectCommandSpec.super.sourceNode();
    }

    private ImmutableConnectCommandSpec(ImmutableConnectCommandSpec original, @Nullable Node sourceNode, String uri, @Nullable String initialReference, ImmutableMap<String, String> parameters) {
        this.sourceNode = sourceNode;
        this.uri = uri;
        this.initialReference = initialReference;
        this.parameters = parameters;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    @Nullable
    public String getInitialReference() {
        return this.initialReference;
    }

    public ImmutableMap<String, String> getParameters() {
        return this.parameters;
    }

    public final ImmutableConnectCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableConnectCommandSpec(this, value, this.uri, this.initialReference, this.parameters);
    }

    public final ImmutableConnectCommandSpec withUri(String value) {
        String newValue = Objects.requireNonNull(value, "uri");
        if (this.uri.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectCommandSpec(this, this.sourceNode, newValue, this.initialReference, this.parameters);
    }

    public final ImmutableConnectCommandSpec withInitialReference(@Nullable String value) {
        if (Objects.equals(this.initialReference, value)) {
            return this;
        }
        return new ImmutableConnectCommandSpec(this, this.sourceNode, this.uri, value, this.parameters);
    }

    public final ImmutableConnectCommandSpec withParameters(Map<String, ? extends String> entries) {
        if (this.parameters == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableConnectCommandSpec(this, this.sourceNode, this.uri, this.initialReference, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectCommandSpec && this.equalTo(0, (ImmutableConnectCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableConnectCommandSpec another) {
        return Objects.equals(this.sourceNode, another.sourceNode) && this.uri.equals(another.uri) && Objects.equals(this.initialReference, another.initialReference) && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + Objects.hashCode(this.initialReference);
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConnectCommandSpec").omitNullValues().add("sourceNode", (Object)this.sourceNode).add("uri", (Object)this.uri).add("initialReference", (Object)this.initialReference).add("parameters", this.parameters).toString();
    }

    public static ImmutableConnectCommandSpec of(@Nullable Node sourceNode, String uri, @Nullable String initialReference, Map<String, ? extends String> parameters) {
        return new ImmutableConnectCommandSpec(sourceNode, uri, initialReference, parameters);
    }

    public static ImmutableConnectCommandSpec copyOf(ConnectCommandSpec instance) {
        if (instance instanceof ImmutableConnectCommandSpec) {
            return (ImmutableConnectCommandSpec)instance;
        }
        return ImmutableConnectCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_URI = 1L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 1L;
        private long optBits;
        private Node sourceNode;
        private String uri;
        private String initialReference;
        private ImmutableMap.Builder<String, String> parameters = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ConnectCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            CommandSpec instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 1L) == 0L) {
                    Node sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ConnectCommandSpec) {
                instance = (ConnectCommandSpec)object;
                String initialReferenceValue = instance.getInitialReference();
                if (initialReferenceValue != null) {
                    this.initialReference(initialReferenceValue);
                }
                if ((bits & 1L) == 0L) {
                    Node sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 1L;
                }
                this.uri(instance.getUri());
                this.putAllParameters(instance.getParameters());
            }
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialReference(@Nullable String initialReference) {
            this.initialReference = initialReference;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameter(String key, String value) {
            this.parameters.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putParameter(Map.Entry<String, ? extends String> entry) {
            this.parameters.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameters(Map<String, ? extends String> entries) {
            this.parameters = ImmutableMap.builder();
            return this.putAllParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllParameters(Map<String, ? extends String> entries) {
            this.parameters.putAll(entries);
            return this;
        }

        public ImmutableConnectCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConnectCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build ConnectCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

