/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefWithTypeCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RevertContentCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="RevertContentCommandSpec", generator="Immutables")
public final class ImmutableRevertContentCommandSpec
implements RevertContentCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    private final boolean isDryRun;
    private final boolean isAllowDeletes;
    @Nullable
    private final String ref;
    @Nullable
    private final String refType;
    @Nullable
    private final String sourceRef;
    @Nullable
    private final String sourceRefType;
    @Nullable
    private final String sourceRefTimestampOrHash;
    private final ImmutableList<String> contentKeys;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRevertContentCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, boolean isAllowDeletes, @Nullable String ref, @Nullable String refType, @Nullable String sourceRef, @Nullable String sourceRefType, @Nullable String sourceRefTimestampOrHash, Iterable<String> contentKeys) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.isDryRun = isDryRun;
        this.isAllowDeletes = isAllowDeletes;
        this.ref = ref;
        this.refType = refType;
        this.sourceRef = sourceRef;
        this.sourceRefType = sourceRefType;
        this.sourceRefTimestampOrHash = sourceRefTimestampOrHash;
        this.contentKeys = ImmutableList.copyOf(contentKeys);
        this.initShim = null;
    }

    private ImmutableRevertContentCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.ref = builder.ref;
        this.refType = builder.refType;
        this.sourceRef = builder.sourceRef;
        this.sourceRefType = builder.sourceRefType;
        this.sourceRefTimestampOrHash = builder.sourceRefTimestampOrHash;
        this.contentKeys = builder.contentKeys.build();
        if (builder.sourceNodeIsSet()) {
            this.initShim.sourceNode(builder.sourceNode);
        }
        if (builder.isDryRunIsSet()) {
            this.initShim.isDryRun(builder.isDryRun);
        }
        if (builder.isAllowDeletesIsSet()) {
            this.initShim.isAllowDeletes(builder.isAllowDeletes);
        }
        this.sourceNode = this.initShim.sourceNode();
        this.isDryRun = this.initShim.isDryRun();
        this.isAllowDeletes = this.initShim.isAllowDeletes();
        this.initShim = null;
    }

    private ImmutableRevertContentCommandSpec(ImmutableRevertContentCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, boolean isAllowDeletes, @Nullable String ref, @Nullable String refType, @Nullable String sourceRef, @Nullable String sourceRefType, @Nullable String sourceRefTimestampOrHash, ImmutableList<String> contentKeys) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.isDryRun = isDryRun;
        this.isAllowDeletes = isAllowDeletes;
        this.ref = ref;
        this.refType = refType;
        this.sourceRef = sourceRef;
        this.sourceRefType = sourceRefType;
        this.sourceRefTimestampOrHash = sourceRefTimestampOrHash;
        this.contentKeys = contentKeys;
        this.initShim = null;
    }

    @Nullable
    private Node sourceNodeInitialize() {
        return RevertContentCommandSpec.super.sourceNode();
    }

    private boolean isDryRunInitialize() {
        return RevertContentCommandSpec.super.isDryRun();
    }

    private boolean isAllowDeletesInitialize() {
        return RevertContentCommandSpec.super.isAllowDeletes();
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNode() : this.sourceNode;
    }

    @Override
    public boolean isDryRun() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDryRun() : this.isDryRun;
    }

    @Override
    public boolean isAllowDeletes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAllowDeletes() : this.isAllowDeletes;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    @Nullable
    public String getRefType() {
        return this.refType;
    }

    @Override
    @Nullable
    public String getSourceRef() {
        return this.sourceRef;
    }

    @Override
    @Nullable
    public String getSourceRefType() {
        return this.sourceRefType;
    }

    @Override
    @Nullable
    public String getSourceRefTimestampOrHash() {
        return this.sourceRefTimestampOrHash;
    }

    public ImmutableList<String> getContentKeys() {
        return this.contentKeys;
    }

    public final ImmutableRevertContentCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, value, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, value, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withIsDryRun(boolean value) {
        if (this.isDryRun == value) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, value, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withIsAllowDeletes(boolean value) {
        if (this.isAllowDeletes == value) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, value, this.ref, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, value, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withRefType(@Nullable String value) {
        if (Objects.equals(this.refType, value)) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, value, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withSourceRef(@Nullable String value) {
        if (Objects.equals(this.sourceRef, value)) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, value, this.sourceRefType, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withSourceRefType(@Nullable String value) {
        if (Objects.equals(this.sourceRefType, value)) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, value, this.sourceRefTimestampOrHash, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withSourceRefTimestampOrHash(@Nullable String value) {
        if (Objects.equals(this.sourceRefTimestampOrHash, value)) {
            return this;
        }
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, this.sourceRefType, value, this.contentKeys);
    }

    public final ImmutableRevertContentCommandSpec withContentKeys(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, (ImmutableList<String>)newValue);
    }

    public final ImmutableRevertContentCommandSpec withContentKeys(Iterable<String> elements) {
        if (this.contentKeys == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRevertContentCommandSpec(this, this.inCatalog, this.sourceNode, this.isDryRun, this.isAllowDeletes, this.ref, this.refType, this.sourceRef, this.sourceRefType, this.sourceRefTimestampOrHash, (ImmutableList<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRevertContentCommandSpec && this.equalsByValue((ImmutableRevertContentCommandSpec)another);
    }

    private boolean equalsByValue(ImmutableRevertContentCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.isDryRun == another.isDryRun && this.isAllowDeletes == another.isAllowDeletes && Objects.equals(this.ref, another.ref) && Objects.equals(this.refType, another.refType) && Objects.equals(this.sourceRef, another.sourceRef) && Objects.equals(this.sourceRefType, another.sourceRefType) && Objects.equals(this.sourceRefTimestampOrHash, another.sourceRefTimestampOrHash) && this.contentKeys.equals(another.contentKeys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + Booleans.hashCode((boolean)this.isDryRun);
        h += (h << 5) + Booleans.hashCode((boolean)this.isAllowDeletes);
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + Objects.hashCode(this.refType);
        h += (h << 5) + Objects.hashCode(this.sourceRef);
        h += (h << 5) + Objects.hashCode(this.sourceRefType);
        h += (h << 5) + Objects.hashCode(this.sourceRefTimestampOrHash);
        h += (h << 5) + this.contentKeys.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RevertContentCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("isDryRun", this.isDryRun).add("isAllowDeletes", this.isAllowDeletes).add("ref", (Object)this.ref).add("refType", (Object)this.refType).add("sourceRef", (Object)this.sourceRef).add("sourceRefType", (Object)this.sourceRefType).add("sourceRefTimestampOrHash", (Object)this.sourceRefTimestampOrHash).add("contentKeys", this.contentKeys).toString();
    }

    public static ImmutableRevertContentCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, boolean isAllowDeletes, @Nullable String ref, @Nullable String refType, @Nullable String sourceRef, @Nullable String sourceRefType, @Nullable String sourceRefTimestampOrHash, List<String> contentKeys) {
        return ImmutableRevertContentCommandSpec.of(inCatalog, sourceNode, isDryRun, isAllowDeletes, ref, refType, sourceRef, sourceRefType, sourceRefTimestampOrHash, contentKeys);
    }

    public static ImmutableRevertContentCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, boolean isDryRun, boolean isAllowDeletes, @Nullable String ref, @Nullable String refType, @Nullable String sourceRef, @Nullable String sourceRefType, @Nullable String sourceRefTimestampOrHash, Iterable<String> contentKeys) {
        return new ImmutableRevertContentCommandSpec(inCatalog, sourceNode, isDryRun, isAllowDeletes, ref, refType, sourceRef, sourceRefType, sourceRefTimestampOrHash, contentKeys);
    }

    public static ImmutableRevertContentCommandSpec copyOf(RevertContentCommandSpec instance) {
        if (instance instanceof ImmutableRevertContentCommandSpec) {
            return (ImmutableRevertContentCommandSpec)instance;
        }
        return ImmutableRevertContentCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RevertContentCommandSpec", generator="Immutables")
    private final class InitShim {
        private byte sourceNodeBuildStage = 0;
        private Node sourceNode;
        private byte isDryRunBuildStage = 0;
        private boolean isDryRun;
        private byte isAllowDeletesBuildStage = 0;
        private boolean isAllowDeletes;

        private InitShim() {
        }

        Node sourceNode() {
            if (this.sourceNodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodeBuildStage == 0) {
                this.sourceNodeBuildStage = (byte)-1;
                this.sourceNode = ImmutableRevertContentCommandSpec.this.sourceNodeInitialize();
                this.sourceNodeBuildStage = 1;
            }
            return this.sourceNode;
        }

        void sourceNode(Node sourceNode) {
            this.sourceNode = sourceNode;
            this.sourceNodeBuildStage = 1;
        }

        boolean isDryRun() {
            if (this.isDryRunBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDryRunBuildStage == 0) {
                this.isDryRunBuildStage = (byte)-1;
                this.isDryRun = ImmutableRevertContentCommandSpec.this.isDryRunInitialize();
                this.isDryRunBuildStage = 1;
            }
            return this.isDryRun;
        }

        void isDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            this.isDryRunBuildStage = 1;
        }

        boolean isAllowDeletes() {
            if (this.isAllowDeletesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAllowDeletesBuildStage == 0) {
                this.isAllowDeletesBuildStage = (byte)-1;
                this.isAllowDeletes = ImmutableRevertContentCommandSpec.this.isAllowDeletesInitialize();
                this.isAllowDeletesBuildStage = 1;
            }
            return this.isAllowDeletes;
        }

        void isAllowDeletes(boolean isAllowDeletes) {
            this.isAllowDeletes = isAllowDeletes;
            this.isAllowDeletesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sourceNodeBuildStage == -1) {
                attributes.add("sourceNode");
            }
            if (this.isDryRunBuildStage == -1) {
                attributes.add("isDryRun");
            }
            if (this.isAllowDeletesBuildStage == -1) {
                attributes.add("isAllowDeletes");
            }
            return "Cannot build RevertContentCommandSpec, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="RevertContentCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private static final long OPT_BIT_IS_DRY_RUN = 2L;
        private static final long OPT_BIT_IS_ALLOW_DELETES = 4L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private boolean isDryRun;
        private boolean isAllowDeletes;
        private String ref;
        private String refType;
        private String sourceRef;
        private String sourceRefType;
        private String sourceRefTimestampOrHash;
        private ImmutableList.Builder<String> contentKeys = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefWithTypeCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RevertContentCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String refTypeValue;
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
            if (object instanceof RefWithTypeCommandSpec) {
                instance = (RefWithTypeCommandSpec)object;
                if ((bits & 4L) == 0L) {
                    refTypeValue = instance.getRefType();
                    if (refTypeValue != null) {
                        this.refType(refTypeValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RevertContentCommandSpec) {
                String sourceRefValue;
                String sourceRefTimestampOrHashValue;
                instance = (RevertContentCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                this.addAllContentKeys(instance.getContentKeys());
                if ((bits & 4L) == 0L) {
                    refTypeValue = instance.getRefType();
                    if (refTypeValue != null) {
                        this.refType(refTypeValue);
                    }
                    bits |= 4L;
                }
                this.isAllowDeletes(instance.isAllowDeletes());
                this.isDryRun(instance.isDryRun());
                String sourceRefTypeValue = instance.getSourceRefType();
                if (sourceRefTypeValue != null) {
                    this.sourceRefType(sourceRefTypeValue);
                }
                if ((sourceRefTimestampOrHashValue = instance.getSourceRefTimestampOrHash()) != null) {
                    this.sourceRefTimestampOrHash(sourceRefTimestampOrHashValue);
                }
                if ((sourceRefValue = instance.getSourceRef()) != null) {
                    this.sourceRef(sourceRefValue);
                }
                if ((bits & 8L) == 0L) {
                    String inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 8L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDryRun(boolean isDryRun) {
            this.isDryRun = isDryRun;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isAllowDeletes(boolean isAllowDeletes) {
            this.isAllowDeletes = isAllowDeletes;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refType(@Nullable String refType) {
            this.refType = refType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceRef(@Nullable String sourceRef) {
            this.sourceRef = sourceRef;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceRefType(@Nullable String sourceRefType) {
            this.sourceRefType = sourceRefType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceRefTimestampOrHash(@Nullable String sourceRefTimestampOrHash) {
            this.sourceRefTimestampOrHash = sourceRefTimestampOrHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addContentKey(String element) {
            this.contentKeys.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addContentKeys(String ... elements) {
            this.contentKeys.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKeys(Iterable<String> elements) {
            this.contentKeys = ImmutableList.builder();
            return this.addAllContentKeys(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllContentKeys(Iterable<String> elements) {
            this.contentKeys.addAll(elements);
            return this;
        }

        public ImmutableRevertContentCommandSpec build() {
            return new ImmutableRevertContentCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isDryRunIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isAllowDeletesIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }
}

