/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.jsongrammar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.projectnessie.nessie.cli.jsongrammar.InvalidToken;
import org.projectnessie.nessie.cli.jsongrammar.JsonCLexer;
import org.projectnessie.nessie.cli.jsongrammar.Node;
import org.projectnessie.nessie.cli.jsongrammar.TokenSource;
import org.projectnessie.nessie.cli.jsongrammar.ast.BooleanLiteral;
import org.projectnessie.nessie.cli.jsongrammar.ast.Comment;
import org.projectnessie.nessie.cli.jsongrammar.ast.Delimiter;
import org.projectnessie.nessie.cli.jsongrammar.ast.NullLiteral;
import org.projectnessie.nessie.cli.jsongrammar.ast.NumberLiteral;
import org.projectnessie.nessie.cli.jsongrammar.ast.StringLiteral;
import org.projectnessie.nessie.cli.jsongrammar.ast.WHITESPACE;

public class Token
implements CharSequence,
Node.TerminalNode {
    private JsonCLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;

    @Override
    public void truncate(int amount) {
        int newEndOffset = Math.max(this.getBeginOffset(), this.getEndOffset() - amount);
        this.setEndOffset(newEndOffset);
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public JsonCLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (JsonCLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        JsonCLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (Token)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return (Token)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        JsonCLexer ts = this.getTokenSource();
        int beginOffset = this.getBeginOffset();
        int endOffset = this.getEndOffset();
        return ts == null || beginOffset <= 0 && endOffset <= 0 ? null : ts.getText(beginOffset, endOffset);
    }

    protected Token() {
    }

    public Token(TokenType type, JsonCLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, JsonCLexer tokenSource) {
        Token result = Token.newToken(type, tokenSource, 0, 0);
        return result;
    }

    public static Token newToken(TokenType type, String image, JsonCLexer tokenSource) {
        Token newToken = Token.newToken(type, tokenSource);
        return newToken;
    }

    public static Token newToken(TokenType type, JsonCLexer tokenSource, int beginOffset, int endOffset) {
        switch (type.ordinal()) {
            case 2: {
                return new Delimiter(TokenType.COMMA, tokenSource, beginOffset, endOffset);
            }
            case 14: {
                return new NumberLiteral(TokenType.NUMBER, tokenSource, beginOffset, endOffset);
            }
            case 9: {
                return new NullLiteral(TokenType.NULL, tokenSource, beginOffset, endOffset);
            }
            case 11: {
                return new Comment(TokenType.MULTI_LINE_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case 3: {
                return new Delimiter(TokenType.OPEN_BRACKET, tokenSource, beginOffset, endOffset);
            }
            case 4: {
                return new Delimiter(TokenType.CLOSE_BRACKET, tokenSource, beginOffset, endOffset);
            }
            case 7: {
                return new BooleanLiteral(TokenType.TRUE, tokenSource, beginOffset, endOffset);
            }
            case 1: {
                return new Delimiter(TokenType.COLON, tokenSource, beginOffset, endOffset);
            }
            case 10: {
                return new Comment(TokenType.SINGLE_LINE_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case 5: {
                return new Delimiter(TokenType.OPEN_BRACE, tokenSource, beginOffset, endOffset);
            }
            case 6: {
                return new Delimiter(TokenType.CLOSE_BRACE, tokenSource, beginOffset, endOffset);
            }
            case 12: {
                return new WHITESPACE(TokenType.WHITESPACE, tokenSource, beginOffset, endOffset);
            }
            case 8: {
                return new BooleanLiteral(TokenType.FALSE, tokenSource, beginOffset, endOffset);
            }
            case 13: {
                return new StringLiteral(TokenType.STRING_LITERAL, tokenSource, beginOffset, endOffset);
            }
            case 16: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        return this.toString();
    }

    @Override
    public String toString() {
        String result = this.getSource();
        if (result == null) {
            result = this.getType().getLiteralString();
        }
        return result;
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        COLON(":"),
        COMMA(","),
        OPEN_BRACKET("["),
        CLOSE_BRACKET("]"),
        OPEN_BRACE("{"),
        CLOSE_BRACE("}"),
        TRUE("true"),
        FALSE("false"),
        NULL("null"),
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        WHITESPACE,
        STRING_LITERAL,
        NUMBER,
        DUMMY,
        INVALID;

        private String literalString;

        private TokenType() {
        }

        private TokenType(String literalString) {
            this.literalString = literalString;
        }

        @Override
        public String getLiteralString() {
            return this.literalString;
        }

        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

