/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.CreateNamespaceCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@Generated(from="CreateNamespaceCommandSpec", generator="Immutables")
public final class ImmutableCreateNamespaceCommandSpec
implements CreateNamespaceCommandSpec {
    @Nullable
    private final String inCatalog;
    @Nullable
    private final Node sourceNode;
    private final String namespace;
    @Nullable
    private final String ref;
    private final ImmutableMap<String, String> setProperties;

    private ImmutableCreateNamespaceCommandSpec(@Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, Map<String, ? extends String> setProperties) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.ref = ref;
        this.setProperties = ImmutableMap.copyOf(setProperties);
    }

    private ImmutableCreateNamespaceCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.namespace = builder.namespace;
        this.ref = builder.ref;
        this.setProperties = builder.setProperties.build();
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : CreateNamespaceCommandSpec.super.sourceNode();
    }

    private ImmutableCreateNamespaceCommandSpec(ImmutableCreateNamespaceCommandSpec original, @Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, ImmutableMap<String, String> setProperties) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.namespace = namespace;
        this.ref = ref;
        this.setProperties = setProperties;
    }

    @Override
    @Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    public ImmutableMap<String, String> setProperties() {
        return this.setProperties;
    }

    public final ImmutableCreateNamespaceCommandSpec withInCatalog(@Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableCreateNamespaceCommandSpec(this, value, this.sourceNode, this.namespace, this.ref, this.setProperties);
    }

    public final ImmutableCreateNamespaceCommandSpec withSourceNode(@Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableCreateNamespaceCommandSpec(this, this.inCatalog, value, this.namespace, this.ref, this.setProperties);
    }

    public final ImmutableCreateNamespaceCommandSpec withNamespace(String value) {
        String newValue = Objects.requireNonNull(value, "namespace");
        if (this.namespace.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.ref, this.setProperties);
    }

    public final ImmutableCreateNamespaceCommandSpec withRef(@Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableCreateNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, this.namespace, value, this.setProperties);
    }

    public final ImmutableCreateNamespaceCommandSpec withSetProperties(Map<String, ? extends String> entries) {
        if (this.setProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCreateNamespaceCommandSpec(this, this.inCatalog, this.sourceNode, this.namespace, this.ref, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateNamespaceCommandSpec && this.equalsByValue((ImmutableCreateNamespaceCommandSpec)another);
    }

    private boolean equalsByValue(ImmutableCreateNamespaceCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.namespace.equals(another.namespace) && Objects.equals(this.ref, another.ref) && this.setProperties.equals(another.setProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.namespace.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        h += (h << 5) + this.setProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateNamespaceCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("namespace", (Object)this.namespace).add("ref", (Object)this.ref).add("setProperties", this.setProperties).toString();
    }

    public static ImmutableCreateNamespaceCommandSpec of(@Nullable String inCatalog, @Nullable Node sourceNode, String namespace, @Nullable String ref, Map<String, ? extends String> setProperties) {
        return new ImmutableCreateNamespaceCommandSpec(inCatalog, sourceNode, namespace, ref, setProperties);
    }

    public static ImmutableCreateNamespaceCommandSpec copyOf(CreateNamespaceCommandSpec instance) {
        if (instance instanceof ImmutableCreateNamespaceCommandSpec) {
            return (ImmutableCreateNamespaceCommandSpec)instance;
        }
        return ImmutableCreateNamespaceCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateNamespaceCommandSpec", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 1L;
        private long optBits;
        private String inCatalog;
        private Node sourceNode;
        private String namespace;
        private String ref;
        private ImmutableMap.Builder<String, String> setProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateNamespaceCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String inCatalogValue;
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 4L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof CreateNamespaceCommandSpec) {
                instance = (CreateNamespaceCommandSpec)object;
                this.namespace(instance.getNamespace());
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 4L;
                }
                this.putAllSetProperties(instance.setProperties());
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(String namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@Nullable String ref) {
            this.ref = ref;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetProperty(String key, String value) {
            this.setProperties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSetProperty(Map.Entry<String, ? extends String> entry) {
            this.setProperties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setProperties(Map<String, ? extends String> entries) {
            this.setProperties = ImmutableMap.builder();
            return this.putAllSetProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSetProperties(Map<String, ? extends String> entries) {
            this.setProperties.putAll(entries);
            return this;
        }

        public ImmutableCreateNamespaceCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateNamespaceCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            return "Cannot build CreateNamespaceCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

